/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.service;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.exception.CSWarnException;
import org.apache.linkis.cs.server.protocol.HttpRequestProtocol;
import org.apache.linkis.cs.server.protocol.HttpResponseProtocol;
import org.apache.linkis.cs.server.protocol.RestResponseProtocol;
import org.apache.linkis.cs.server.scheduler.HttpAnswerJob;
import org.apache.linkis.cs.server.scheduler.HttpJob;
import org.apache.linkis.cs.server.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService
implements Service {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean ifAccept(HttpJob job) {
        return this.getName().equals(job.getRequestProtocol().getServiceName());
    }

    @Override
    public void accept(HttpJob job) throws CSWarnException {
        try {
            HttpRequestProtocol protocol = job.getRequestProtocol();
            Object[] params = protocol.getRequestObjects();
            String method = protocol.getServiceMethod().name().toUpperCase();
            Method[] methods = this.getClass().getMethods();
            Optional<Method> first = Arrays.stream(methods).filter(f -> f.getName().toUpperCase().contains(method)).filter(f -> f.getParameterTypes().length == params.length).filter(f -> this.judgeMethod((Method)f, params)).findFirst();
            Object response = first.orElseThrow(() -> new CSErrorException(97000, "can not find a method to invoke")).invoke((Object)this, params);
            if (job instanceof HttpAnswerJob) {
                HttpResponseProtocol responseProtocol = ((HttpAnswerJob)job).getResponseProtocol();
                if (responseProtocol instanceof RestResponseProtocol) {
                    ((RestResponseProtocol)responseProtocol).ok(null);
                }
                responseProtocol.setResponseData(response);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("execute %s service failed:", this.getName()), (Throwable)e);
            throw new CSWarnException(97000, e.getMessage());
        }
    }

    private boolean judgeMethod(Method method, Object ... objects) {
        boolean flag = true;
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (null == parameterTypes[i] || null == objects[i] || parameterTypes[i].isAssignableFrom(objects[i].getClass())) continue;
            flag = false;
            break;
        }
        return flag;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
    }

    @Override
    public void close() throws IOException {
    }
}

