/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.restful;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.entity.history.ContextHistory;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.errorcode.LinkisCsServerErrorCodeSummary;
import org.apache.linkis.cs.server.enumeration.ServiceType;
import org.apache.linkis.cs.server.restful.ContextIDRestfulApi;
import org.apache.linkis.cs.server.restful.CsRestfulParent;
import org.apache.linkis.cs.server.service.ContextHistoryService;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"cs(contextservice) history operation"})
@RestController
@RequestMapping(path={"/contextservice"})
public class ContextHistoryRestfulApi
implements CsRestfulParent {
    private static final Logger logger = LoggerFactory.getLogger(ContextIDRestfulApi.class);
    @Autowired
    private ContextHistoryService contextHistoryService;
    private ObjectMapper objectMapper = new ObjectMapper();

    @ApiOperation(value="createHistory", notes="create context history", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextHistory", required=true, dataType="String"), @ApiImplicitParam(name="contextID", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"createHistory"}, method={RequestMethod.POST})
    public Message createHistory(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        ContextHistory history = this.getContextHistoryFromJsonNode(jsonNode);
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isBlank((CharSequence)history.getSource())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "history source"));
        }
        if (StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("createHistory,contextID:" + contextID.getContextId()));
        this.contextHistoryService.createHistroy(contextID, history);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="removeHistory", notes="remove context history", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextHistory", dataType="String"), @ApiImplicitParam(name="contextID", dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"removeHistory"}, method={RequestMethod.POST})
    public Message removeHistory(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        ContextHistory history = this.getContextHistoryFromJsonNode(jsonNode);
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isBlank((CharSequence)history.getSource())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "history source"));
        }
        if (StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("removeHistory,contextID:" + contextID.getContextId()));
        this.contextHistoryService.removeHistory(contextID, history);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="getHistories", notes="get content history list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextID", dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"getHistories"}, method={RequestMethod.POST})
    public Message getHistories(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getHistory,contextID:" + contextID.getContextId()));
        List<ContextHistory> history = this.contextHistoryService.getHistories(contextID);
        return this.generateMessage(history, "contextHistory");
    }

    @ApiOperation(value="GetHistory", notes="get context history", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextID", required=true, dataType="String"), @ApiImplicitParam(name="source", required=false, dataType="String", value="source")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"getHistory"}, method={RequestMethod.POST})
    public Message getHistory(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        String source = jsonNode.get("source").textValue();
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isBlank((CharSequence)source)) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "history source"));
        }
        if (StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getHistory,contextID:" + contextID.getContextId()));
        ContextHistory history = this.contextHistoryService.getHistory(contextID, source);
        return this.generateMessage(history, "contextHistory");
    }

    @ApiOperation(value="searchHistory", notes="search history", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextID", required=true, dataType="String"), @ApiImplicitParam(name="keywords", dataType="String", value="key words")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"searchHistory"}, method={RequestMethod.POST})
    public Message searchHistory(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        String[] keywords = (String[])this.objectMapper.treeToValue((TreeNode)jsonNode.get("keywords"), String[].class);
        if (StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("searchHistory,contextID:" + contextID.getContextId()));
        List<ContextHistory> history = this.contextHistoryService.searchHistory(contextID, keywords);
        return this.generateMessage(history, "contextHistory");
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.CONTEXT_HISTORY;
    }
}

