/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.restful;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceType;
import org.apache.linkis.datasourcemanager.common.errorcode.LinkisDatasourceManagerErrorCodeSummary;
import org.apache.linkis.datasourcemanager.core.formdata.FormDataTransformerFactory;
import org.apache.linkis.datasourcemanager.core.formdata.MultiPartFormDataTransformer;
import org.apache.linkis.datasourcemanager.core.restful.RestfulApiHelper;
import org.apache.linkis.datasourcemanager.core.service.DataSourceInfoService;
import org.apache.linkis.datasourcemanager.core.service.DataSourceRelateService;
import org.apache.linkis.datasourcemanager.core.service.MetadataOperateService;
import org.apache.linkis.datasourcemanager.core.service.hooks.DataSourceParamsHook;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidateException;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidator;
import org.apache.linkis.metadata.query.common.MdmConfiguration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"data source operate restful api"})
@RestController
@RequestMapping(value={"/data-source-manager/op/"}, produces={"application/json"})
public class DataSourceOperateRestfulApi {
    @Autowired
    private MetadataOperateService metadataOperateService;
    @Autowired
    private DataSourceRelateService dataSourceRelateService;
    @Autowired
    private DataSourceInfoService dataSourceInfoService;
    @Autowired
    private ParameterValidator parameterValidator;
    @Autowired
    private Validator beanValidator;
    @Autowired
    private List<DataSourceParamsHook> dataSourceParamsHooks = new ArrayList<DataSourceParamsHook>();
    private MultiPartFormDataTransformer formDataTransformer;

    @PostConstruct
    public void initRestful() {
        this.formDataTransformer = FormDataTransformerFactory.buildCustom();
    }

    @ApiOperation(value="connect", notes="connect", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"dataSource"})
    @RequestMapping(value={"/connect/json"}, method={RequestMethod.POST})
    public Message connect(@RequestBody DataSource dataSource, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String operator = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"do connect");
            Set result = this.beanValidator.validate((Object)dataSource, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            this.doConnect(operator, dataSource);
            return Message.ok().data("ok", (Object)true);
        }, "");
    }

    protected void doConnect(String operator, DataSource dataSource) throws ErrorException {
        if (dataSource.getConnectParams().containsKey("envId")) {
            try {
                this.dataSourceInfoService.addEnvParamsToDataSource(Long.parseLong(dataSource.getConnectParams().get("envId").toString()), dataSource);
            }
            catch (Exception e) {
                throw new ParameterValidateException(LinkisDatasourceManagerErrorCodeSummary.ENVID_ATYPICAL.getErrorDesc() + e);
            }
        }
        List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSource.getDataSourceTypeId());
        dataSource.setKeyDefinitions(keyDefinitionList);
        Map connectParams = dataSource.getConnectParams();
        this.parameterValidator.validate(keyDefinitionList, connectParams);
        for (DataSourceParamsHook hook : this.dataSourceParamsHooks) {
            hook.beforePersist(connectParams, keyDefinitionList);
        }
        DataSourceType dataSourceType = this.dataSourceRelateService.getDataSourceType(dataSource.getDataSourceTypeId());
        this.metadataOperateService.doRemoteConnect((String)MdmConfiguration.METADATA_SERVICE_APPLICATION.getValue(), dataSourceType.getName().toLowerCase(), operator, dataSource.getConnectParams());
    }
}

