/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.utils;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.linkis.common.io.FsPath;

public class ResultSetUtils {
    public static Comparator<FsPath> getResultSetFileComparatorOrderByNameNum() {
        Comparator comparator = (o1, o2) -> {
            String regx = "\\d+";
            String[] res1 = o1.getPath().split(File.separator);
            String fileName1 = res1[res1.length - 1];
            Matcher matcher1 = Pattern.compile(regx).matcher(fileName1);
            int num1 = matcher1.find() ? Integer.parseInt(matcher1.group()) : Integer.MAX_VALUE;
            String[] res2 = o2.getPath().split(File.separator);
            String fileName2 = res2[res2.length - 1];
            Matcher matcher2 = Pattern.compile(regx).matcher(fileName2);
            int num2 = matcher2.find() ? Integer.parseInt(matcher2.group()) : Integer.MAX_VALUE;
            return num1 - num2;
        };
        return comparator;
    }

    public static void sortByNameNum(List<FsPath> fsPathList) {
        Collections.sort(fsPathList, ResultSetUtils.getResultSetFileComparatorOrderByNameNum());
    }
}

