/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.configuration.constant.Constants;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.dws.authentication.TokenAuthenticationStrategy;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;
import org.apache.linkis.httpclient.dws.config.DWSClientConfigBuilder;
import org.apache.linkis.ujes.client.UJESClientImpl;
import org.apache.linkis.ujes.client.request.EmsListAction;
import org.apache.linkis.ujes.client.response.EmsListResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClientUtil.class);
    public static DWSClientConfig dwsClientConfig = ClientUtil.createClientConfig(null, null);
    public static UJESClientImpl client = new UJESClientImpl(dwsClientConfig);

    public static Map<String, Object> getEcmList(String url, Map<String, Object> properties) throws IOException {
        if (null == dwsClientConfig) {
            dwsClientConfig = ClientUtil.createClientConfig(url, properties);
        }
        if (null == client) {
            client = new UJESClientImpl(dwsClientConfig);
        }
        EmsListAction build = EmsListAction.newBuilder().setUser("hadoop").build();
        EmsListResult result = client.listECM(build);
        return result.getResultMap();
    }

    public static Map<String, Object> getEcmList() throws IOException {
        return ClientUtil.getEcmList(null, null);
    }

    private static DWSClientConfig createClientConfig(String url, Map<String, Object> properties) {
        String realUrl = "";
        realUrl = StringUtils.isBlank((CharSequence)url) ? Configuration.getGateWayURL() : url;
        Map<Object, Object> parms = new HashMap();
        if (MapUtils.isNotEmpty(properties)) {
            parms = properties;
        }
        int maxConnection = (Integer)parms.getOrDefault(Constants.CONNECTION_MAX_SIZE_SHORT_NAME(), Constants.CONNECTION_MAX_SIZE().getValue());
        int connectTimeout = (Integer)parms.getOrDefault(Constants.CONNECTION_TIMEOUT_SHORT_NAME(), Constants.CONNECTION_TIMEOUT().getValue());
        int readTimeout = (Integer)parms.getOrDefault(Constants.CONNECTION_READ_TIMEOUT_SHORT_NAME(), Constants.CONNECTION_READ_TIMEOUT().getValue());
        String tokenKey = (String)parms.getOrDefault(Constants.AUTH_TOKEN_KEY_SHORT_NAME(), Constants.AUTH_TOKEN_KEY().getValue());
        String tokenValue = (String)parms.getOrDefault(Constants.AUTH_TOKEN_VALUE_SHORT_NAME(), Constants.AUTH_TOKEN_VALUE().getValue());
        DWSClientConfig clientConfig = ((DWSClientConfigBuilder)DWSClientConfigBuilder.newBuilder().addServerUrl(realUrl).connectionTimeout((long)connectTimeout).discoveryEnabled(false).discoveryFrequency(1L, TimeUnit.MINUTES).loadbalancerEnabled(false).maxConnectionSize(maxConnection).retryEnabled(false).readTimeout((long)readTimeout).setAuthenticationStrategy((AuthenticationStrategy)new TokenAuthenticationStrategy()).setAuthTokenKey(tokenKey).setAuthTokenValue(tokenValue)).setDWSVersion("v1").build();
        return clientConfig;
    }
}

