/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.common.io.NonSyncByteArrayInputStream;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedUDAFs;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFBloomFilter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFBloomFilterMerge;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.BloomKFilter;

public class GenericUDAFBloomFilter
implements GenericUDAFResolver2 {
    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        return new GenericUDAFBloomFilterEvaluator();
    }

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        return new GenericUDAFBloomFilterEvaluator();
    }

    @VectorizedUDAFs(value={VectorUDAFBloomFilter.class, VectorUDAFBloomFilterMerge.class})
    public static class GenericUDAFBloomFilterEvaluator
    extends GenericUDAFEvaluator {
        private SelectOperator sourceOperator;
        private long hintEntries = -1L;
        private long maxEntries = 0L;
        private long minEntries = 0L;
        private float factor = 1.0f;
        private PrimitiveObjectInspector inputOI;
        private final ByteArrayOutputStream result = new ByteArrayOutputStream();
        private transient byte[] scratchBuffer = new byte[79];

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            }
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }

        @Override
        public int estimate() {
            long entries = Math.min(this.getExpectedEntries(), this.maxEntries);
            long numBits = (long)((double)(-entries) * Math.log(0.05f) / (Math.log(2.0) * Math.log(2.0)));
            int nLongs = (int)Math.ceil((double)numBits / 64.0);
            int padLongs = 8 - nLongs % 8;
            return (nLongs + padLongs) * 64 / 8;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((BloomFilterBuf)agg).bloomFilter.reset();
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            long expectedEntries = this.getExpectedEntries();
            if (expectedEntries < 0L) {
                throw new IllegalStateException("BloomFilter expectedEntries not initialized");
            }
            BloomFilterBuf buf = new BloomFilterBuf(expectedEntries, this.maxEntries);
            this.reset(buf);
            return buf;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            if (parameters == null || parameters[0] == null) {
                return;
            }
            BloomKFilter bf = ((BloomFilterBuf)agg).bloomFilter;
            switch (this.inputOI.getPrimitiveCategory()) {
                case BOOLEAN: {
                    boolean vBoolean = ((BooleanObjectInspector)this.inputOI).get(parameters[0]);
                    bf.addLong(vBoolean ? 1L : 0L);
                    break;
                }
                case BYTE: {
                    byte vByte = ((ByteObjectInspector)this.inputOI).get(parameters[0]);
                    bf.addLong(vByte);
                    break;
                }
                case SHORT: {
                    short vShort = ((ShortObjectInspector)this.inputOI).get(parameters[0]);
                    bf.addLong(vShort);
                    break;
                }
                case INT: {
                    int vInt = ((IntObjectInspector)this.inputOI).get(parameters[0]);
                    bf.addLong(vInt);
                    break;
                }
                case LONG: {
                    long vLong = ((LongObjectInspector)this.inputOI).get(parameters[0]);
                    bf.addLong(vLong);
                    break;
                }
                case FLOAT: {
                    float vFloat = ((FloatObjectInspector)this.inputOI).get(parameters[0]);
                    bf.addDouble(vFloat);
                    break;
                }
                case DOUBLE: {
                    double vDouble = ((DoubleObjectInspector)this.inputOI).get(parameters[0]);
                    bf.addDouble(vDouble);
                    break;
                }
                case DECIMAL: {
                    HiveDecimalWritable vDecimal = ((HiveDecimalObjectInspector)this.inputOI).getPrimitiveWritableObject(parameters[0]);
                    int startIdx = vDecimal.toBytes(this.scratchBuffer);
                    bf.addBytes(this.scratchBuffer, startIdx, this.scratchBuffer.length - startIdx);
                    break;
                }
                case DATE: {
                    DateWritableV2 vDate = ((DateObjectInspector)this.inputOI).getPrimitiveWritableObject(parameters[0]);
                    bf.addLong(vDate.getDays());
                    break;
                }
                case TIMESTAMP: {
                    Timestamp vTimeStamp = ((TimestampObjectInspector)this.inputOI).getPrimitiveJavaObject(parameters[0]);
                    bf.addLong(vTimeStamp.toEpochMilli());
                    break;
                }
                case CHAR: {
                    Text vChar = ((HiveCharObjectInspector)this.inputOI).getPrimitiveWritableObject(parameters[0]).getStrippedValue();
                    bf.addBytes(vChar.getBytes(), 0, vChar.getLength());
                    break;
                }
                case VARCHAR: {
                    Text vVarChar = ((HiveVarcharObjectInspector)this.inputOI).getPrimitiveWritableObject(parameters[0]).getTextValue();
                    bf.addBytes(vVarChar.getBytes(), 0, vVarChar.getLength());
                    break;
                }
                case STRING: {
                    Text vString = ((StringObjectInspector)this.inputOI).getPrimitiveWritableObject(parameters[0]);
                    bf.addBytes(vString.getBytes(), 0, vString.getLength());
                    break;
                }
                case BINARY: {
                    BytesWritable vBytes = ((BinaryObjectInspector)this.inputOI).getPrimitiveWritableObject(parameters[0]);
                    bf.addBytes(vBytes.getBytes(), 0, vBytes.getLength());
                    break;
                }
                default: {
                    throw new UDFArgumentTypeException(0, "Bad primitive category " + (Object)((Object)this.inputOI.getPrimitiveCategory()));
                }
            }
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            BytesWritable bytes = (BytesWritable)partial;
            NonSyncByteArrayInputStream in = new NonSyncByteArrayInputStream(bytes.getBytes());
            try {
                BloomKFilter bf = BloomKFilter.deserialize(in);
                ((BloomFilterBuf)agg).bloomFilter.merge(bf);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            finally {
                IOUtils.closeStream((Closeable)in);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            this.result.reset();
            try {
                BloomKFilter.serialize(this.result, ((BloomFilterBuf)agg).bloomFilter);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            finally {
                IOUtils.closeStream((Closeable)this.result);
            }
            return new BytesWritable(this.result.toByteArray());
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        public long getExpectedEntries() {
            if (this.hintEntries > 0L) {
                return this.hintEntries;
            }
            long expectedEntries = -1L;
            if (this.sourceOperator != null && this.sourceOperator.getStatistics() != null) {
                Statistics stats = this.sourceOperator.getStatistics();
                expectedEntries = stats.getNumRows();
                switch (stats.getColumnStatsState()) {
                    case COMPLETE: 
                    case PARTIAL: {
                        long ndv;
                        List<ColStatistics> colStats = stats.getColumnStats();
                        ExprNodeColumnDesc colExpr = ExprNodeDescUtils.getColumnExpr(((SelectDesc)this.sourceOperator.getConf()).getColList().get(0));
                        if (colExpr == null || stats.getColumnStatisticsFromColName(colExpr.getColumn()) == null || (ndv = stats.getColumnStatisticsFromColName(colExpr.getColumn()).getCountDistint()) <= 0L) break;
                        expectedEntries = ndv;
                        break;
                    }
                }
            }
            expectedEntries = (expectedEntries = (long)((float)expectedEntries * this.factor)) > this.minEntries ? expectedEntries : this.minEntries;
            return expectedEntries;
        }

        public Operator<?> getSourceOperator() {
            return this.sourceOperator;
        }

        public void setSourceOperator(SelectOperator sourceOperator) {
            this.sourceOperator = sourceOperator;
        }

        public void setHintEntries(long hintEntries) {
            this.hintEntries = hintEntries;
        }

        public boolean hasHintEntries() {
            return this.hintEntries != -1L;
        }

        public void setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
        }

        public void setMinEntries(long minEntries) {
            this.minEntries = minEntries;
        }

        public long getMinEntries() {
            return this.minEntries;
        }

        public void setFactor(float factor) {
            this.factor = factor;
        }

        public float getFactor() {
            return this.factor;
        }

        @Override
        public String getExprString() {
            return "expectedEntries=" + this.getExpectedEntries();
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class BloomFilterBuf
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            BloomKFilter bloomFilter;

            public BloomFilterBuf(long expectedEntries, long maxEntries) {
                this.bloomFilter = expectedEntries > maxEntries ? new BloomKFilter(maxEntries) : new BloomKFilter(expectedEntries);
            }

            @Override
            public int estimate() {
                return (int)this.bloomFilter.sizeInBytes();
            }
        }
    }
}

