/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.springcloud.handler;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.DefaultErrorAttributes;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ResponseStatusException;

@Component
public class CustomErrorAttributes
extends DefaultErrorAttributes {
    public Map<String, Object> getErrorAttributes(ServerRequest request, ErrorAttributeOptions options) {
        Throwable throwable = this.getError(request);
        MergedAnnotation responseStatusAnnotation = MergedAnnotations.from(throwable.getClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ResponseStatus.class);
        HttpStatus errorStatus = this.determineHttpStatus(throwable, (MergedAnnotation<ResponseStatus>)responseStatusAnnotation);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", request.path());
        map.put("status", errorStatus.value());
        String msg = errorStatus.getReasonPhrase();
        if (errorStatus.value() >= HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            msg = msg + ", with request path:" + request.path();
        }
        map.put("message", msg);
        map.put("data", Lists.newArrayList());
        return map;
    }

    private HttpStatus determineHttpStatus(Throwable error, MergedAnnotation<ResponseStatus> responseStatusAnnotation) {
        if (error instanceof ResponseStatusException) {
            return ((ResponseStatusException)error).getStatus();
        }
        return responseStatusAnnotation.getValue("code", HttpStatus.class).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

