/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.client.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.linkis.bml.client.AbstractBmlClient;
import org.apache.linkis.bml.client.errorcode.BmlClientErrorCodeSummary;
import org.apache.linkis.bml.common.BmlClientFailException;
import org.apache.linkis.bml.common.POSTResultNotMatchException;
import org.apache.linkis.bml.conf.BmlConfiguration$;
import org.apache.linkis.bml.http.HttpConf$;
import org.apache.linkis.bml.protocol.BmlAttachResourceAndProjectResponse;
import org.apache.linkis.bml.protocol.BmlChangeOwnerResponse;
import org.apache.linkis.bml.protocol.BmlCopyResourceResponse;
import org.apache.linkis.bml.protocol.BmlCreateProjectResponse;
import org.apache.linkis.bml.protocol.BmlDeleteResponse;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.bml.protocol.BmlProjectInfoResponse;
import org.apache.linkis.bml.protocol.BmlProjectPrivResponse;
import org.apache.linkis.bml.protocol.BmlRelateResponse;
import org.apache.linkis.bml.protocol.BmlResourceInfoResponse;
import org.apache.linkis.bml.protocol.BmlResourceVersionsResponse;
import org.apache.linkis.bml.protocol.BmlRollbackVersionResponse;
import org.apache.linkis.bml.protocol.BmlUpdateProjectPrivResponse;
import org.apache.linkis.bml.protocol.BmlUpdateResponse;
import org.apache.linkis.bml.protocol.BmlUploadResponse;
import org.apache.linkis.bml.protocol.ResourceVersions;
import org.apache.linkis.bml.request.BmlAttachAction;
import org.apache.linkis.bml.request.BmlChangeOwnerAction;
import org.apache.linkis.bml.request.BmlCopyResourceAction;
import org.apache.linkis.bml.request.BmlDeleteAction;
import org.apache.linkis.bml.request.BmlDownloadAction;
import org.apache.linkis.bml.request.BmlDownloadShareAction;
import org.apache.linkis.bml.request.BmlGetVersionsAction;
import org.apache.linkis.bml.request.BmlRollbackVersionAction;
import org.apache.linkis.bml.request.BmlUpdateAction;
import org.apache.linkis.bml.request.BmlUpdateShareResourceAction;
import org.apache.linkis.bml.request.BmlUploadAction;
import org.apache.linkis.bml.request.BmlUploadShareResourceAction;
import org.apache.linkis.bml.request.CreateBmlProjectAction;
import org.apache.linkis.bml.request.UpdateBmlProjectAction;
import org.apache.linkis.bml.response.BmlAttachResult;
import org.apache.linkis.bml.response.BmlCopyResourceResult;
import org.apache.linkis.bml.response.BmlCreateBmlProjectResult;
import org.apache.linkis.bml.response.BmlDeleteResult;
import org.apache.linkis.bml.response.BmlResourceVersionResult;
import org.apache.linkis.bml.response.BmlResult;
import org.apache.linkis.bml.response.BmlRollbackVersionResult;
import org.apache.linkis.bml.response.BmlUpdateProjectResult;
import org.apache.linkis.bml.response.BmlUpdateResult;
import org.apache.linkis.bml.response.BmlUpdateShareResourceResult;
import org.apache.linkis.bml.response.BmlUploadResult;
import org.apache.linkis.bml.response.BmlUploadShareResourceResult;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.config.ClientConfig;
import org.apache.linkis.httpclient.config.ClientConfigBuilder$;
import org.apache.linkis.httpclient.dws.DWSHttpClient;
import org.apache.linkis.httpclient.dws.authentication.TokenAuthenticationStrategy;
import org.apache.linkis.httpclient.dws.config.DWSClientConfig;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.httpclient.response.Result;
import org.apache.linkis.storage.FSFactory$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%h\u0001\u0002\u00192\u0001yB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005/\"AA\r\u0001B\u0001B\u0003%Q\rC\u0003r\u0001\u0011\u0005!\u000fC\u0003r\u0001\u0011\u0005\u0001\u0010C\u0003r\u0001\u0011\u0005!\u0010C\u0003r\u0001\u0011\u00051\u0010C\u0003r\u0001\u0011\u0005Q\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u0011q\u0002\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u0011Q\u0004\u0001!\u0002\u0013\t)\u0002C\u0005\u0002 \u0001\u0011\r\u0011\"\u0001\u0002\u0004!A\u0011\u0011\u0005\u0001!\u0002\u0013\t)\u0001C\u0004\u0002$\u0001!I!!\n\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011q\u0005\u0001\u0005B\u0005}\u0002bBA\u0014\u0001\u0011\u0005\u00131\n\u0005\n\u0003C\u0002\u0011\u0013!C\u0001\u0003GBq!!\u001f\u0001\t\u0003\nY\bC\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u0002d!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAE\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003g\u0003A\u0011IA[\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bDq!!5\u0001\t\u0003\n\u0019\u000eC\u0004\u0002`\u0002!I!!9\t\u000f\u0005E\u0007\u0001\"\u0011\u0002f\"9\u0011Q\u001e\u0001\u0005B\u0005=\bbBAw\u0001\u0011\u0005\u0013Q \u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0011\u001d\u0011Y\u0001\u0001C!\u0005\u001bAqAa\u000b\u0001\t\u0003\u0012i\u0003C\u0004\u0003,\u0001!\tEa\u000e\t\u000f\u0005e\u0004\u0001\"\u0011\u0003@!9\u0011\u0011\u0010\u0001\u0005B\t\u001d\u0003b\u0002B'\u0001\u0011\u0005#q\n\u0005\b\u0005\u001b\u0002A\u0011\tB-\u0011\u001d\u0011\t\u0007\u0001C!\u0005GBqA!\u001c\u0001\t\u0003\u0012y\u0007C\u0004\u0003z\u0001!\tEa\u001f\t\u000f\t\u0015\u0005\u0001\"\u0011\u0003\b\"9!1\u0013\u0001\u0005B\tU\u0005b\u0002BT\u0001\u0011\u0005#\u0011\u0016\u0005\b\u0005w\u0003A\u0011\tB_\u0011\u001d\u0011y\r\u0001C!\u0005#DqAa8\u0001\t\u0003\u0012\tOA\u0007IiR\u0004()\u001c7DY&,g\u000e\u001e\u0006\u0003eM\nA![7qY*\u0011A'N\u0001\u0007G2LWM\u001c;\u000b\u0005Y:\u0014a\u00012nY*\u0011\u0001(O\u0001\u0007Y&t7.[:\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\u0002\u0001'\r\u0001qh\u0011\t\u0003\u0001\u0006k\u0011aM\u0005\u0003\u0005N\u0012\u0011#\u00112tiJ\f7\r\u001e\"nY\u000ec\u0017.\u001a8u!\t!\u0015*D\u0001F\u0015\t1u)A\u0003vi&d7O\u0003\u0002Io\u000511m\\7n_:L!AS#\u0003\u000f1{wmZ5oO\u0006a1\r\\5f]R\u001cuN\u001c4jOB\u0011Q\nV\u0007\u0002\u001d*\u0011q\nU\u0001\u0007G>tg-[4\u000b\u0005E\u0013\u0016a\u00013xg*\u00111kN\u0001\u000bQR$\bo\u00197jK:$\u0018BA+O\u0005=!ukU\"mS\u0016tGoQ8oM&<\u0017!C:feZ,'/\u0016:m!\tA\u0016M\u0004\u0002Z?B\u0011!,X\u0007\u00027*\u0011A,P\u0001\u0007yI|w\u000e\u001e \u000b\u0003y\u000bQa]2bY\u0006L!\u0001Y/\u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003Av\u000b!\u0002\u001d:pa\u0016\u0014H/[3t!\u001117nV7\u000e\u0003\u001dT!\u0001[5\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0006!!.\u0019<b\u0013\tawMA\u0002NCB\u0004\"A\\8\u000e\u0003uK!\u0001]/\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0005gV4x\u000f\u0005\u0002u\u00015\t\u0011\u0007C\u0003L\t\u0001\u0007A\nC\u0003W\t\u0001\u0007q\u000bC\u0003e\t\u0001\u0007Q\r\u0006\u0002ts\")a+\u0002a\u0001/R\t1\u000f\u0006\u0002ty\")1j\u0002a\u0001\u0019R\u00191O`@\t\u000bYC\u0001\u0019A,\t\u000b\u0011D\u0001\u0019A3\u0002\u0015\rd\u0017.\u001a8u\u001d\u0006lW-\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f%\fA\u0001\\1oO&\u0019!-!\u0003\u0002\u0017\rd\u0017.\u001a8u\u001d\u0006lW\rI\u0001\nI^\u001c8\t\\5f]R,\"!!\u0006\u0011\t\u0005]\u0011\u0011D\u0007\u0002!&\u0019\u00111\u0004)\u0003\u001b\u0011;6\u000b\u0013;ua\u000ec\u0017.\u001a8u\u0003)!wo]\"mS\u0016tG\u000fI\u0001\u000e\r&\u00136\u000bV0W\u000bJ\u001b\u0016j\u0014(\u0002\u001d\u0019K%k\u0015+`-\u0016\u00136+S(OA\u0005\u00112M]3bi\u0016\u001cE.[3oi\u000e{gNZ5h)\u0005a\u0015\u0001\u00053po:dw.\u00193SKN|WO]2f)\u0019\tY#a\u000e\u0002<A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022U\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003k\tyCA\nC[2$un\u001e8m_\u0006$'+Z:q_:\u001cX\r\u0003\u0004\u0002:A\u0001\raV\u0001\u0005kN,'\u000f\u0003\u0004\u0002>A\u0001\raV\u0001\u000be\u0016\u001cx.\u001e:dK&#E\u0003CA\u0016\u0003\u0003\n\u0019%a\u0012\t\r\u0005e\u0012\u00031\u0001X\u0011\u0019\t)%\u0005a\u0001/\u0006Q!/Z:pkJ\u001cW-\u00133\t\r\u0005%\u0013\u00031\u0001X\u0003\u001d1XM]:j_:$B\"a\u000b\u0002N\u0005=\u0013\u0011KA*\u0003/Ba!!\u000f\u0013\u0001\u00049\u0006BBA#%\u0001\u0007q\u000b\u0003\u0004\u0002JI\u0001\ra\u0016\u0005\u0007\u0003+\u0012\u0002\u0019A,\u0002\tA\fG\u000f\u001b\u0005\n\u00033\u0012\u0002\u0013!a\u0001\u00037\n\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0011\u00079\fi&C\u0002\u0002`u\u0013qAQ8pY\u0016\fg.\u0001\u000ee_^tGn\\1e%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$S'\u0006\u0002\u0002f)\"\u00111LA4W\t\tI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA:;\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0014Q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00063po:dw.\u00193TQ\u0006\u0014XMU3t_V\u00148-\u001a\u000b\r\u0003W\ti(a \u0002\u0002\u0006\r\u0015Q\u0011\u0005\u0007\u0003s!\u0002\u0019A,\t\r\u0005\u0015C\u00031\u0001X\u0011\u0019\tI\u0005\u0006a\u0001/\"1\u0011Q\u000b\u000bA\u0002]C\u0011\"!\u0017\u0015!\u0003\u0005\r!a\u0017\u0002?\u0011|wO\u001c7pC\u0012\u001c\u0006.\u0019:f%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$S'\u0001\bva\u0012\fG/\u001a*fg>,(oY3\u0015\u0011\u00055\u00151SAK\u0003/\u0003B!!\f\u0002\u0010&!\u0011\u0011SA\u0018\u0005E\u0011U\u000e\\+qI\u0006$XMU3ta>t7/\u001a\u0005\u0007\u0003s1\u0002\u0019A,\t\r\u0005ub\u00031\u0001X\u0011\u0019\tIJ\u0006a\u0001/\u0006Aa-\u001b7f!\u0006$\b\u000e\u0006\u0006\u0002\u000e\u0006u\u0015qTAQ\u0003GCa!!\u000f\u0018\u0001\u00049\u0006BBA\u001f/\u0001\u0007q\u000b\u0003\u0004\u0002\u001a^\u0001\ra\u0016\u0005\b\u0003K;\u0002\u0019AAT\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,j\u0003\tIw.\u0003\u0003\u00022\u0006-&aC%oaV$8\u000b\u001e:fC6\faB]3mCR,'+Z:pkJ\u001cW\r\u0006\u0004\u00028\u0006u\u0016q\u0018\t\u0005\u0003[\tI,\u0003\u0003\u0002<\u0006=\"!\u0005\"nYJ+G.\u0019;f%\u0016\u001c\bo\u001c8tK\"1\u0011Q\b\rA\u0002]Ca!!1\u0019\u0001\u00049\u0016A\u0004;be\u001e,GOR5mKB\u000bG\u000f[\u0001\fO\u0016$h+\u001a:tS>t7\u000f\u0006\u0004\u0002H\u00065\u0017q\u001a\t\u0005\u0003[\tI-\u0003\u0003\u0002L\u0006=\"a\u0007\"nYJ+7o\\;sG\u00164VM]:j_:\u001c(+Z:q_:\u001cX\r\u0003\u0004\u0002:e\u0001\ra\u0016\u0005\u0007\u0003\u000bJ\u0002\u0019A,\u0002\u001dU\u0004Hn\\1e%\u0016\u001cx.\u001e:dKR1\u0011Q[An\u0003;\u0004B!!\f\u0002X&!\u0011\u0011\\A\u0018\u0005E\u0011U\u000e\\+qY>\fGMU3ta>t7/\u001a\u0005\u0007\u0003sQ\u0002\u0019A,\t\r\u0005e%\u00041\u0001X\u0003)\u0001\u0018\r\u001e5U_:\u000bW.\u001a\u000b\u0004/\u0006\r\bBBAM7\u0001\u0007q\u000b\u0006\u0005\u0002V\u0006\u001d\u0018\u0011^Av\u0011\u0019\tI\u0004\ba\u0001/\"1\u0011\u0011\u0014\u000fA\u0002]Cq!!*\u001d\u0001\u0004\t9+\u0001\beK2,G/\u001a*fg>,(oY3\u0015\u0011\u0005E\u0018q_A}\u0003w\u0004B!!\f\u0002t&!\u0011Q_A\u0018\u0005E\u0011U\u000e\u001c#fY\u0016$XMU3ta>t7/\u001a\u0005\u0007\u0003si\u0002\u0019A,\t\r\u0005\u0015S\u00041\u0001X\u0011\u0019\tI%\ba\u0001/R1\u0011\u0011_A\u0000\u0005\u0003Aa!!\u000f\u001f\u0001\u00049\u0006BBA#=\u0001\u0007q+\u0001\bhKRLe\u000e];u'R\u0014X-Y7\u0015\t\u0005\u001d&q\u0001\u0005\u0007\u0005\u0013y\u0002\u0019A,\u0002\u0007M$(/\u0001\tde\u0016\fG/\u001a\"nYB\u0013xN[3diRQ!q\u0002B\u000b\u00053\u0011iBa\n\u0011\t\u00055\"\u0011C\u0005\u0005\u0005'\tyC\u0001\rC[2\u001c%/Z1uKB\u0013xN[3diJ+7\u000f]8og\u0016DaAa\u0006!\u0001\u00049\u0016aB2sK\u0006$xN\u001d\u0005\u0007\u00057\u0001\u0003\u0019A,\u0002\u0017A\u0014xN[3di:\u000bW.\u001a\u0005\b\u0005?\u0001\u0003\u0019\u0001B\u0011\u0003-\t7mY3tgV\u001bXM]:\u0011\t\u0019\u0014\u0019cV\u0005\u0004\u0005K9'\u0001\u0002'jgRDqA!\u000b!\u0001\u0004\u0011\t#A\u0005fI&$Xk]3sg\u0006\u0019R\u000f\u001d7pC\u0012\u001c\u0006.\u0019:f%\u0016\u001cx.\u001e:dKRQ\u0011Q\u001bB\u0018\u0005c\u0011\u0019D!\u000e\t\r\u0005e\u0012\u00051\u0001X\u0011\u0019\u0011Y\"\ta\u0001/\"1\u0011\u0011T\u0011A\u0002]Cq!!*\"\u0001\u0004\t9\u000b\u0006\u0005\u0002V\ne\"1\bB\u001f\u0011\u0019\tID\ta\u0001/\"1!1\u0004\u0012A\u0002]Ca!!'#\u0001\u00049F\u0003CA\u0016\u0005\u0003\u0012\u0019E!\u0012\t\r\u0005e2\u00051\u0001X\u0011\u0019\t)e\ta\u0001/\"1\u0011\u0011J\u0012A\u0002]#b!a\u000b\u0003J\t-\u0003BBA\u001dI\u0001\u0007q\u000b\u0003\u0004\u0002F\u0011\u0002\raV\u0001\u0014kB$\u0017\r^3TQ\u0006\u0014XMU3t_V\u00148-\u001a\u000b\u000b\u0003\u001b\u0013\tFa\u0015\u0003V\t]\u0003BBA\u001dK\u0001\u0007q\u000b\u0003\u0004\u0002F\u0015\u0002\ra\u0016\u0005\u0007\u00033+\u0003\u0019A,\t\u000f\u0005\u0015V\u00051\u0001\u0002(RA\u0011Q\u0012B.\u0005;\u0012y\u0006\u0003\u0004\u0002:\u0019\u0002\ra\u0016\u0005\u0007\u0003\u000b2\u0003\u0019A,\t\r\u0005ee\u00051\u0001X\u0003Q9W\r\u001e)s_*,7\r^%oM>\u0014\u0015PT1nKR!!Q\rB6!\u0011\tiCa\u001a\n\t\t%\u0014q\u0006\u0002\u0017\u00056d\u0007K]8kK\u000e$\u0018J\u001c4p%\u0016\u001c\bo\u001c8tK\"1!1D\u0014A\u0002]\u000bqbZ3u%\u0016\u001cx.\u001e:dK&sgm\u001c\u000b\u0005\u0005c\u00129\b\u0005\u0003\u0002.\tM\u0014\u0002\u0002B;\u0003_\u0011qCQ7m%\u0016\u001cx.\u001e:dK&sgm\u001c*fgB|gn]3\t\r\u0005\u0015\u0003\u00061\u0001X\u000399W\r\u001e)s_*,7\r\u001e)sSZ$BA! \u0003\u0004B!\u0011Q\u0006B@\u0013\u0011\u0011\t)a\f\u0003-\tkG\u000e\u0015:pU\u0016\u001cG\u000f\u0015:jmJ+7\u000f]8og\u0016DaAa\u0007*\u0001\u00049\u0016\u0001G1ui\u0006\u001c\u0007NU3t_V\u00148-Z!oIB\u0013xN[3diR1!\u0011\u0012BH\u0005#\u0003B!!\f\u0003\f&!!QRA\u0018\u0005\r\u0012U\u000e\\!ui\u0006\u001c\u0007NU3t_V\u00148-Z!oIB\u0013xN[3diJ+7\u000f]8og\u0016DaAa\u0007+\u0001\u00049\u0006BBA#U\u0001\u0007q+A\tva\u0012\fG/\u001a)s_*,7\r\u001e)sSZ$\"Ba&\u0003\u001e\n\u0005&1\u0015BS!\u0011\tiC!'\n\t\tm\u0015q\u0006\u0002\u001d\u00056dW\u000b\u001d3bi\u0016\u0004&o\u001c6fGR\u0004&/\u001b<SKN\u0004xN\\:f\u0011\u0019\u0011yj\u000ba\u0001/\u0006AQo]3s]\u0006lW\r\u0003\u0004\u0003\u001c-\u0002\ra\u0016\u0005\b\u0005SY\u0003\u0019\u0001B\u0011\u0011\u001d\u0011yb\u000ba\u0001\u0005C\tqc\u00195b]\u001e,wj\u001e8fe\nK(+Z:pkJ\u001cW-\u00133\u0015\u0011\t-&\u0011\u0017BZ\u0005o\u0003B!!\f\u0003.&!!qVA\u0018\u0005Y\u0011U\u000e\\\"iC:<WmT<oKJ\u0014Vm\u001d9p]N,\u0007BBA#Y\u0001\u0007q\u000b\u0003\u0004\u000362\u0002\raV\u0001\t_2$wj\u001e8fe\"1!\u0011\u0018\u0017A\u0002]\u000b\u0001B\\3x\u001f^tWM]\u0001\u001aG>\u0004\u0018PU3t_V\u00148-\u001a+p\u0003:|G\u000f[3s+N,'\u000f\u0006\u0005\u0003@\n\u0015'q\u0019Bf!\u0011\tiC!1\n\t\t\r\u0017q\u0006\u0002\u0018\u00056d7i\u001c9z%\u0016\u001cx.\u001e:dKJ+7\u000f]8og\u0016Da!!\u0012.\u0001\u00049\u0006B\u0002Be[\u0001\u0007q+A\u0006b]>$\b.\u001a:Vg\u0016\u0014\bB\u0002Bg[\u0001\u0007q+A\u0006pe&<\u0017N\\(x]\u0016\u0014\u0018a\u0004:pY2\u0014\u0017mY6WKJ\u001c\u0018n\u001c8\u0015\u0011\tM'\u0011\u001cBn\u0005;\u0004B!!\f\u0003V&!!q[A\u0018\u0005i\u0011U\u000e\u001c*pY2\u0014\u0017mY6WKJ\u001c\u0018n\u001c8SKN\u0004xN\\:f\u0011\u0019\t)E\fa\u0001/\"1\u0011\u0011\n\u0018A\u0002]Ca!!\u000f/\u0001\u00049\u0016!B2m_N,GC\u0001Br!\rq'Q]\u0005\u0004\u0005Ol&\u0001B+oSR\u0004")
public class HttpBmlClient
extends AbstractBmlClient
implements Logging {
    private final String serverUrl;
    private final Map<String, Object> properties;
    private final String clientName;
    private final DWSHttpClient dwsClient;
    private final String FIRST_VERSION;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        HttpBmlClient httpBmlClient = this;
        synchronized (httpBmlClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String clientName() {
        return this.clientName;
    }

    private DWSHttpClient dwsClient() {
        return this.dwsClient;
    }

    public String FIRST_VERSION() {
        return this.FIRST_VERSION;
    }

    private DWSClientConfig createClientConfig() {
        String _serverUrl;
        String string = _serverUrl = StringUtils.isEmpty((CharSequence)this.serverUrl) ? HttpConf$.MODULE$.gatewayInstance() : this.serverUrl;
        if (StringUtils.isEmpty((CharSequence)_serverUrl)) {
            throw new BmlClientFailException(BmlClientErrorCodeSummary.SERVER_URL_NOT_NULL.getErrorCode(), BmlClientErrorCodeSummary.SERVER_URL_NOT_NULL.getErrorDesc());
        }
        Map<Object, Object> config = this.properties == null ? new HashMap() : this.properties;
        int maxConnection = BoxesRunTime.unboxToInt((Object)config.getOrDefault(BmlConfiguration$.MODULE$.CONNECTION_MAX_SIZE_SHORT_NAME(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)BmlConfiguration$.MODULE$.CONNECTION_MAX_SIZE().getValue()))));
        int connectTimeout = BoxesRunTime.unboxToInt((Object)config.getOrDefault(BmlConfiguration$.MODULE$.CONNECTION_TIMEOUT_SHORT_NAME(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)BmlConfiguration$.MODULE$.CONNECTION_TIMEOUT().getValue()))));
        int readTimeout = BoxesRunTime.unboxToInt((Object)config.getOrDefault(BmlConfiguration$.MODULE$.CONNECTION_READ_TIMEOUT_SHORT_NAME(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)BmlConfiguration$.MODULE$.CONNECTION_READ_TIMEOUT().getValue()))));
        String tokenKey = (String)config.getOrDefault(BmlConfiguration$.MODULE$.AUTH_TOKEN_KEY_SHORT_NAME(), BmlConfiguration$.MODULE$.AUTH_TOKEN_KEY().getValue());
        String tokenValue = (String)config.getOrDefault(BmlConfiguration$.MODULE$.AUTH_TOKEN_VALUE_SHORT_NAME(), BmlConfiguration$.MODULE$.AUTH_TOKEN_VALUE().getValue());
        TokenAuthenticationStrategy authenticationStrategy = new TokenAuthenticationStrategy();
        ClientConfig clientConfig = ClientConfigBuilder$.MODULE$.newBuilder().addServerUrl(_serverUrl).connectionTimeout((long)connectTimeout).discoveryEnabled(false).loadbalancerEnabled(false).maxConnectionSize(maxConnection).retryEnabled(false).readTimeout((long)readTimeout).setAuthenticationStrategy((AuthenticationStrategy)authenticationStrategy).setAuthTokenKey(tokenKey).setAuthTokenValue(tokenValue).build();
        DWSClientConfig dwsClientConfig = new DWSClientConfig(clientConfig);
        dwsClientConfig.setDWSVersion((String)Configuration$.MODULE$.LINKIS_WEB_VERSION().getValue());
        return dwsClientConfig;
    }

    @Override
    public BmlDownloadResponse downloadResource(String user, String resourceID) {
        return this.downloadResource(user, resourceID, "");
    }

    @Override
    public BmlDownloadResponse downloadResource(String user, String resourceId, String version) {
        BmlDownloadAction bmlDownloadAction = new BmlDownloadAction();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(bmlDownloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resourceId));
        Object object = version != null ? ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(bmlDownloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version)) : BoxedUnit.UNIT;
        bmlDownloadAction.setUser(user);
        Result downloadResult = this.dwsClient().execute((Action)bmlDownloadAction);
        return new BmlDownloadResponse(true, bmlDownloadAction.getInputStream(), resourceId, version, null);
    }

    @Override
    public BmlDownloadResponse downloadResource(String user, String resourceId, String version, String path, boolean overwrite) {
        FsPath fsPath = new FsPath(path);
        Fs fileSystem = FSFactory$.MODULE$.getFsByProxyUser(fsPath, user);
        fileSystem.init(new HashMap());
        String fullFileName = path;
        BmlDownloadAction downloadAction = new BmlDownloadAction();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(downloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resourceId));
        Object object = StringUtils.isNotEmpty((CharSequence)version) ? ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(downloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version)) : BoxedUnit.UNIT;
        downloadAction.setUser(user);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            try {
                this.dwsClient().execute((Action)downloadAction);
                FsPath fullFilePath = new FsPath(fullFileName);
                outputStream = fileSystem.write(fullFilePath, overwrite);
                inputStream = downloadAction.getInputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                HttpResponse httpResponse = downloadAction.getResponse();
                if (httpResponse instanceof CloseableHttpResponse) {
                    CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)httpResponse;
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> closeableHttpResponse.close(), this.logger());
                } else {
                    this.logger().info(new StringBuilder(34).append("Download response : ").append(downloadAction.getResponse()).append(" cannot close.").toString());
                }
            }
            catch (IOException e) {
                this.logger().error("failed to copy inputStream and outputStream (inputStream\u548coutputStream\u6d41copy\u5931\u8d25)", (Throwable)e);
                BmlClientFailException exception = new BmlClientFailException(BmlClientErrorCodeSummary.BML_CLIENT_FAILED.getErrorCode(), BmlClientErrorCodeSummary.BML_CLIENT_FAILED.getErrorDesc());
                exception.initCause(e);
                throw exception;
            }
            catch (Throwable t) {
                this.logger().error("failed to copy stream (\u6d41\u590d\u5236\u5931\u8d25)", t);
                throw t;
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                IOUtils.closeQuietly(inputStream);
            }
            if (outputStream != null) {
                IOUtils.closeQuietly(outputStream);
            }
            fileSystem.close();
            throw throwable;
        }
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (outputStream != null) {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        fileSystem.close();
        return new BmlDownloadResponse(true, null, resourceId, version, fullFileName);
    }

    public boolean downloadResource$default$5() {
        return false;
    }

    @Override
    public BmlDownloadResponse downloadShareResource(String user, String resourceId, String version, String path, boolean overwrite) {
        FsPath fsPath = new FsPath(path);
        Fs fileSystem = FSFactory$.MODULE$.getFsByProxyUser(fsPath, user);
        fileSystem.init(new HashMap());
        String fullFileName = path;
        BmlDownloadShareAction downloadAction = new BmlDownloadShareAction();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(downloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resourceId));
        Object object = StringUtils.isNotEmpty((CharSequence)version) ? ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(downloadAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version)) : BoxedUnit.UNIT;
        downloadAction.setUser(user);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            try {
                this.dwsClient().execute((Action)downloadAction);
                FsPath fullFilePath = new FsPath(fullFileName);
                outputStream = fileSystem.write(fullFilePath, overwrite);
                inputStream = downloadAction.getInputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException e) {
                this.logger().error("failed to copy inputStream and outputStream (inputStream\u548coutputStream\u6d41copy\u5931\u8d25)", (Throwable)e);
                BmlClientFailException exception = new BmlClientFailException(BmlClientErrorCodeSummary.BML_CLIENT_FAILED.getErrorCode(), BmlClientErrorCodeSummary.BML_CLIENT_FAILED.getErrorDesc());
                exception.initCause(e);
                throw e;
            }
            catch (Throwable t) {
                this.logger().error("failed to copy stream (\u6d41\u590d\u5236\u5931\u8d25)", t);
                throw t;
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                IOUtils.closeQuietly(inputStream);
            }
            if (outputStream != null) {
                IOUtils.closeQuietly(outputStream);
            }
            fileSystem.close();
            throw throwable;
        }
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (outputStream != null) {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        fileSystem.close();
        return new BmlDownloadResponse(true, null, resourceId, version, fullFileName);
    }

    @Override
    public BmlUpdateResponse updateResource(String user, String resourceID, String filePath) {
        InputStream inputStream = this.getInputStream(filePath);
        return this.updateResource(user, resourceID, filePath, inputStream);
    }

    @Override
    public BmlUpdateResponse updateResource(String user, String resourceID, String filePath, InputStream inputStream) {
        Result result;
        HashMap<String, InputStream> _inputStreams = new HashMap<String, InputStream>();
        _inputStreams.put("file", inputStream);
        BmlUpdateAction bmlUpdateAction = new BmlUpdateAction(null, _inputStreams);
        bmlUpdateAction.setUser(user);
        bmlUpdateAction.inputStreamNames().put("file", this.pathToName(filePath));
        bmlUpdateAction.getParameters().put("resourceId", resourceID);
        Result result2 = result = this.dwsClient().execute((Action)bmlUpdateAction);
        if (result2 instanceof BmlUpdateResult) {
            boolean isSuccess;
            BmlUpdateResult bmlUpdateResult = (BmlUpdateResult)result2;
            boolean bl = isSuccess = bmlUpdateResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId = bmlUpdateResult.getResourceId();
                String version = bmlUpdateResult.getVersion();
                return new BmlUpdateResponse(isSuccess, resourceId, version);
            }
            this.logger().error(new StringBuilder(45).append("user ").append(user).append(" update resource failed, status code is ").append(bmlUpdateResult.getStatusCode()).toString());
            return new BmlUpdateResponse(isSuccess, null, null);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(48).append("result type ").append(bmlResult.getResultType()).append(" not match BmlResourceDownloadResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlRelateResponse relateResource(String resourceID, String targetFilePath) {
        return null;
    }

    @Override
    public BmlResourceVersionsResponse getVersions(String user, String resourceId) {
        BmlGetVersionsAction getVersionsAction = new BmlGetVersionsAction(user, resourceId);
        Result result = this.dwsClient().execute((Action)getVersionsAction);
        Result result2 = result;
        if (result2 instanceof BmlResourceVersionResult) {
            boolean isSuccess;
            BmlResourceVersionResult bmlResourceVersionResult = (BmlResourceVersionResult)result2;
            boolean bl = isSuccess = bmlResourceVersionResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId2 = bmlResourceVersionResult.getResourceId();
                ResourceVersions resourceVersions = bmlResourceVersionResult.getResourceVersions();
                return new BmlResourceVersionsResponse(isSuccess, resourceId2, resourceVersions);
            }
            this.logger().error(new StringBuilder(42).append("user ").append(user).append(" get versions failed, status code is ").append(bmlResourceVersionResult.getStatusCode()).toString());
            return new BmlResourceVersionsResponse(isSuccess, null, null);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(48).append("result type ").append(bmlResult.getResultType()).append(" not match BmlResourceDownloadResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUploadResponse uploadResource(String user, String filePath) {
        InputStream inputStream = this.getInputStream(filePath);
        return this.uploadResource(user, filePath, inputStream);
    }

    private String pathToName(String filePath) {
        return new File(filePath).getName();
    }

    @Override
    public BmlUploadResponse uploadResource(String user, String filePath, InputStream inputStream) {
        Result result;
        HashMap<String, InputStream> _inputStreams = new HashMap<String, InputStream>();
        _inputStreams.put("file", inputStream);
        BmlUploadAction uploadAction = new BmlUploadAction(null, _inputStreams);
        uploadAction.inputStreamNames().put("file", this.pathToName(filePath));
        uploadAction.setUser(user);
        Result result2 = result = this.dwsClient().execute((Action)uploadAction);
        if (result2 instanceof BmlUploadResult) {
            boolean isSuccess;
            BmlUploadResult bmlUploadResult = (BmlUploadResult)result2;
            boolean bl = isSuccess = bmlUploadResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId = bmlUploadResult.getResourceId();
                String version = bmlUploadResult.getVersion();
                return new BmlUploadResponse(isSuccess, resourceId, version);
            }
            this.logger().error(new StringBuilder(45).append("user ").append(user).append(" upload resource failed, status code is ").append(bmlUploadResult.getStatusCode()).toString());
            return new BmlUploadResponse(isSuccess, null, null);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(48).append("result type ").append(bmlResult.getResultType()).append(" not match BmlResourceDownloadResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlDeleteResponse deleteResource(String user, String resourceId, String version) {
        return null;
    }

    @Override
    public BmlDeleteResponse deleteResource(String user, String resourceId) {
        Result result;
        BmlDeleteAction deleteAction = new BmlDeleteAction(resourceId);
        deleteAction.setUser(user);
        deleteAction.getParameters().put("resourceId", resourceId);
        Result result2 = result = this.dwsClient().execute((Action)deleteAction);
        if (result2 instanceof BmlDeleteResult) {
            boolean isSuccess;
            BmlDeleteResult bmlDeleteResult = (BmlDeleteResult)result2;
            boolean bl = isSuccess = bmlDeleteResult.getStatus() == 0;
            if (isSuccess) {
                return new BmlDeleteResponse(isSuccess);
            }
            this.logger().error(new StringBuilder(45).append("user ").append(user).append(" update resource failed, status code is ").append(bmlDeleteResult.getStatusCode()).toString());
            return new BmlDeleteResponse(isSuccess);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(48).append("result type ").append(bmlResult.getResultType()).append(" not match BmlResourceDownloadResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    private InputStream getInputStream(String str) {
        return null;
    }

    @Override
    public BmlCreateProjectResponse createBmlProject(String creator, String projectName, List<String> accessUsers, List<String> editUsers) {
        Result result;
        CreateBmlProjectAction createBmlProjectAction = new CreateBmlProjectAction();
        createBmlProjectAction.setUser(creator);
        createBmlProjectAction.getRequestPayloads().put("projectName", projectName);
        createBmlProjectAction.getRequestPayloads().put("editUsers", editUsers);
        createBmlProjectAction.getRequestPayloads().put("accessUsers", accessUsers);
        Result result2 = result = this.dwsClient().execute((Action)createBmlProjectAction);
        if (result2 instanceof BmlCreateBmlProjectResult) {
            boolean isSuccess;
            BmlCreateBmlProjectResult bmlCreateBmlProjectResult = (BmlCreateBmlProjectResult)result2;
            boolean bl = isSuccess = bmlCreateBmlProjectResult.getStatus() == 0;
            if (isSuccess) {
                return new BmlCreateProjectResponse(isSuccess);
            }
            this.logger().error(new StringBuilder(41).append("user ").append(this.user).append(" create bml project, status code is ").append(bmlCreateBmlProjectResult.getStatusCode()).toString());
            return new BmlCreateProjectResponse(isSuccess);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(48).append("result type ").append(bmlResult.getResultType()).append(" not match BmlCreateBmlProjectResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUploadResponse uploadShareResource(String user, String projectName, String filePath, InputStream inputStream) {
        Result result;
        HashMap<String, InputStream> _inputStreams = new HashMap<String, InputStream>();
        _inputStreams.put("file", inputStream);
        BmlUploadShareResourceAction uploadAction = new BmlUploadShareResourceAction(null, _inputStreams);
        uploadAction.inputStreamNames().put("file", this.pathToName(filePath));
        uploadAction.setUser(user);
        uploadAction.getParameters().put("projectName", projectName);
        uploadAction.getRequestPayloads().put("projectName", projectName);
        Result result2 = result = this.dwsClient().execute((Action)uploadAction);
        if (result2 instanceof BmlUploadShareResourceResult) {
            boolean isSuccess;
            BmlUploadShareResourceResult bmlUploadShareResourceResult = (BmlUploadShareResourceResult)result2;
            boolean bl = isSuccess = bmlUploadShareResourceResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId = bmlUploadShareResourceResult.getResourceId();
                String version = bmlUploadShareResourceResult.getVersion();
                return new BmlUploadResponse(isSuccess, resourceId, version);
            }
            this.logger().error(new StringBuilder(45).append("user ").append(user).append(" upload resource failed, status code is ").append(bmlUploadShareResourceResult.getStatusCode()).toString());
            return new BmlUploadResponse(isSuccess, null, null);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(48).append("result type ").append(bmlResult.getResultType()).append(" not match BmlResourceDownloadResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUploadResponse uploadShareResource(String user, String projectName, String filePath) {
        return null;
    }

    @Override
    public BmlDownloadResponse downloadShareResource(String user, String resourceId, String version) {
        BmlDownloadShareAction bmlDownloadShareAction = new BmlDownloadShareAction();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(bmlDownloadShareAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resourceId));
        Object object = version != null ? ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(bmlDownloadShareAction.getParameters()).asScala()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version)) : BoxedUnit.UNIT;
        bmlDownloadShareAction.setUser(user);
        Result result = this.dwsClient().execute((Action)bmlDownloadShareAction);
        return new BmlDownloadResponse(true, bmlDownloadShareAction.getInputStream(), resourceId, version, null);
    }

    @Override
    public BmlDownloadResponse downloadShareResource(String user, String resourceId) {
        return null;
    }

    public boolean downloadShareResource$default$5() {
        return false;
    }

    @Override
    public BmlUpdateResponse updateShareResource(String user, String resourceId, String filePath, InputStream inputStream) {
        Result result;
        HashMap<String, InputStream> _inputStreams = new HashMap<String, InputStream>();
        _inputStreams.put("file", inputStream);
        BmlUpdateShareResourceAction bmlUpdateShareResourceAction = new BmlUpdateShareResourceAction(null, _inputStreams);
        bmlUpdateShareResourceAction.setUser(user);
        bmlUpdateShareResourceAction.inputStreamNames().put("file", this.pathToName(filePath));
        bmlUpdateShareResourceAction.getParameters().put("resourceId", resourceId);
        Result result2 = result = this.dwsClient().execute((Action)bmlUpdateShareResourceAction);
        if (result2 instanceof BmlUpdateShareResourceResult) {
            boolean isSuccess;
            BmlUpdateShareResourceResult bmlUpdateShareResourceResult = (BmlUpdateShareResourceResult)result2;
            boolean bl = isSuccess = bmlUpdateShareResourceResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId2 = bmlUpdateShareResourceResult.getResourceId();
                String version = bmlUpdateShareResourceResult.getVersion();
                return new BmlUpdateResponse(isSuccess, resourceId2, version);
            }
            this.logger().error(new StringBuilder(45).append("user ").append(user).append(" update resource failed, status code is ").append(bmlUpdateShareResourceResult.getStatusCode()).toString());
            return new BmlUpdateResponse(isSuccess, null, null);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(48).append("result type ").append(bmlResult.getResultType()).append(" not match BmlResourceDownloadResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUpdateResponse updateShareResource(String user, String resourceId, String filePath) {
        return null;
    }

    @Override
    public BmlProjectInfoResponse getProjectInfoByName(String projectName) {
        return null;
    }

    @Override
    public BmlResourceInfoResponse getResourceInfo(String resourceId) {
        return null;
    }

    @Override
    public BmlProjectPrivResponse getProjectPriv(String projectName) {
        return null;
    }

    @Override
    public BmlAttachResourceAndProjectResponse attachResourceAndProject(String projectName, String resourceId) {
        Result result;
        BmlAttachAction bmlAttachAction = new BmlAttachAction();
        bmlAttachAction.setUser(this.getUser());
        bmlAttachAction.getRequestPayloads().put("projectName", projectName);
        bmlAttachAction.getRequestPayloads().put("resourceId", resourceId);
        Result result2 = result = this.dwsClient().execute((Action)bmlAttachAction);
        if (result2 instanceof BmlAttachResult) {
            boolean isSuccess;
            BmlAttachResult bmlAttachResult = (BmlAttachResult)result2;
            boolean bl = isSuccess = bmlAttachResult.getStatus() == 0;
            if (isSuccess) {
                return new BmlAttachResourceAndProjectResponse(isSuccess);
            }
            this.logger().error(new StringBuilder(41).append("user ").append(this.user).append(" create bml project, status code is ").append(bmlAttachResult.getStatusCode()).toString());
            return new BmlAttachResourceAndProjectResponse(isSuccess);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(48).append("result type ").append(bmlResult.getResultType()).append(" not match BmlCreateBmlProjectResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlUpdateProjectPrivResponse updateProjectPriv(String username, String projectName, List<String> editUsers, List<String> accessUsers) {
        Result result;
        UpdateBmlProjectAction updateBmlProjectAction = new UpdateBmlProjectAction();
        updateBmlProjectAction.setUser(username);
        updateBmlProjectAction.getRequestPayloads().put("projectName", projectName);
        updateBmlProjectAction.getRequestPayloads().put("editUsers", editUsers);
        updateBmlProjectAction.getRequestPayloads().put("accessUsers", accessUsers);
        Result result2 = result = this.dwsClient().execute((Action)updateBmlProjectAction);
        if (result2 instanceof BmlUpdateProjectResult) {
            boolean isSuccess;
            BmlUpdateProjectResult bmlUpdateProjectResult = (BmlUpdateProjectResult)result2;
            boolean bl = isSuccess = bmlUpdateProjectResult.getStatus() == 0;
            if (isSuccess) {
                return new BmlUpdateProjectPrivResponse(isSuccess);
            }
            this.logger().error(new StringBuilder(41).append("user ").append(this.user).append(" update bml project, status code is ").append(bmlUpdateProjectResult.getStatusCode()).toString());
            return new BmlUpdateProjectPrivResponse(isSuccess);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(45).append("result type ").append(bmlResult.getResultType()).append(" not match BmlUpdateProjectResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlChangeOwnerResponse changeOwnerByResourceId(String resourceId, String oldOwner, String newOwner) {
        Result result;
        BmlChangeOwnerAction bmlChangeOwnerAction = new BmlChangeOwnerAction();
        bmlChangeOwnerAction.setUser(oldOwner);
        bmlChangeOwnerAction.getRequestPayloads().put("resourceId", resourceId);
        bmlChangeOwnerAction.getRequestPayloads().put("oldOwner", oldOwner);
        bmlChangeOwnerAction.getRequestPayloads().put("newOwner", newOwner);
        Result result2 = result = this.dwsClient().execute((Action)bmlChangeOwnerAction);
        return new BmlChangeOwnerResponse(true);
    }

    @Override
    public BmlCopyResourceResponse copyResourceToAnotherUser(String resourceId, String anotherUser, String originOwner) {
        Result result;
        BmlCopyResourceAction copyResourceAction = new BmlCopyResourceAction();
        copyResourceAction.setUser(originOwner);
        copyResourceAction.getRequestPayloads().put("resourceId", resourceId);
        copyResourceAction.getRequestPayloads().put("anotherUser", anotherUser);
        Result result2 = result = this.dwsClient().execute((Action)copyResourceAction);
        if (result2 instanceof BmlCopyResourceResult) {
            boolean isSuccess;
            BmlCopyResourceResult bmlCopyResourceResult = (BmlCopyResourceResult)result2;
            boolean bl = isSuccess = bmlCopyResourceResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId2 = bmlCopyResourceResult.getResourceId();
                return new BmlCopyResourceResponse(isSuccess, resourceId2);
            }
            this.logger().error(new StringBuilder(43).append("user ").append(this.user).append(" copy resource failed, status code is ").append(bmlCopyResourceResult.getStatusCode()).toString());
            return new BmlCopyResourceResponse(isSuccess, null);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(44).append("result type ").append(bmlResult.getResultType()).append(" not match BmlCopyResourceResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public BmlRollbackVersionResponse rollbackVersion(String resourceId, String version, String user) {
        Result result;
        BmlRollbackVersionAction rollbackVersionAction = new BmlRollbackVersionAction();
        rollbackVersionAction.setUser(user);
        rollbackVersionAction.getRequestPayloads().put("resourceId", resourceId);
        rollbackVersionAction.getRequestPayloads().put("version", version);
        Result result2 = result = this.dwsClient().execute((Action)rollbackVersionAction);
        if (result2 instanceof BmlRollbackVersionResult) {
            boolean isSuccess;
            BmlRollbackVersionResult bmlRollbackVersionResult = (BmlRollbackVersionResult)result2;
            boolean bl = isSuccess = bmlRollbackVersionResult.getStatus() == 0;
            if (isSuccess) {
                String resourceId2 = bmlRollbackVersionResult.getResourceId();
                String version2 = bmlRollbackVersionResult.getVersion();
                return new BmlRollbackVersionResponse(isSuccess, resourceId2, version2);
            }
            this.logger().error(new StringBuilder(46).append("user ").append(user).append(" rollback version failed, status code is ").append(bmlRollbackVersionResult.getStatusCode()).toString());
            return new BmlRollbackVersionResponse(isSuccess, null, null);
        }
        if (result2 instanceof BmlResult) {
            BmlResult bmlResult = (BmlResult)result2;
            this.logger().error(new StringBuilder(47).append("result type ").append(bmlResult.getResultType()).append(" not match BmlRollbackVersionResult").toString());
            throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
        }
        throw new POSTResultNotMatchException(BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorCode(), BmlClientErrorCodeSummary.POST_REQUEST_RESULT_NOT_MATCH.getErrorDesc());
    }

    @Override
    public void close() {
        this.dwsClient().close();
    }

    public HttpBmlClient(DWSClientConfig clientConfig, String serverUrl, Map<String, Object> properties) {
        this.serverUrl = serverUrl;
        this.properties = properties;
        Logging.$init$((Logging)this);
        this.clientName = properties == null ? "BML-Client" : (String)properties.getOrDefault(BmlConfiguration$.MODULE$.CLIENT_NAME_SHORT_NAME(), "BML-Client");
        this.dwsClient = new DWSHttpClient(clientConfig != null ? clientConfig : this.createClientConfig(), this.clientName());
        this.FIRST_VERSION = "v000001";
    }

    public HttpBmlClient(String serverUrl) {
        this(null, null, null);
    }

    public HttpBmlClient() {
        this(null, null, null);
    }

    public HttpBmlClient(DWSClientConfig clientConfig) {
        this(clientConfig, null, null);
    }

    public HttpBmlClient(String serverUrl, Map<String, Object> properties) {
        this(null, serverUrl, properties);
    }
}

