/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.service.impl;

import org.apache.linkis.manager.am.vo.CanCreateECRes;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.common.exception.RMWarnException;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateRequest;
import org.apache.linkis.manager.rm.domain.RMLabelContainer;
import org.apache.linkis.manager.rm.exception.RMErrorCode;
import org.apache.linkis.manager.rm.external.service.ExternalResourceService;
import org.apache.linkis.manager.rm.external.yarn.YarnResourceIdentifier;
import org.apache.linkis.manager.rm.service.LabelResourceService;
import org.apache.linkis.manager.rm.service.RequestResourceService;
import org.apache.linkis.manager.rm.utils.AcrossClusterRulesJudgeUtils$;
import org.apache.linkis.manager.rm.utils.RMUtils$;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0005\u000b\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tE\u0001\u0011\t\u0011)A\u0005G!)!\u0006\u0001C\u0001W!9\u0001\u0007\u0001b\u0001\n\u0003\n\u0004B\u0002\u001f\u0001A\u0003%!\u0007C\u0003>\u0001\u0011\u0005c\bC\u0003^\u0001\u0011\u0005c\fC\u0003i\u0001\u0011\u0005\u0011NA\u0010Ee&4XM]!oIf\u000b'O\u001c*fcJ+7o\\;sG\u0016\u001cVM\u001d<jG\u0016T!a\u0003\u0007\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u001b9\tqa]3sm&\u001cWM\u0003\u0002\u0010!\u0005\u0011!/\u001c\u0006\u0003#I\tq!\\1oC\u001e,'O\u0003\u0002\u0014)\u00051A.\u001b8lSNT!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011C\u0001\u0001\u001b!\tYB$D\u0001\r\u0013\tiBB\u0001\fSKF,Xm\u001d;SKN|WO]2f'\u0016\u0014h/[2f\u0003Qa\u0017MY3m%\u0016\u001cx.\u001e:dKN+'O^5dKB\u00111\u0004I\u0005\u0003C1\u0011A\u0003T1cK2\u0014Vm]8ve\u000e,7+\u001a:wS\u000e,\u0017aF3yi\u0016\u0014h.\u00197SKN|WO]2f'\u0016\u0014h/[2f!\t!\u0003&D\u0001&\u0015\tiaE\u0003\u0002(\u001d\u0005AQ\r\u001f;fe:\fG.\u0003\u0002*K\t9R\t\u001f;fe:\fGNU3t_V\u00148-Z*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071rs\u0006\u0005\u0002.\u00015\t!\u0002C\u0003\u001f\u0007\u0001\u0007q\u0004C\u0003#\u0007\u0001\u00071%\u0001\u0007sKN|WO]2f)f\u0004X-F\u00013!\t\u0019$(D\u00015\u0015\t)d'\u0001\u0005sKN|WO]2f\u0015\t9\u0004(\u0001\u0004f]RLG/\u001f\u0006\u0003sA\taaY8n[>t\u0017BA\u001e5\u00051\u0011Vm]8ve\u000e,G+\u001f9f\u00035\u0011Xm]8ve\u000e,G+\u001f9fA\u0005\u00112-\u00198SKF,Xm\u001d;SKN|WO]2f)\u0011ytiT*\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015A\u0001<p\u0015\t!\u0005#\u0001\u0002b[&\u0011a)\u0011\u0002\u000f\u0007\u0006t7I]3bi\u0016,5IU3t\u0011\u0015Ae\u00011\u0001J\u00039a\u0017MY3m\u0007>tG/Y5oKJ\u0004\"AS'\u000e\u0003-S!\u0001\u0014\b\u0002\r\u0011|W.Y5o\u0013\tq5J\u0001\tS\u001b2\u000b'-\u001a7D_:$\u0018-\u001b8fe\")QG\u0002a\u0001!B\u00111'U\u0005\u0003%R\u0012ABT8eKJ+7o\\;sG\u0016DQ\u0001\u0016\u0004A\u0002U\u000b1#\u001a8hS:,7I]3bi\u0016\u0014V-];fgR\u0004\"AV.\u000e\u0003]S!\u0001W-\u0002\r\u0015tw-\u001b8f\u0015\tQ\u0006(\u0001\u0005qe>$xnY8m\u0013\tavKA\nF]\u001eLg.Z\"sK\u0006$XMU3rk\u0016\u001cH/\u0001\u0006dC:\u0014V-];fgR$BaX3gOB\u0011\u0001mY\u0007\u0002C*\t!-A\u0003tG\u0006d\u0017-\u0003\u0002eC\n9!i\\8mK\u0006t\u0007\"\u0002%\b\u0001\u0004I\u0005\"B\u001b\b\u0001\u0004\u0001\u0006\"\u0002+\b\u0001\u0004)\u0016!H4f]\u0016\u0014\u0018\r^3Rk\u0016,XMT8u\u000b:|Wo\u001a5NKN\u001c\u0018mZ3\u0015\r)\\\u0018\u0011AA\u0003!\u0011\u00017.\u001c9\n\u00051\f'A\u0002+va2,'\u0007\u0005\u0002a]&\u0011q.\u0019\u0002\u0004\u0013:$\bCA9y\u001d\t\u0011h\u000f\u0005\u0002tC6\tAO\u0003\u0002v1\u00051AH]8pizJ!a^1\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003o\u0006DQ\u0001 \u0005A\u0002u\fqB]3rk\u0016\u001cHOU3t_V\u00148-\u001a\t\u0003gyL!a \u001b\u0003\u0011I+7o\\;sG\u0016Da!a\u0001\t\u0001\u0004i\u0018!E1wC&d\u0017M\u00197f%\u0016\u001cx.\u001e:dK\"1\u0011q\u0001\u0005A\u0002u\f1\"\\1y%\u0016\u001cx.\u001e:dK\u0002")
public class DriverAndYarnReqResourceService
extends RequestResourceService {
    private final ExternalResourceService externalResourceService;
    private final ResourceType resourceType;

    @Override
    public ResourceType resourceType() {
        return this.resourceType;
    }

    @Override
    public CanCreateECRes canRequestResource(RMLabelContainer labelContainer, NodeResource resource, EngineCreateRequest engineCreateRequest) {
        CanCreateECRes canCreateECRes = super.canRequestResource(labelContainer, resource, engineCreateRequest);
        if (!canCreateECRes.isCanCreateEC()) {
            return canCreateECRes;
        }
        DriverAndYarnResource requestedDriverAndYarnResource = (DriverAndYarnResource)resource.getMaxResource();
        YarnResource requestedYarnResource = requestedDriverAndYarnResource.getYarnResource();
        YarnResourceIdentifier yarnIdentifier = new YarnResourceIdentifier(requestedYarnResource.getQueueName());
        NodeResource providedYarnResource = this.externalResourceService.getResource(ResourceType.Yarn, labelContainer, yarnIdentifier);
        Tuple2 tuple2 = new Tuple2((Object)providedYarnResource.getMaxResource(), (Object)providedYarnResource.getUsedResource());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Resource maxCapacity = (Resource)tuple2._1();
        Resource usedCapacity = (Resource)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)maxCapacity, (Object)usedCapacity);
        Resource maxCapacity2 = (Resource)tuple22._1();
        Resource usedCapacity2 = (Resource)tuple22._2();
        this.logger().debug(new StringBuilder(46).append("This queue: ").append(requestedYarnResource.getQueueName()).append(" used resource:").append(usedCapacity2).append(" and max resource: ").append(maxCapacity2).toString());
        Resource queueLeftResource = maxCapacity2.minus(usedCapacity2);
        this.logger().info(new StringBuilder(38).append("queue: ").append(requestedYarnResource.getQueueName()).append(" left ").append(queueLeftResource).append(", this request requires: ").append(requestedYarnResource).toString());
        if (!queueLeftResource.notLess((Resource)requestedYarnResource)) {
            this.logger().info(new StringBuilder(47).append("user: ").append(labelContainer.getUserCreatorLabel().getUser()).append(" request queue resource ").append(requestedYarnResource).append(" > left resource ").append(queueLeftResource).toString());
            Tuple2<Object, String> notEnoughMessage = this.generateQueueNotEnoughMessage((Resource)requestedYarnResource, queueLeftResource, maxCapacity2);
            canCreateECRes.setCanCreateEC(false);
            canCreateECRes.setReason((String)notEnoughMessage._2());
        }
        canCreateECRes.setYarnResource(RMUtils$.MODULE$.serializeResource(queueLeftResource));
        return canCreateECRes;
    }

    @Override
    public boolean canRequest(RMLabelContainer labelContainer, NodeResource resource, EngineCreateRequest engineCreateRequest) {
        block4: {
            if (!super.canRequest(labelContainer, resource, engineCreateRequest)) {
                return false;
            }
            DriverAndYarnResource requestedDriverAndYarnResource = (DriverAndYarnResource)resource.getMaxResource();
            YarnResource requestedYarnResource = requestedDriverAndYarnResource.getYarnResource();
            YarnResourceIdentifier yarnIdentifier = new YarnResourceIdentifier(requestedYarnResource.getQueueName());
            NodeResource providedYarnResource = this.externalResourceService.getResource(ResourceType.Yarn, labelContainer, yarnIdentifier);
            Tuple2 tuple2 = new Tuple2((Object)providedYarnResource.getMaxResource(), (Object)providedYarnResource.getUsedResource());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Resource maxCapacity = (Resource)tuple2._1();
            Resource usedCapacity = (Resource)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maxCapacity, (Object)usedCapacity);
            Resource maxCapacity2 = (Resource)tuple22._1();
            Resource usedCapacity2 = (Resource)tuple22._2();
            this.logger().debug(new StringBuilder(46).append("This queue: ").append(requestedYarnResource.getQueueName()).append(" used resource:").append(usedCapacity2).append(" and max resource: ").append(maxCapacity2).toString());
            Resource queueLeftResource = maxCapacity2.minus(usedCapacity2);
            this.logger().info(new StringBuilder(38).append("queue: ").append(requestedYarnResource.getQueueName()).append(" left ").append(queueLeftResource).append(", this request requires: ").append(requestedYarnResource).toString());
            if (engineCreateRequest.getProperties() != null) {
                AcrossClusterRulesJudgeUtils$.MODULE$.originClusterResourceCheck(engineCreateRequest, maxCapacity2, usedCapacity2);
            }
            if (!queueLeftResource.notLess((Resource)requestedYarnResource)) {
                this.logger().info(new StringBuilder(47).append("user: ").append(labelContainer.getUserCreatorLabel().getUser()).append(" request queue resource ").append(requestedYarnResource).append(" > left resource ").append(queueLeftResource).toString());
                Tuple2<Object, String> notEnoughMessage = this.generateQueueNotEnoughMessage((Resource)requestedYarnResource, queueLeftResource, maxCapacity2);
                throw new RMWarnException(notEnoughMessage._1$mcI$sp(), (String)notEnoughMessage._2());
            }
            if (engineCreateRequest.getProperties() == null) break block4;
            AcrossClusterRulesJudgeUtils$.MODULE$.targetClusterResourceCheck(labelContainer, engineCreateRequest, maxCapacity2, usedCapacity2, this.externalResourceService);
        }
        return true;
    }

    public Tuple2<Object, String> generateQueueNotEnoughMessage(Resource requestResource, Resource availableResource, Resource maxResource) {
        Resource resource = requestResource;
        if (resource instanceof YarnResource) {
            YarnResource yarnResource = (YarnResource)resource;
            YarnResource yarnAvailable = (YarnResource)availableResource;
            YarnResource maxYarn = (YarnResource)maxResource;
            if (yarnResource.getQueueCores() > yarnAvailable.getQueueCores()) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.CLUSTER_QUEUE_CPU_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.CLUSTER_QUEUE_CPU_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("CPU", "cores", BoxesRunTime.boxToInteger((int)yarnResource.getQueueCores()), BoxesRunTime.boxToInteger((int)yarnAvailable.getQueueCores()), BoxesRunTime.boxToInteger((int)maxYarn.getQueueCores()), yarnResource.getQueueName())).toString());
            }
            if (yarnResource.getQueueMemory() > yarnAvailable.getQueueMemory()) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.CLUSTER_QUEUE_MEMORY_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.CLUSTER_QUEUE_MEMORY_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Memory", "bytes", BoxesRunTime.boxToLong((long)yarnResource.getQueueMemory()), BoxesRunTime.boxToLong((long)yarnAvailable.getQueueMemory()), BoxesRunTime.boxToLong((long)maxYarn.getQueueMemory()), yarnResource.getQueueName())).toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.CLUSTER_QUEUE_INSTANCES_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(0).append(RMErrorCode.CLUSTER_QUEUE_INSTANCES_INSUFFICIENT.getErrorDesc()).append(RMUtils$.MODULE$.getResourceInfoMsg("Instance", "", BoxesRunTime.boxToInteger((int)yarnResource.getQueueInstances()), BoxesRunTime.boxToInteger((int)yarnAvailable.getQueueInstances()), BoxesRunTime.boxToInteger((int)maxYarn.getQueueInstances()), yarnResource.getQueueName())).toString());
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)RMErrorCode.CLUSTER_QUEUE_MEMORY_INSUFFICIENT.getErrorCode()), (Object)new StringBuilder(35).append(RMErrorCode.CLUSTER_QUEUE_MEMORY_INSUFFICIENT.getErrorDesc()).append(" Unusual insufficient queue memory.").toString());
    }

    public DriverAndYarnReqResourceService(LabelResourceService labelResourceService, ExternalResourceService externalResourceService) {
        this.externalResourceService = externalResourceService;
        super(labelResourceService);
        this.resourceType = ResourceType.DriverAndYarn;
    }
}

