/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.cs;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.cs.client.service.CSTableService;
import org.apache.linkis.cs.common.entity.metadata.CSTable;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.linkis.engineplugin.spark.exception.ExecuteError;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.datasources.csv.DolphinToSpark$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class CSTableParser$
implements Logging {
    public static CSTableParser$ MODULE$;
    private final Pattern pb;
    private final String DB;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new CSTableParser$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        CSTableParser$ cSTableParser$ = this;
        synchronized (cSTableParser$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Pattern pb() {
        return this.pb;
    }

    private String DB() {
        return this.DB;
    }

    private String[] getCSTempTable(String code) {
        ArrayBuffer bmlResourceNames = new ArrayBuffer();
        Matcher mb = this.pb().matcher(code);
        while (mb.find()) {
            bmlResourceNames.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{mb.group().trim()}));
        }
        return (String[])bmlResourceNames.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String parse(EngineExecutionContext engineExecutorContext, String code, String contextIDValueStr, String nodeNameStr) {
        String[] csTempTables = this.getCSTempTable(code);
        if (csTempTables == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])csTempTables)).isEmpty()) {
            return code;
        }
        ArrayBuffer parsedTables = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])csTempTables)).foreach((Function1 & Serializable & scala.Serializable)csTempTable -> {
            CSTableParser$.$anonfun$parse$1(contextIDValueStr, nodeNameStr, parsedTables, csTempTable);
            return BoxedUnit.UNIT;
        });
        return StringUtils.replaceEach((String)code, (String[])csTempTables, (String[])((String[])parsedTables.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    public CSTable getCSTable(String csTempTable, String contextIDValueStr, String nodeNameStr) {
        return CSTableService.getInstance().getUpstreamSuitableTable(contextIDValueStr, nodeNameStr, csTempTable);
    }

    public void registerTempTable(CSTable csTable) {
        SparkSession spark = SparkSession$.MODULE$.builder().enableHiveSupport().getOrCreate();
        this.logger().info(new StringBuilder(63).append("Start to create  tempView to sparkSession viewName(").append(csTable.getName()).append(") location(").append(csTable.getLocation()).append(")").toString());
        DolphinToSpark$.MODULE$.createTempView(spark, csTable.getName(), csTable.getLocation(), true);
        this.logger().info(new StringBuilder(66).append("Finished to create  tempView to sparkSession viewName(").append(csTable.getName()).append(") location(").append(csTable.getLocation()).append(")").toString());
    }

    private void unRegisterTempTable(String tmpView) {
        SparkSession spark = SparkSession$.MODULE$.builder().enableHiveSupport().getOrCreate();
        this.logger().info(new StringBuilder(18).append("to drop temp view ").append(tmpView).toString());
        spark.catalog().dropTempView(tmpView);
    }

    public void clearCSTmpView(String code, String contextIDValueStr, String nodeNameStr) {
        Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String[] tables = MODULE$.getCSTempTable(code);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tables)).foreach((Function1 & Serializable & scala.Serializable)tmpView -> {
                CSTableParser$.MODULE$.unRegisterTempTable(tmpView);
                return BoxedUnit.UNIT;
            });
        }, "Failed to clearCSTmpView", this.logger());
    }

    public static final /* synthetic */ void $anonfun$parse$1(String contextIDValueStr$1, String nodeNameStr$1, ArrayBuffer parsedTables$1, String csTempTable) {
        CSTable table = MODULE$.getCSTable(csTempTable, contextIDValueStr$1, nodeNameStr$1);
        if (table == null) {
            throw new ExecuteError(SparkErrorCodeSummary.CSTABLE_NOT_FOUND.getErrorCode(), MessageFormat.format(SparkErrorCodeSummary.CSTABLE_NOT_FOUND.getErrorDesc(), csTempTable));
        }
        MODULE$.registerTempTable(table);
        parsedTables$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{csTempTable}));
    }

    private CSTableParser$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.pb = Pattern.compile("cs_tmp_[^\\s\";'()]+[$\\s]{0,1}", 2);
        this.DB = "default.";
    }
}

