/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.metadata;

import java.util.Set;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.ColumnChunkProperties;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.IntColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.LongColumnChunkMetaData;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;

public abstract class ColumnChunkMetaData {
    private final EncodingStats encodingStats;
    private final ColumnChunkProperties properties;

    @Deprecated
    public static ColumnChunkMetaData get(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        return ColumnChunkMetaData.get(path, type, codec, null, encodings, (Statistics)new BooleanStatistics(), firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
    }

    @Deprecated
    public static ColumnChunkMetaData get(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings, Statistics statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        return ColumnChunkMetaData.get(path, type, codec, null, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
    }

    @Deprecated
    public static ColumnChunkMetaData get(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, EncodingStats encodingStats, Set<Encoding> encodings, Statistics statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        return ColumnChunkMetaData.get(path, (PrimitiveType)Types.optional(type).named("fake_type"), codec, encodingStats, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
    }

    public static ColumnChunkMetaData get(ColumnPath path, PrimitiveType type, CompressionCodecName codec, EncodingStats encodingStats, Set<Encoding> encodings, Statistics statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        if (ColumnChunkMetaData.positiveLongFitsInAnInt(firstDataPage) && ColumnChunkMetaData.positiveLongFitsInAnInt(dictionaryPageOffset) && ColumnChunkMetaData.positiveLongFitsInAnInt(valueCount) && ColumnChunkMetaData.positiveLongFitsInAnInt(totalSize) && ColumnChunkMetaData.positiveLongFitsInAnInt(totalUncompressedSize)) {
            return new IntColumnChunkMetaData(path, type, codec, encodingStats, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
        }
        return new LongColumnChunkMetaData(path, type, codec, encodingStats, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
    }

    public long getStartingPos() {
        long dictionaryPageOffset = this.getDictionaryPageOffset();
        long firstDataPageOffset = this.getFirstDataPageOffset();
        if (dictionaryPageOffset > 0L && dictionaryPageOffset < firstDataPageOffset) {
            return dictionaryPageOffset;
        }
        return firstDataPageOffset;
    }

    protected static boolean positiveLongFitsInAnInt(long value) {
        return value >= 0L && value + Integer.MIN_VALUE <= Integer.MAX_VALUE;
    }

    protected ColumnChunkMetaData(ColumnChunkProperties columnChunkProperties) {
        this(null, columnChunkProperties);
    }

    protected ColumnChunkMetaData(EncodingStats encodingStats, ColumnChunkProperties columnChunkProperties) {
        this.encodingStats = encodingStats;
        this.properties = columnChunkProperties;
    }

    public CompressionCodecName getCodec() {
        return this.properties.getCodec();
    }

    @Deprecated
    public ColumnPath getPath() {
        return this.properties.getPath();
    }

    @Deprecated
    public PrimitiveType.PrimitiveTypeName getType() {
        return this.properties.getType();
    }

    public PrimitiveType getPrimitiveType() {
        return this.properties.getPrimitiveType();
    }

    public abstract long getFirstDataPageOffset();

    public abstract long getDictionaryPageOffset();

    public abstract long getValueCount();

    public abstract long getTotalUncompressedSize();

    public abstract long getTotalSize();

    public abstract Statistics getStatistics();

    public Set<Encoding> getEncodings() {
        return this.properties.getEncodings();
    }

    public EncodingStats getEncodingStats() {
        return this.encodingStats;
    }

    public String toString() {
        return "ColumnMetaData{" + this.properties.toString() + ", " + this.getFirstDataPageOffset() + "}";
    }
}

