/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde.primitive;

import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableStringObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class ParquetStringInspector
extends JavaStringObjectInspector
implements SettableStringObjectInspector {
    ParquetStringInspector() {
    }

    @Override
    public Text getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BytesWritable) {
            return new Text(((BytesWritable)o).getBytes());
        }
        if (o instanceof Text) {
            return (Text)o;
        }
        if (o instanceof String) {
            return new Text((String)o);
        }
        if (o instanceof TimestampWritableV2 || o instanceof HiveDecimalWritable || o instanceof DoubleWritable || o instanceof FloatWritable || o instanceof LongWritable || o instanceof IntWritable || o instanceof BooleanWritable) {
            return new Text(o.toString());
        }
        throw new UnsupportedOperationException("Cannot inspect " + o.getClass().getCanonicalName());
    }

    @Override
    public String getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BytesWritable) {
            try {
                return Text.decode((byte[])((BytesWritable)o).getBytes());
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException("Failed to decode string", e);
            }
        }
        if (o instanceof Text) {
            return ((Text)o).toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof TimestampWritableV2 || o instanceof HiveDecimalWritable || o instanceof DoubleWritable || o instanceof FloatWritable || o instanceof LongWritable || o instanceof IntWritable || o instanceof BooleanWritable) {
            return o.toString();
        }
        throw new UnsupportedOperationException("Cannot inspect " + o.getClass().getCanonicalName());
    }

    @Override
    public Object set(Object o, Text text) {
        return new BytesWritable(text == null ? null : text.getBytes());
    }

    @Override
    public Object set(Object o, String string) {
        try {
            return new BytesWritable(string == null ? null : string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to encode string in UTF-8", e);
        }
    }

    @Override
    public Object create(Text text) {
        if (text == null) {
            return null;
        }
        return text.toString();
    }

    @Override
    public Object create(String string) {
        return string;
    }
}

