/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Task;

public class DAGTraversal {
    public static void traverse(List<Task<? extends Serializable>> tasks, Function function) {
        ArrayList<Task<Serializable>> listOfTasks = new ArrayList<Task<? extends Serializable>>(tasks);
        while (!listOfTasks.isEmpty()) {
            ArrayList<Task<Serializable>> children = new ArrayList<Task<Serializable>>();
            for (Task task : listOfTasks) {
                if (function.skipProcessing(task)) continue;
                if (task.getDependentTasks() != null) {
                    children.addAll(task.getDependentTasks());
                }
                function.process(task);
            }
            listOfTasks = children;
        }
    }

    public static interface Function {
        public void process(Task<? extends Serializable> var1);

        public boolean skipProcessing(Task<? extends Serializable> var1);
    }
}

