/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.ContextClient;
import org.apache.linkis.cs.client.builder.ContextClientFactory;
import org.apache.linkis.cs.client.service.SearchService;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchService
implements SearchService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSearchService.class);
    private static final Gson gson = new Gson();
    private static SearchService searchService = null;

    private DefaultSearchService() {
    }

    @Override
    public <T> T getContextValue(ContextID contextID, ContextKey contextKey, Class<T> contextValueType) throws CSErrorException {
        ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
        ContextValue contextValue = null;
        ContextType contextType = contextKey.getContextType();
        try {
            contextValue = contextClient.getContextValue(contextID, contextKey);
        }
        catch (Exception e) {
            logger.error("Failed to get ContextValue: " + e.getMessage());
            throw new CSErrorException(70110, "Failed to get ContextValue: ", (Throwable)e);
        }
        if (null == contextValue || null == contextValue.getValue()) {
            return null;
        }
        if (contextValueType.isInstance(contextValue.getValue())) {
            return (T)contextValue.getValue();
        }
        throw new CSErrorException(70109, "Invalid Context Type : " + contextType);
    }

    @Override
    public <T> T searchContext(ContextID contextId, String keyword, String nodeName, Class<T> contextValueType) throws CSErrorException {
        if (null == contextId || StringUtils.isBlank((CharSequence)contextId.getContextId()) || StringUtils.isBlank((CharSequence)nodeName) || null == contextValueType) {
            logger.error("ContextID or nodeName or contextValueType cannot be null.");
            throw new CSErrorException(70102, "ContextID or nodeName or contextValueType cannot be null.");
        }
        ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
        ArrayList<String> contains = new ArrayList<String>();
        contains.add(keyword);
        ArrayList<Class> contextValueTypes = new ArrayList<Class>();
        contextValueTypes.add(contextValueType);
        List<ContextKeyValue> contextKeyValues = null;
        try {
            contextKeyValues = contextClient.search(contextId, null, null, contains, null, false, nodeName, 1, contextValueTypes);
        }
        catch (ErrorException e) {
            logger.error("Search context value error.");
            throw new CSErrorException(70110, "Search context value error: ", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(contextKeyValues) || null == contextKeyValues.get(0).getContextValue()) {
            return null;
        }
        if (contextValueType.isInstance(contextKeyValues.get(0).getContextValue().getValue())) {
            return (T)contextKeyValues.get(0).getContextValue().getValue();
        }
        throw new CSErrorException(70111, "Search value : " + gson.toJson((Object)(contextKeyValues.get(0) + " is not instance of class : " + contextValueType.getName())));
    }

    @Override
    public <T> List<T> searchUpstreamContext(ContextID contextID, String nodeName, int num, Class<T> contextValueType) throws CSErrorException {
        Map<ContextKey, T> contextMap = this.searchUpstreamContextMap(contextID, nodeName, num, contextValueType);
        if (null == contextMap || contextMap.size() < 1) {
            return null;
        }
        ArrayList retValues = new ArrayList(contextMap.size());
        contextMap.entrySet().stream().filter(kv -> null != kv && null != kv.getValue()).map(kv -> kv.getValue()).forEach(retValues::add);
        return retValues;
    }

    @Override
    public <T> Map<ContextKey, T> searchUpstreamContextMap(ContextID contextID, String nodeName, int num, Class<T> contextValueType) throws CSErrorException {
        ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
        if (null == contextID || StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            return null;
        }
        ArrayList<Class> contextValueTypes = new ArrayList<Class>();
        contextValueTypes.add(contextValueType);
        List<ContextKeyValue> contextKeyValueList = null;
        try {
            contextKeyValueList = contextClient.search(contextID, null, null, null, null, true, nodeName, num, contextValueTypes);
        }
        catch (ErrorException e) {
            throw new CSErrorException(70110, "searchUpstreamContextMap error ", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(contextKeyValueList)) {
            return null;
        }
        HashMap retValues = new HashMap(contextKeyValueList.size());
        contextKeyValueList.stream().filter(kv -> null != kv && null != kv.getContextValue()).forEach(kv -> retValues.put(kv.getContextKey(), kv.getContextValue().getValue()));
        return retValues;
    }

    @Override
    public <T> List<ContextKeyValue> searchUpstreamKeyValue(ContextID contextID, String nodeName, int num, Class<T> contextValueType) throws CSErrorException {
        ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
        if (null == contextID || StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            return null;
        }
        ArrayList<Class> contextValueTypes = new ArrayList<Class>();
        contextValueTypes.add(contextValueType);
        List<ContextKeyValue> contextKeyValueList = null;
        try {
            contextKeyValueList = contextClient.search(contextID, null, null, null, null, true, nodeName, num, contextValueTypes);
        }
        catch (ErrorException e) {
            throw new CSErrorException(70110, "searchUpstreamKeyValue error ", (Throwable)e);
        }
        return contextKeyValueList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchService getInstance() {
        if (null != searchService) return searchService;
        Class<DefaultSearchService> clazz = DefaultSearchService.class;
        synchronized (DefaultSearchService.class) {
            if (null != searchService) return searchService;
            searchService = new DefaultSearchService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return searchService;
        }
    }
}

