/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.listener;

import org.apache.linkis.common.listener.Event;
import org.apache.linkis.cs.client.Context;
import org.apache.linkis.cs.client.listener.ContextClientListener;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.listener.event.impl.DefaultContextKeyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextKeyListener
implements ContextClientListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextKeyListener.class);
    private ContextKey contextKey;
    private Context context;

    public ContextKeyListener() {
    }

    public ContextKeyListener(ContextKey contextKey) {
        this.contextKey = contextKey;
    }

    public ContextKey getContextKey() {
        return this.contextKey;
    }

    public void setContextKey(ContextKey contextKey) {
        this.contextKey = contextKey;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void onContextUpdated(Event event) {
        if (event instanceof DefaultContextKeyEvent) {
            this.context.setLocal(((DefaultContextKeyEvent)event).getContextKeyValue());
        }
    }

    @Override
    public void onEvent(Event event) {
        DefaultContextKeyEvent defaultContextKeyEvent;
        if (event instanceof DefaultContextKeyEvent && (defaultContextKeyEvent = (DefaultContextKeyEvent)event).getContextKeyValue().getContextKey().equals(this.contextKey)) {
            switch (defaultContextKeyEvent.getOperateType()) {
                case UPDATE: {
                    this.onContextUpdated((Event)defaultContextKeyEvent);
                    break;
                }
                case CREATE: {
                    this.onContextCreated((Event)defaultContextKeyEvent);
                    break;
                }
            }
        }
    }
}

