/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.InvocationHandlerFactory;
import feign.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.cache.interceptor.CacheInterceptor;

public class FeignCachingInvocationHandlerFactory
implements InvocationHandlerFactory {
    private final InvocationHandlerFactory delegateFactory;
    private final CacheInterceptor cacheInterceptor;

    public FeignCachingInvocationHandlerFactory(InvocationHandlerFactory delegateFactory, CacheInterceptor cacheInterceptor) {
        this.delegateFactory = delegateFactory;
        this.cacheInterceptor = cacheInterceptor;
    }

    public InvocationHandler create(final Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        final InvocationHandler delegateHandler = this.delegateFactory.create(target, dispatch);
        return (proxy, method, argsNullable) -> {
            final Object[] args = Optional.ofNullable(argsNullable).orElseGet(() -> new Object[0]);
            return this.cacheInterceptor.invoke(new MethodInvocation(){

                public Method getMethod() {
                    return method;
                }

                public Object[] getArguments() {
                    return args;
                }

                public Object proceed() throws Throwable {
                    return delegateHandler.invoke(proxy, method, args);
                }

                public Object getThis() {
                    return target;
                }

                public AccessibleObject getStaticPart() {
                    return method;
                }
            });
        };
    }
}

