/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.query.relnode.OlapFilterRel;
import org.apache.kylin.query.relnode.OlapJoinRel;
import org.apache.kylin.query.relnode.OlapRel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionOlapJoinRule
extends ConverterRule {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionOlapJoinRule.class);
    public static final ConverterRule INSTANCE = new ExtensionOlapJoinRule();

    public ExtensionOlapJoinRule() {
        super(LogicalJoin.class, (RelTrait)Convention.NONE, (RelTrait)OlapRel.CONVENTION, "KapJoinRule");
    }

    public RelNode convert(RelNode rel) {
        OlapJoinRel newRel;
        LogicalJoin join = (LogicalJoin)rel;
        RelNode left = join.getInput(0);
        RelNode right = join.getInput(1);
        RelTraitSet traitSet = join.getTraitSet().replace((RelTrait)OlapRel.CONVENTION);
        left = ExtensionOlapJoinRule.convert((RelNode)left, (RelTraitSet)traitSet);
        right = ExtensionOlapJoinRule.convert((RelNode)right, (RelTraitSet)traitSet);
        JoinInfo info = join.analyzeCondition();
        Join tmpJoin = this.transformJoinCondition(join, info, traitSet, left, right);
        if (tmpJoin instanceof OlapJoinRel) {
            return tmpJoin;
        }
        if (!info.isEqui() && join.getJoinType() != JoinRelType.INNER) {
            return null;
        }
        RelOptCluster cluster = join.getCluster();
        try {
            newRel = new OlapJoinRel(cluster, traitSet, left, right, info.getEquiCondition(left, right, cluster.getRexBuilder()), join.getVariablesSet(), join.getJoinType());
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
        if (!info.isEqui()) {
            RexNode nonEqui = RexUtil.composeConjunction((RexBuilder)cluster.getRexBuilder(), (Iterable)info.nonEquiConditions);
            newRel = new OlapFilterRel(cluster, newRel.getTraitSet(), (RelNode)newRel, nonEqui);
        }
        return newRel;
    }

    private Join transformJoinCondition(LogicalJoin join, JoinInfo info, RelTraitSet traitSet, RelNode left, RelNode right) {
        int index2;
        List<RexInputRef> refs = this.isPowerBiInnerJoin(info, left.getCluster().getRexBuilder());
        if (refs == null) {
            return join;
        }
        RelOptCluster cluster = join.getCluster();
        int index1 = refs.get(0).getIndex();
        int leftIndex = index1 > (index2 = refs.get(1).getIndex()) ? index2 : index1;
        int rightIndex = index1 > index2 ? index1 : index2;
        JoinInfo newInfo = JoinInfo.of((ImmutableIntList)ImmutableIntList.of((int[])new int[]{leftIndex}), (ImmutableIntList)ImmutableIntList.of((int[])new int[]{rightIndex -= left.getRowType().getFieldCount()}));
        try {
            return new OlapJoinRel(cluster, traitSet, left, right, newInfo.getEquiCondition(left, right, cluster.getRexBuilder()), join.getVariablesSet(), join.getJoinType());
        }
        catch (InvalidRelException e) {
            throw new RuntimeException(e);
        }
    }

    private List<RexInputRef> isPowerBiInnerJoin(JoinInfo info, RexBuilder rexBuilder) {
        RexCall notNull2;
        RexCall notNull1;
        RexCall equalCall;
        RexCall notNullCall;
        RexCall twoNullCall;
        if (info.isEqui()) {
            return null;
        }
        RexNode root = RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)info.nonEquiConditions);
        if (!(root instanceof RexCall) || root.getKind() != SqlKind.OR) {
            return null;
        }
        RexCall rootCall = (RexCall)root;
        if (rootCall.operands.size() != 2) {
            return null;
        }
        if (!this.isOperandSqlAnd(rootCall, 0) || !this.isOperandSqlAnd(rootCall, 1)) {
            return null;
        }
        RexCall leftCall = (RexCall)rootCall.operands.get(0);
        RexCall rightCall = (RexCall)rootCall.operands.get(1);
        if (this.isOperandSqlIsNull(leftCall, 0) && this.isOperandSqlIsNull(leftCall, 1)) {
            twoNullCall = leftCall;
            notNullCall = rightCall;
        } else if (this.isOperandSqlIsNull(rightCall, 0) && this.isOperandSqlIsNull(rightCall, 1)) {
            twoNullCall = rightCall;
            notNullCall = leftCall;
        } else {
            return null;
        }
        RexCall isNull1 = (RexCall)twoNullCall.operands.get(0);
        RexCall isNull2 = (RexCall)twoNullCall.operands.get(1);
        if (!this.isOperandInputRef(isNull1, 0) || !this.isOperandInputRef(isNull2, 0)) {
            return null;
        }
        HashSet refs = Sets.newHashSet((Object[])new RexInputRef[]{(RexInputRef)isNull1.operands.get(0), (RexInputRef)isNull2.operands.get(0)});
        if (refs.size() != 2) {
            return null;
        }
        if (notNullCall.operands.size() != 3) {
            return null;
        }
        if (this.isOperandSqlEq(notNullCall, 0) && this.isOperandSqlIsNotNull(notNullCall, 1) && this.isOperandSqlIsNotNull(notNullCall, 2)) {
            equalCall = (RexCall)notNullCall.operands.get(0);
            notNull1 = (RexCall)notNullCall.operands.get(1);
            notNull2 = (RexCall)notNullCall.operands.get(2);
        } else if (this.isOperandSqlEq(notNullCall, 1) && this.isOperandSqlIsNotNull(notNullCall, 0) && this.isOperandSqlIsNotNull(notNullCall, 2)) {
            equalCall = (RexCall)notNullCall.operands.get(1);
            notNull1 = (RexCall)notNullCall.operands.get(0);
            notNull2 = (RexCall)notNullCall.operands.get(2);
        } else if (this.isOperandSqlEq(notNullCall, 2) && this.isOperandSqlIsNotNull(notNullCall, 0) && this.isOperandSqlIsNotNull(notNullCall, 1)) {
            equalCall = (RexCall)notNullCall.operands.get(2);
            notNull1 = (RexCall)notNullCall.operands.get(0);
            notNull2 = (RexCall)notNullCall.operands.get(1);
        } else {
            return null;
        }
        if (((RexNode)equalCall.operands.get(0)).equals(equalCall.operands.get(1))) {
            return null;
        }
        if (!refs.contains(equalCall.operands.get(0)) || !refs.contains(equalCall.operands.get(1))) {
            return null;
        }
        if (((RexNode)notNull1.operands.get(0)).equals(notNull2.operands.get(0))) {
            return null;
        }
        if (!refs.contains(notNull1.operands.get(0)) || !refs.contains(notNull2.operands.get(0))) {
            return null;
        }
        return Lists.newArrayList((Iterable)refs);
    }

    private boolean isOperandInputRef(RexCall call, int ordinal) {
        return call.operands.get(ordinal) instanceof RexInputRef;
    }

    private boolean isOperandSqlEq(RexCall call, int ordinal) {
        return this.isOperandSqlKind(call, ordinal, SqlKind.EQUALS);
    }

    private boolean isOperandSqlAnd(RexCall call, int ordinal) {
        return this.isOperandSqlKind(call, ordinal, SqlKind.AND);
    }

    private boolean isOperandSqlIsNull(RexCall call, int ordinal) {
        return this.isOperandSqlKind(call, ordinal, SqlKind.IS_NULL);
    }

    private boolean isOperandSqlIsNotNull(RexCall call, int ordinal) {
        return this.isOperandSqlKind(call, ordinal, SqlKind.IS_NOT_NULL);
    }

    private boolean isOperandSqlKind(RexCall call, int ordinal, SqlKind kind) {
        return this.isOperandRexCall(call, ordinal) && ((RexNode)call.operands.get(ordinal)).getKind() == kind;
    }

    private boolean isOperandRexCall(RexCall call, int ordinal) {
        return call.operands.get(ordinal) instanceof RexCall;
    }
}

