/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.persistence.transaction.EpochCheckBroadcastNotifier;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.metadata.resourcegroup.ResourceGroup;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.handler.resourcegroup.IResourceGroupRequestValidator;
import org.apache.kylin.rest.request.resourecegroup.ResourceGroupRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.ResourceGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/resource_groups"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class ResourceGroupController
extends NBasicController {
    @Autowired
    private ResourceGroupService resourceGroupService;
    @Autowired
    private List<IResourceGroupRequestValidator> requestValidatorList;

    @ApiOperation(value="resourceGroup", tags={"SM"})
    @PutMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<String> updateResourceGroup(@RequestBody ResourceGroupRequest request) {
        this.checkResourceGroupRequest(request);
        if (!this.resourceGroupChanged(request)) {
            return new EnvelopeResponse("000", (Object)"", "");
        }
        this.resourceGroupService.updateResourceGroup(request);
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new EpochCheckBroadcastNotifier());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    private void checkResourceGroupRequest(ResourceGroupRequest request) {
        this.requestValidatorList.forEach(validator -> validator.validate(request));
    }

    private boolean resourceGroupChanged(ResourceGroupRequest request) {
        ResourceGroup originResourceGroup = this.resourceGroupService.getResourceGroup();
        if (!request.isResourceGroupEnabled() && !originResourceGroup.isResourceGroupEnabled()) {
            return false;
        }
        if (request.isResourceGroupEnabled() != originResourceGroup.isResourceGroupEnabled()) {
            return true;
        }
        if (this.checkListChanged(request.getResourceGroupEntities(), originResourceGroup.getResourceGroupEntities())) {
            return true;
        }
        if (this.checkListChanged(request.getKylinInstances(), originResourceGroup.getKylinInstances())) {
            return true;
        }
        return this.checkListChanged(request.getResourceGroupMappingInfoList(), originResourceGroup.getResourceGroupMappingInfoList());
    }

    private boolean checkListChanged(Collection<?> list1, Collection<?> list2) {
        return !CollectionUtils.isEqualCollection(list1, list2);
    }
}

