/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.BuildIndexPlannerIndexRequest;
import org.apache.kylin.rest.request.BuildIndexRequest;
import org.apache.kylin.rest.request.BuildSegmentsRequest;
import org.apache.kylin.rest.request.IncrementBuildSegmentsRequest;
import org.apache.kylin.rest.request.IndexesToSegmentsRequest;
import org.apache.kylin.rest.request.PartitionsBuildRequest;
import org.apache.kylin.rest.request.PartitionsRefreshRequest;
import org.apache.kylin.rest.request.SegmentFixRequest;
import org.apache.kylin.rest.request.SegmentsRequest;
import org.apache.kylin.rest.response.BuildIndexPlannerIndexResponse;
import org.apache.kylin.rest.response.BuildIndexResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.JobInfoResponse;
import org.apache.kylin.rest.response.JobInfoResponseWithFailure;
import org.apache.kylin.rest.response.MergeSegmentCheckResponse;
import org.apache.kylin.rest.response.NDataSegmentResponse;
import org.apache.kylin.rest.response.SegmentCheckResponse;
import org.apache.kylin.rest.response.SegmentPartitionResponse;
import org.apache.kylin.rest.service.FusionModelService;
import org.apache.kylin.rest.service.JobInfoService;
import org.apache.kylin.rest.service.ModelBuildService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.params.IncrementBuildSegmentParams;
import org.apache.kylin.rest.service.params.IndexBuildParams;
import org.apache.kylin.rest.service.params.MergeSegmentParams;
import org.apache.kylin.rest.service.params.RefreshSegmentParams;
import org.apache.kylin.util.DataRangeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/models"}, produces={"application/vnd.apache.kylin-v4+json"})
public class SegmentController
extends NBasicController {
    @Generated
    private static final Logger log = Logger.getLogger(SegmentController.class);
    public static final String MODEL_ID = "modelId";
    @Autowired
    @Qualifier(value="modelService")
    private ModelService modelService;
    @Autowired
    private FusionModelService fusionModelService;
    @Autowired
    @Qualifier(value="modelBuildService")
    private ModelBuildService modelBuildService;
    @Autowired
    private JobInfoService jobInfoService;

    @ApiOperation(value="buildIndicesManually", tags={"DW"}, notes="Update URL: {model}")
    @PostMapping(value={"/{model:.+}/indices"})
    @ResponseBody
    public EnvelopeResponse<BuildIndexResponse> buildIndicesManually(@PathVariable(value="model") String modelId, @RequestBody BuildIndexRequest request) {
        this.checkProjectName(request.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(request.getProject());
        this.checkParamLength("tag", request.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        this.checkRequiredArg(MODEL_ID, modelId);
        this.modelService.validateCCType(modelId, request.getProject());
        BuildIndexResponse response = this.modelBuildService.buildIndicesManually(modelId, request.getProject(), request.getPriority(), request.getYarnQueue(), request.getTag());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="buildIndicesManually", tags={"DW"}, notes="Update URL: {model}")
    @PostMapping(value={"/index_planner_indices"})
    @ResponseBody
    public EnvelopeResponse<BuildIndexPlannerIndexResponse> buildIndexPlannerIndicesManually(@RequestBody BuildIndexPlannerIndexRequest request) {
        this.checkProjectName(request.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(request.getProject());
        this.checkParamLength("tag", request.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        BuildIndexPlannerIndexResponse buildIndexPlannerIndexResponse = new BuildIndexPlannerIndexResponse();
        List<BuildIndexResponse> jobs = new ArrayList();
        if (!request.isAllModels()) {
            String modelId = this.modelService.getModel(request.getModelName(), request.getProject()).getId();
            this.checkRequiredArg(MODEL_ID, modelId);
            this.modelService.validateCCType(modelId, request.getProject());
            BuildIndexResponse response = this.modelBuildService.buildIndexPlannerIndicesManually(modelId, request.getProject(), request.getPriority(), request.getYarnQueue(), request.getTag());
            jobs.add(response);
        } else {
            jobs = this.modelBuildService.buildAllIndexPlannerIndicesManually(request.getProject(), request.getPriority(), request.getYarnQueue(), request.getTag());
        }
        buildIndexPlannerIndexResponse.setJobs(jobs);
        return new EnvelopeResponse("000", (Object)buildIndexPlannerIndexResponse, "");
    }

    @ApiOperation(value="getSegments", tags={"DW"}, notes="Update Param: page_offset, page_size, sort_by; Update Response: total_size")
    @GetMapping(value={"/{dataflow:.+}/segments"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<NDataSegmentResponse>>> getSegments(@PathVariable(value="dataflow") String dataflowId, @RequestParam(value="project") String project, @RequestParam(value="status", required=false) String status, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit, @RequestParam(value="start", required=false, defaultValue="0") String start, @RequestParam(value="end", required=false, defaultValue="9223372036854775806") String end, @RequestParam(value="with_indexes", required=false) List<Long> withAllIndexes, @RequestParam(value="without_indexes", required=false) List<Long> withoutAnyIndexes, @RequestParam(value="all_to_complement", required=false, defaultValue="false") Boolean allToComplement, @RequestParam(value="sort_by", required=false, defaultValue="last_modified_time") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="false") Boolean reverse, @RequestParam(value="statuses", required=false, defaultValue="") List<String> statuses) {
        this.checkProjectName(project);
        DataRangeUtils.validateRange((String)start, (String)end);
        List segments = this.modelService.getSegmentsResponse(dataflowId, project, start, end, status, withAllIndexes, withoutAnyIndexes, allToComplement.booleanValue(), sortBy, reverse.booleanValue(), statuses);
        return new EnvelopeResponse("000", (Object)DataResult.get((List)segments, (int)offset, (int)limit), "");
    }

    @ApiOperation(value="fixSegmentsManually", tags={"DW"}, notes="Add URL: {model}")
    @PostMapping(value={"/{model:.+}/segment_holes"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> fixSegHoles(@PathVariable(value="model") String modelId, @RequestBody SegmentFixRequest segmentsRequest) throws Exception {
        this.checkProjectName(segmentsRequest.getProject());
        this.checkRequiredArg("segment_holes", segmentsRequest.getSegmentHoles());
        String partitionColumnFormat = this.modelService.getPartitionColumnFormatById(segmentsRequest.getProject(), modelId);
        segmentsRequest.getSegmentHoles().forEach(seg -> DataRangeUtils.validateDataRange((String)seg.getStart(), (String)seg.getEnd(), (String)partitionColumnFormat));
        JobInfoResponse response = this.modelService.fixSegmentHoles(segmentsRequest.getProject(), modelId, segmentsRequest.getSegmentHoles(), segmentsRequest.getIgnoredSnapshotTables());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="checkSegments", tags={"DW"})
    @PostMapping(value={"/{model:.+}/segment/validation"})
    @ResponseBody
    public EnvelopeResponse<SegmentCheckResponse> checkSegment(@PathVariable(value="model") String modelId, @RequestBody BuildSegmentsRequest buildSegmentsRequest) {
        this.checkProjectName(buildSegmentsRequest.getProject());
        String partitionColumnFormat = this.modelService.getPartitionColumnFormatById(buildSegmentsRequest.getProject(), modelId);
        DataRangeUtils.validateDataRange((String)buildSegmentsRequest.getStart(), (String)buildSegmentsRequest.getEnd(), (String)partitionColumnFormat);
        SegmentCheckResponse res = this.modelService.checkSegHoleExistIfNewRangeBuild(buildSegmentsRequest.getProject(), modelId, buildSegmentsRequest.getStart(), buildSegmentsRequest.getEnd(), buildSegmentsRequest.isBuildAllIndexes(), buildSegmentsRequest.getBatchIndexIds());
        return new EnvelopeResponse("000", (Object)res, "");
    }

    @ApiOperation(value="checkSegmentsIfDelete", tags={"DW"})
    @GetMapping(value={"/{model:.+}/segment/validation"})
    @ResponseBody
    public EnvelopeResponse<SegmentCheckResponse> checkHolesIfSegDeleted(@PathVariable(value="model") String model, @RequestParam(value="project") String project, @RequestParam(value="ids", required=false) String[] ids) {
        this.checkProjectName(project);
        SegmentCheckResponse res = this.modelService.checkSegHoleIfSegDeleted(model, project, ids);
        return new EnvelopeResponse("000", (Object)res, "");
    }

    @ApiOperation(value="deleteSegments", tags={"DW"}, notes="Update URL: {project}; Update Param: project")
    @DeleteMapping(value={"/{dataflow:.+}/segments"})
    @ResponseBody
    public EnvelopeResponse<String> deleteSegments(@PathVariable(value="dataflow") String dataflowId, @RequestParam(value="project") String project, @RequestParam(value="purge") Boolean purge, @RequestParam(value="force", required=false, defaultValue="false") boolean force, @RequestParam(value="ids", required=false) String[] ids, @RequestParam(value="names", required=false) String[] names) {
        this.checkProjectName(project);
        if (purge.booleanValue()) {
            this.modelService.purgeModelManually(dataflowId, project);
        } else {
            this.checkSegmentParams(ids, names);
            Object[] idsDeleted = this.modelService.convertSegmentIdWithName(dataflowId, project, ids, names);
            if (ArrayUtils.isEmpty((Object[])idsDeleted)) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_EMPTY_ID, new Object[0]);
            }
            this.modelService.deleteSegmentById(dataflowId, project, (String[])idsDeleted, force);
        }
        try {
            this.jobInfoService.checkSuicideJobOfModel(project, dataflowId);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to check suicide job", (Throwable)e);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="refreshOrMergeSegments", tags={"DW"}, notes="Add URL: {model}")
    @PutMapping(value={"/{model:.+}/segments"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> refreshOrMergeSegments(@PathVariable(value="model") String modelId, @RequestBody SegmentsRequest request) {
        this.checkProjectName(request.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(request.getProject());
        this.checkParamLength("tag", request.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        this.checkSegmentParams(request.getIds(), request.getNames());
        List<Object> jobInfos = new ArrayList<JobInfoResponse.JobInfo>();
        Object[] segIds = this.modelService.convertSegmentIdWithName(modelId, request.getProject(), request.getIds(), request.getNames());
        if (SegmentsRequest.SegmentsRequestType.REFRESH == request.getType()) {
            if (ArrayUtils.isEmpty((Object[])segIds)) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_REFRESH_SELECT_EMPTY, new Object[0]);
            }
            jobInfos = this.modelBuildService.refreshSegmentById(new RefreshSegmentParams(request.getProject(), modelId, (String[])segIds, request.isRefreshAllIndexes()).withIgnoredSnapshotTables(request.getIgnoredSnapshotTables()).withPriority(request.getPriority()).withPartialBuild(request.isPartialBuild()).withBatchIndexIds(request.getBatchIndexIds()).withYarnQueue(request.getYarnQueue()).withTag(request.getTag()));
        } else {
            if (ArrayUtils.isEmpty((Object[])segIds) || segIds.length < 2) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_MERGE_LESS_THAN_TWO, new Object[0]);
            }
            JobInfoResponse.JobInfo jobInfo = this.modelBuildService.mergeSegmentsManually(new MergeSegmentParams(request.getProject(), modelId, (String[])segIds).withPriority(request.getPriority()).withYarnQueue(request.getYarnQueue()).withTag(request.getTag()));
            if (jobInfo != null) {
                jobInfos.add(jobInfo);
            }
        }
        JobInfoResponse response = new JobInfoResponse();
        response.setJobs(jobInfos);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="refreshOrMergeSegments", tags={"DW"})
    @PostMapping(value={"/{model:.+}/segments/merge_check"})
    @ResponseBody
    public EnvelopeResponse<MergeSegmentCheckResponse> checkMergeSegments(@PathVariable(value="model") String modelId, @RequestBody SegmentsRequest request) {
        this.checkProjectName(request.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(request.getProject());
        this.checkParamLength("tag", request.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        if (ArrayUtils.isEmpty((Object[])request.getIds()) || request.getIds().length < 2) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_MERGE_LESS_THAN_TWO, new Object[0]);
        }
        Pair merged = this.modelService.checkMergeSegments(new MergeSegmentParams(request.getProject(), modelId, request.getIds()));
        return new EnvelopeResponse("000", (Object)new MergeSegmentCheckResponse(((Long)merged.getFirst()).longValue(), ((Long)merged.getSecond()).longValue()), "");
    }

    @ApiOperation(value="buildSegmentsManually", tags={"DW"}, notes="Add URL: {model}")
    @PostMapping(value={"/{model:.+}/segments"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> buildSegmentsManually(@PathVariable(value="model") String modelId, @RequestBody BuildSegmentsRequest buildSegmentsRequest) throws Exception {
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(buildSegmentsRequest.getProject());
        this.checkParamLength("tag", buildSegmentsRequest.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        String partitionColumnFormat = this.modelService.getPartitionColumnFormatById(buildSegmentsRequest.getProject(), modelId);
        DataRangeUtils.validateDataRange((String)buildSegmentsRequest.getStart(), (String)buildSegmentsRequest.getEnd(), (String)partitionColumnFormat);
        this.modelService.validateCCType(modelId, buildSegmentsRequest.getProject());
        JobInfoResponse response = this.modelBuildService.buildSegmentsManually(buildSegmentsRequest.getProject(), modelId, buildSegmentsRequest.getStart(), buildSegmentsRequest.getEnd(), buildSegmentsRequest.isBuildAllIndexes(), buildSegmentsRequest.getIgnoredSnapshotTables(), buildSegmentsRequest.getSubPartitionValues(), buildSegmentsRequest.getPriority(), buildSegmentsRequest.isBuildAllSubPartitions(), buildSegmentsRequest.getBatchIndexIds(), buildSegmentsRequest.isPartialBuild(), buildSegmentsRequest.getYarnQueue(), buildSegmentsRequest.getTag());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="buildSegmentsManually", tags={"DW"}, notes="Add URL: {model}")
    @PutMapping(value={"/{model:.+}/model_segments"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> incrementBuildSegmentsManually(@PathVariable(value="model") String modelId, @RequestBody IncrementBuildSegmentsRequest buildSegmentsRequest) throws Exception {
        this.checkProjectName(buildSegmentsRequest.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(buildSegmentsRequest.getProject());
        this.checkParamLength("tag", buildSegmentsRequest.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        String partitionColumnFormat = buildSegmentsRequest.getPartitionDesc().getPartitionDateFormat();
        DataRangeUtils.validateDataRange((String)buildSegmentsRequest.getStart(), (String)buildSegmentsRequest.getEnd(), (String)partitionColumnFormat);
        this.modelService.validateCCType(modelId, buildSegmentsRequest.getProject());
        IncrementBuildSegmentParams incrParams = new IncrementBuildSegmentParams(buildSegmentsRequest.getProject(), modelId, buildSegmentsRequest.getStart(), buildSegmentsRequest.getEnd(), buildSegmentsRequest.getPartitionDesc(), buildSegmentsRequest.getMultiPartitionDesc(), buildSegmentsRequest.getSegmentHoles(), buildSegmentsRequest.isBuildAllIndexes(), buildSegmentsRequest.getSubPartitionValues()).withIgnoredSnapshotTables(buildSegmentsRequest.getIgnoredSnapshotTables()).withPriority(buildSegmentsRequest.getPriority()).withBuildAllSubPartitions(buildSegmentsRequest.isBuildAllSubPartitions()).withYarnQueue(buildSegmentsRequest.getYarnQueue()).withTag(buildSegmentsRequest.getTag());
        JobInfoResponse response = this.fusionModelService.incrementBuildSegmentsManually(incrParams);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="buildSegmentsManually", tags={"DW"}, notes="Add URL: {model}")
    @PostMapping(value={"/{model:.+}/model_segments/indexes"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponseWithFailure> addIndexesToSegments(@PathVariable(value="model") String modelId, @RequestBody IndexesToSegmentsRequest buildSegmentsRequest) {
        this.checkProjectName(buildSegmentsRequest.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(buildSegmentsRequest.getProject());
        this.checkParamLength("tag", buildSegmentsRequest.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        if (!buildSegmentsRequest.isParallelBuildBySegment() && buildSegmentsRequest.getSegmentIds() != null && buildSegmentsRequest.getSegmentIds().size() > 100) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_SINGLE_JOB_THRESHOLD, new Object[0]);
        }
        JobInfoResponseWithFailure response = this.fusionModelService.addIndexesToSegments(modelId, buildSegmentsRequest);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="buildSegmentsManually", tags={"DW"}, notes="Add URL: {model}")
    @PostMapping(value={"/{model:.+}/model_segments/all_indexes"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponseWithFailure> addAllIndexesToSegments(@PathVariable(value="model") String modelId, @RequestBody IndexesToSegmentsRequest buildSegmentsRequest) {
        this.checkProjectName(buildSegmentsRequest.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(buildSegmentsRequest.getProject());
        this.checkParamLength("tag", buildSegmentsRequest.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        JobInfoResponseWithFailure response = this.modelBuildService.addIndexesToSegments(IndexBuildParams.builder().project(buildSegmentsRequest.getProject()).modelId(modelId).segmentIds(buildSegmentsRequest.getSegmentIds()).layoutIds(null).parallelBuildBySegment(buildSegmentsRequest.isParallelBuildBySegment()).priority(buildSegmentsRequest.getPriority()).build());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="buildSegmentsManually", tags={"DW"}, notes="Add URL: {model}")
    @PostMapping(value={"/{model:.+}/model_segments/indexes/deletion"})
    @ResponseBody
    public EnvelopeResponse<String> deleteIndexesFromSegments(@PathVariable(value="model") String modelId, @RequestBody IndexesToSegmentsRequest deleteSegmentsRequest) {
        this.checkProjectName(deleteSegmentsRequest.getProject());
        this.modelService.removeIndexesFromSegments(deleteSegmentsRequest.getProject(), modelId, deleteSegmentsRequest.getSegmentIds(), deleteSegmentsRequest.getIndexIds());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="buildMultiPartition", tags={"DW"})
    @PostMapping(value={"/{model:.+}/model_segments/multi_partition"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> buildMultiPartition(@PathVariable(value="model") String modelId, @RequestBody PartitionsBuildRequest param) {
        this.checkProjectName(param.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(param.getProject());
        this.checkParamLength("tag", param.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        this.checkRequiredArg("segment_id", param.getSegmentId());
        this.checkRequiredArg("sub_partition_values", param.getSubPartitionValues());
        JobInfoResponse response = this.modelBuildService.buildSegmentPartitionByValue(param.getProject(), modelId, param.getSegmentId(), param.getSubPartitionValues(), param.isParallelBuildBySegment(), param.isBuildAllSubPartitions(), param.getPriority(), param.getYarnQueue(), param.getTag());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="buildMultiPartition", tags={"DW"})
    @PutMapping(value={"/{model:.+}/model_segments/multi_partition"})
    @ResponseBody
    public EnvelopeResponse<JobInfoResponse> refreshMultiPartition(@PathVariable(value="model") String modelId, @RequestBody PartitionsRefreshRequest param) {
        this.checkProjectName(param.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(param.getProject());
        this.checkParamLength("tag", param.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        this.checkRequiredArg("segment_id", param.getSegmentId());
        JobInfoResponse response = this.modelBuildService.refreshSegmentPartition(param, modelId);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="deleteMultiPartition", tags={"DW"})
    @DeleteMapping(value={"/model_segments/multi_partition"})
    @ResponseBody
    public EnvelopeResponse<String> deleteMultiPartition(@RequestParam(value="model") String modelId, @RequestParam(value="project") String project, @RequestParam(value="segment") String segment, @RequestParam(value="ids") String[] ids) {
        this.checkProjectName(project);
        HashSet partitions = Sets.newHashSet();
        Arrays.stream(ids).forEach(id -> partitions.add(Long.parseLong(id)));
        this.modelService.deletePartitions(project, segment, modelId, (Set)partitions);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getMultiPartitions", tags={"DW"})
    @GetMapping(value={"/{model:.+}/model_segments/multi_partition"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<SegmentPartitionResponse>>> getMultiPartition(@PathVariable(value="model") String modelId, @RequestParam(value="project") String project, @RequestParam(value="segment_id") String segId, @RequestParam(value="status", required=false) List<String> status, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="sort_by", required=false, defaultValue="last_modify_time") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="true") Boolean reverse) {
        this.checkProjectName(project);
        List responseList = this.modelService.getSegmentPartitions(project, modelId, segId, status, sortBy, reverse.booleanValue());
        return new EnvelopeResponse("000", (Object)DataResult.get((List)responseList, (int)pageOffset, (int)pageSize), "");
    }
}

