/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.SamplingRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.DTableService;
import org.apache.kylin.rest.service.ModelBuildSupporter;
import org.apache.kylin.rest.service.TableSampleService;
import org.apache.kylin.rest.service.TableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/tables"}, produces={"application/vnd.apache.kylin-v4+json"})
public class SampleController
extends NBasicController {
    private static final String TABLE = "table";
    private static final int MAX_SAMPLING_ROWS = 20000000;
    private static final int MIN_SAMPLING_ROWS = 10000;
    @Deprecated
    @Autowired
    @Qualifier(value="tableService")
    private TableService tableService;
    @Autowired
    private DTableService dTableService;
    @Autowired
    @Qualifier(value="modelBuildService")
    private ModelBuildSupporter modelBuildService;
    @Autowired
    private TableSampleService tableSampleService;

    @ApiOperation(value="partitionColumnFormat", tags={"AI"})
    @GetMapping(value={"/partition_column_format"})
    @ResponseBody
    public EnvelopeResponse<String> getPartitionColumnFormat(@RequestParam(value="project") String project, @RequestParam(value="table") String table, @RequestParam(value="partition_column") String partitionColumn, @RequestParam(value="partition_expression", required=false) String partitionExpression) throws Exception {
        this.checkProjectName(project);
        this.checkRequiredArg(TABLE, table);
        this.checkRequiredArg("partitionColumn", partitionColumn);
        return new EnvelopeResponse("000", (Object)this.tableService.getPartitionColumnFormat(project, table, partitionColumn, partitionExpression), "");
    }

    @ApiOperation(value="samplingJobs", tags={"AI"})
    @PostMapping(value={"/sampling_jobs"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> submitSampling(@RequestBody SamplingRequest request) {
        this.checkProjectName(request.getProject());
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(request.getProject());
        this.checkParamLength("tag", request.getTag(), prjInstance.getConfig().getJobTagMaxSize());
        SampleController.checkSamplingRows(request.getRows());
        SampleController.checkSamplingTable(request.getQualifiedTableName());
        SampleController.validatePriority((int)request.getPriority());
        List sampleJobs = this.tableSampleService.sampling((Set)Sets.newHashSet((Object[])new String[]{request.getQualifiedTableName()}), request.getProject(), request.getRows(), request.getPriority(), request.getYarnQueue(), request.getTag());
        return new EnvelopeResponse("000", sampleJobs.stream().findFirst().orElse(null), "");
    }

    @ApiOperation(value="hasSamplingJob", tags={"AI"}, notes="Update Param: qualified_table_name")
    @GetMapping(value={"/sampling_check_result"})
    @ResponseBody
    public EnvelopeResponse<Boolean> hasSamplingJob(@RequestParam(value="project") String project, @RequestParam(value="qualified_table_name") String qualifiedTableName) {
        this.checkProjectName(project);
        SampleController.checkSamplingTable(qualifiedTableName);
        boolean hasSamplingJob = this.tableSampleService.hasSamplingJob(project, qualifiedTableName);
        return new EnvelopeResponse("000", (Object)hasSamplingJob, "");
    }

    public static void checkSamplingRows(int rows) {
        if (rows > 20000000 || rows < 10000) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_SAMPLING_RANGE_INVALID, new Object[]{10000, 20000000});
        }
    }

    public static void checkSamplingTable(String tableName) {
        Message msg = MsgPicker.getMsg();
        if (tableName == null || StringUtils.isEmpty((CharSequence)tableName.trim())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, msg.getFailedForNoSamplingTable());
        }
        if (tableName.contains(" ") || !tableName.contains(".") || tableName.split("\\.").length != 2) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, msg.getSamplingFailedForIllegalTableName());
        }
    }
}

