/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.jobs;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.job.BuildJobInfos;
import org.apache.kylin.engine.spark.job.DFMergeJob;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.streaming.common.MergeJobEntry;
import org.apache.kylin.streaming.metadata.BuildLayoutWithRestUpdate;

public class StreamingDFMergeJob
extends DFMergeJob {
    private MergeJobEntry mergeJobEntry;

    public StreamingDFMergeJob() {
        this.buildLayoutWithUpdate = new BuildLayoutWithRestUpdate(JobTypeEnum.STREAMING_MERGE);
        this.config = KylinConfig.getInstanceFromEnv();
    }

    public void streamingMergeSegment(MergeJobEntry mergeJobEntry) throws IOException {
        this.mergeJobEntry = mergeJobEntry;
        this.ss = mergeJobEntry.spark();
        this.project = mergeJobEntry.project();
        this.ss.sparkContext().setLocalProperty("spark.sql.execution.id", null);
        Set specifiedCuboids = mergeJobEntry.afterMergeSegment().getLayoutsMap().keySet();
        this.jobId = RandomUtil.randomUUIDStr();
        if (this.infos == null) {
            this.infos = new BuildJobInfos();
        } else {
            this.infos.clear();
        }
        this.mergeSegments(mergeJobEntry.dataflowId(), mergeJobEntry.afterMergeSegment().getId(), specifiedCuboids);
    }

    public void shutdown() {
        this.buildLayoutWithUpdate.shutDown();
    }

    protected List<NDataSegment> getMergingSegments(NDataflow dataflow, NDataSegment mergedSeg) {
        return this.mergeJobEntry.unMergedSegments();
    }
}

