/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.rest.model.GlutenCacheExecuteResult;
import org.apache.kylin.rest.request.IndexGlutenCacheRequest;
import org.apache.kylin.rest.request.InternalTableGlutenCacheRequest;
import org.apache.kylin.rest.response.GlutenCacheResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.RouteService;
import org.apache.kylin.rest.util.GlutenCacheRequestLimits;
import org.apache.kylin.util.DataRangeUtils;
import org.apache.kylin.utils.GlutenCacheUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="glutenCacheService")
public class GlutenCacheService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlutenCacheService.class);
    @Autowired
    private ModelService modelService;
    @Autowired
    private RouteService routeService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GlutenCacheResponse glutenCache(List<String> cacheCommands) {
        ArrayList executeResults = Lists.newArrayList();
        try (SetLogCategory ignore = new SetLogCategory("build");){
            SparkSession sparkSession = SparderEnv.getSparkSession();
            AtomicInteger successCount = new AtomicInteger(0);
            for (String cacheCommand : cacheCommands) {
                GlutenCacheExecuteResult glutenCacheExecuteResult = this.glutenCacheExecute(cacheCommand, sparkSession, successCount);
                executeResults.add(glutenCacheExecuteResult);
            }
            boolean result = successCount.get() == cacheCommands.size();
            GlutenCacheResponse glutenCacheResponse = new GlutenCacheResponse(Boolean.valueOf(result), (List)executeResults, "");
            return glutenCacheResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new GlutenCacheResponse((List)executeResults, e.getMessage());
        }
    }

    private GlutenCacheExecuteResult glutenCacheExecute(String cacheCommand, SparkSession sparkSession, AtomicInteger successCount) {
        try {
            List rows = sparkSession.sql(cacheCommand).collectAsList();
            if (CollectionUtils.isEmpty((Collection)rows)) {
                throw new KylinRuntimeException(String.format(Locale.ROOT, "Load gluten cache execute has error. %s", "Result rows is empty!!"));
            }
            Row row = (Row)rows.get(0);
            if (row.getBoolean(0)) {
                successCount.incrementAndGet();
                return new GlutenCacheExecuteResult(Boolean.valueOf(true), "", cacheCommand);
            }
            String reason = row.getString(1);
            String exception = StringUtils.isBlank((CharSequence)reason) ? String.format(Locale.ROOT, "Load gluten cache execute has error. %s", "Result exception is empty!!") : reason;
            throw new KylinRuntimeException(exception);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new GlutenCacheExecuteResult(Boolean.valueOf(false), e.getMessage(), cacheCommand);
        }
    }

    public void internalTableGlutenCache(InternalTableGlutenCacheRequest request, HttpServletRequest servletRequest) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!config.queryUseGlutenEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.GLUTEN_NOT_ENABLED_ERROR, MsgPicker.getMsg().getGlutenDisabled());
        }
        String project = request.getProject();
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)project);
        if (!projectConfig.isInternalTableEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_ERROR, MsgPicker.getMsg().getInternalTableDisabled());
        }
        List columns = request.getColumns().stream().map(StringUtils::upperCase).collect(Collectors.toList());
        String table = StringUtils.upperCase((String)(request.getDatabase() + "." + request.getTable()));
        String start = request.getStart();
        String cacheTableCommand = GlutenCacheUtils.generateCacheTableCommand((KylinConfig)this.getConfig(), (String)project, (String)table, (String)start, columns, (boolean)true);
        log.info("InternalTable[{}] cache command is [{}]", (Object)table, (Object)cacheTableCommand);
        this.routeService.routeGlutenCacheAsync((List)Lists.newArrayList((Object[])new String[]{cacheTableCommand}), servletRequest);
    }

    public void indexGlutenCache(IndexGlutenCacheRequest request, HttpServletRequest servletRequest) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!config.queryUseGlutenEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.GLUTEN_NOT_ENABLED_ERROR, MsgPicker.getMsg().getGlutenDisabled());
        }
        String project = request.getProject();
        String modelAlias = request.getModel();
        List<Long> indexes = request.getIndexes();
        String start = request.getStart();
        String end = request.getEnd();
        NDataModel model = this.modelService.getModel(modelAlias, project);
        ArrayList cacheCommands = Lists.newArrayList();
        switch (model.getStorageType()) {
            case V1: {
                if (CollectionUtils.isNotEmpty(indexes)) {
                    throw new KylinRuntimeException(String.format(Locale.ROOT, "Model[%s] StorageType is V1, indexes need null or empty", modelAlias));
                }
                DataRangeUtils.validateDataRange((String)start, (String)end, null);
                Segments segments = this.modelService.getSegmentsByRange(model.getId(), project, start, end).getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING});
                Set resultBySegments = GlutenCacheUtils.generateModelCacheCommandsBySegments((KylinConfig)this.getConfig(), (String)project, (String)model.getId(), (Segments)segments);
                cacheCommands.addAll(resultBySegments);
                break;
            }
            case DELTA: {
                if (StringUtils.isNotEmpty((CharSequence)start) || StringUtils.isNotEmpty((CharSequence)end)) {
                    throw new KylinRuntimeException(String.format(Locale.ROOT, "Model[%s] StorageType is V3, start/end need null", modelAlias));
                }
                Set resultByIndexes = GlutenCacheUtils.generateModelCacheCommandsByIndexes((KylinConfig)this.getConfig(), (String)project, (String)model.getId(), indexes);
                cacheCommands.addAll(resultByIndexes);
                break;
            }
            default: {
                throw new KylinRuntimeException("Model StorageType not support load gluten cache");
            }
        }
        log.info("Model[{}] cache command is [{}]", (Object)modelAlias, (Object)cacheCommands);
        this.routeService.routeGlutenCacheAsync((List)cacheCommands, servletRequest);
    }

    public void glutenCacheAsync(List<String> cacheCommands) {
        try (GlutenCacheRequestLimits ignored = new GlutenCacheRequestLimits();
             SetLogCategory ignore = new SetLogCategory("build");){
            SparkSession sparkSession = SparderEnv.getSparkSession();
            for (String cacheCommand : cacheCommands) {
                this.glutenCacheExecute(cacheCommand, sparkSession);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void glutenCacheExecute(String cacheCommand, SparkSession sparkSession) {
        try {
            sparkSession.sql(cacheCommand).collectAsList();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

