/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.util.LoadCounter;
import org.apache.kylin.rest.config.initialize.SparderStartEvent;
import org.apache.kylin.rest.monitor.SparkContextCanary;
import org.apache.spark.scheduler.SparkUIZombieJobCleaner;
import org.apache.spark.sql.SparderEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Configuration
@AutoConfigureOrder
public class SparderConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparderConfiguration.class);

    public void init() {
        SparderEnv.init();
        if (KylinConfig.getInstanceFromEnv().isCleanSparkUIZombieJob()) {
            SparkUIZombieJobCleaner.regularClean();
        }
        if (System.getProperty("spark.local", "false").equals("true")) {
            log.debug("spark.local=true");
            return;
        }
        if (KapConfig.getInstanceFromEnv().getSparkCanaryEnable()) {
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
            SparkContextCanary.getInstance().init(service);
            LoadCounter.getInstance().init(service);
        }
    }

    @Component
    class SparderSyncListener
    implements ApplicationListener<SparderStartEvent.SyncEvent> {
        SparderSyncListener() {
        }

        public void onApplicationEvent(SparderStartEvent.SyncEvent event) {
            SparderConfiguration.this.init();
        }
    }

    @Component
    class SparderAsyncListener
    implements ApplicationListener<SparderStartEvent.AsyncEvent> {
        SparderAsyncListener() {
        }

        @Async
        public void onApplicationEvent(SparderStartEvent.AsyncEvent event) {
            SparderConfiguration.this.init();
        }
    }
}

