/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsCapacityMetrics {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HdfsCapacityMetrics.class);
    private final Path hdfsCapacityMetricsPath;
    private final FileSystem workingFs;
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final KylinConfig config;
    private final boolean quotaStorageEnabled;
    private final boolean hdfsMetricsPeriodicCalculationEnabled;
    private final long calculationInterval;
    private volatile Map<String, Long> workingDirCapacity = Collections.emptyMap();

    public HdfsCapacityMetrics(KylinConfig config) {
        this.config = config;
        this.workingFs = HadoopUtil.getWorkingFileSystem();
        this.hdfsCapacityMetricsPath = new Path(config.getHdfsMetricsDir("hdfsCapacity.json"));
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("HdfsMetricsChecker"));
        this.hdfsMetricsPeriodicCalculationEnabled = config.isHdfsMetricsPeriodicCalculationEnabled();
        this.quotaStorageEnabled = config.isStorageQuotaEnabled();
        this.calculationInterval = config.getHdfsMetricsPeriodicCalculationInterval();
        if (this.hdfsMetricsPeriodicCalculationEnabled && this.quotaStorageEnabled) {
            this.registerHdfsMetrics(this.calculationInterval);
        }
    }

    public int getPoolSize() {
        return this.scheduledThreadPoolExecutor.getPoolSize();
    }

    public int getActiveCount() {
        return this.scheduledThreadPoolExecutor.getActiveCount();
    }

    Map<String, Long> getWorkingDirCapacity() {
        return Collections.unmodifiableMap(this.workingDirCapacity);
    }

    public Path getHdfsCapacityMetricsPath() {
        return this.hdfsCapacityMetricsPath;
    }

    private void registerHdfsMetrics(long hdfsMetricsPeriodicCalculationInterval) {
        log.info("Quota storage and HDFS metrics periodic calculation are enabled, path: {}", (Object)this.hdfsCapacityMetricsPath);
        this.scheduledThreadPoolExecutor.scheduleAtFixedRate(this::handleNodeHdfsMetrics, 0L, hdfsMetricsPeriodicCalculationInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNodeHdfsMetrics() {
        Lock lock = null;
        boolean updated = false;
        if (this.needReCalculateMetrics()) {
            try {
                String LOCK_KEY = "calculate_hdfs_metrics_key";
                lock = this.config.getDistributedLockFactory().getLockForCurrentThread(LOCK_KEY);
                lock.lock();
                if (this.needReCalculateMetrics()) {
                    this.writeHdfsMetrics();
                    updated = true;
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        if (!updated) {
            this.workingDirCapacity = this.readHdfsMetrics();
        }
    }

    private boolean needReCalculateMetrics() {
        try {
            if (!this.workingFs.exists(this.hdfsCapacityMetricsPath)) {
                return true;
            }
            FileStatus status = this.workingFs.getFileStatus(this.hdfsCapacityMetricsPath);
            return (double)(System.currentTimeMillis() - status.getModificationTime()) > (double)this.calculationInterval * 0.8;
        }
        catch (IOException e) {
            log.error("Check hdfs capacity failed.", (Throwable)e);
            return false;
        }
    }

    public void writeHdfsMetrics() {
        Set allProjects = NProjectManager.getInstance(this.config).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toSet());
        HashMap prepareForWorkingDirCapacity = Maps.newHashMapWithExpectedSize((int)allProjects.size());
        try {
            for (String project : allProjects) {
                long projectTotalStorageSize = 0L;
                Path projectPath = new Path(this.config.getWorkingDirectoryWithConfiguredFs(project));
                FileSystem fs = projectPath.getFileSystem(HadoopUtil.getCurrentConfiguration());
                if (fs.exists(projectPath)) {
                    projectTotalStorageSize = HadoopUtil.getContentSummary((FileSystem)fs, (Path)projectPath).getLength();
                }
                prepareForWorkingDirCapacity.put(project, projectTotalStorageSize);
            }
        }
        catch (IOException e) {
            log.warn("Projects update workingDirCapacity failed.", (Throwable)e);
        }
        this.workingDirCapacity = prepareForWorkingDirCapacity;
        try {
            FSDataOutputStream fsDataOutputStream = this.workingFs.create(this.hdfsCapacityMetricsPath, true);
            JsonUtil.writeValue((OutputStream)fsDataOutputStream, this.workingDirCapacity);
        }
        catch (IOException e) {
            log.warn("Write HdfsCapacityMetrics failed.", (Throwable)e);
        }
    }

    public Map<String, Long> readHdfsMetrics() {
        try {
            if (this.workingFs.exists(this.hdfsCapacityMetricsPath)) {
                FSDataInputStream fsDataInputStream = this.workingFs.open(this.hdfsCapacityMetricsPath);
                return (Map)JsonUtil.readValue((InputStream)fsDataInputStream, HashMap.class);
            }
        }
        catch (IOException e) {
            log.warn("Read HdfsCapacityMetrics failed.", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    public Long getHdfsCapacityByProject(String project) {
        if (this.hdfsMetricsPeriodicCalculationEnabled && this.quotaStorageEnabled) {
            Long orDefault = this.workingDirCapacity.getOrDefault(project, 0L);
            return Long.parseLong(((Object)orDefault).toString());
        }
        return -1L;
    }
}

