/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;

public class JoinDescUtil {
    private JoinDescUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static JoinTableDesc convert(JoinDesc join, NDataModel.TableKind kind, String pkTblAlias, String fkTblAlias, Map<String, TableRef> aliasTableRefMap) {
        if (join == null) {
            return null;
        }
        TableRef table = join.getPKSide();
        JoinTableDesc joinTableDesc = new JoinTableDesc();
        joinTableDesc.setKind(kind);
        joinTableDesc.setTable(table.getTableIdentity());
        joinTableDesc.setAlias(pkTblAlias);
        JoinDesc.JoinDescBuilder joinDescBuilder = new JoinDesc.JoinDescBuilder();
        joinDescBuilder.setType(join.getType());
        joinDescBuilder.setLeftOrInner(join.isLeftOrInnerJoin());
        String[] pkCols = new String[join.getPrimaryKey().length];
        TblColRef[] pkColRefs = new TblColRef[pkCols.length];
        TableRef pkTblRef = aliasTableRefMap.computeIfAbsent(pkTblAlias, alias -> TblColRef.tableForUnknownModel(alias, join.getPKSide().getTableDesc()));
        for (int i = 0; i < pkCols.length; ++i) {
            TblColRef colRef = join.getPrimaryKeyColumns()[i];
            pkCols[i] = pkTblAlias + "." + colRef.getName();
            pkColRefs[i] = TblColRef.columnForUnknownModel(pkTblRef, colRef.getColumnDesc());
        }
        joinDescBuilder.addPrimaryKeys(pkCols, pkColRefs);
        joinDescBuilder.setPrimaryTableRef(pkTblRef);
        String[] fkCols = new String[join.getForeignKey().length];
        TblColRef[] fkColRefs = new TblColRef[fkCols.length];
        TableRef fkTblRef = aliasTableRefMap.computeIfAbsent(fkTblAlias, alias -> TblColRef.tableForUnknownModel(alias, join.getFKSide().getTableDesc()));
        for (int i = 0; i < fkCols.length; ++i) {
            TblColRef colRef = join.getForeignKeyColumns()[i];
            fkCols[i] = fkTblAlias + "." + colRef.getName();
            fkColRefs[i] = TblColRef.columnForUnknownModel(fkTblRef, colRef.getColumnDesc());
        }
        joinDescBuilder.addForeignKeys(fkCols, fkColRefs);
        joinDescBuilder.setForeignTableRef(fkTblRef);
        if (join.getNonEquiJoinCondition() != null) {
            NonEquiJoinCondition nonEquiJoinCondition = JoinDescUtil.convertNonEquiJoinCondition(join.getNonEquiJoinCondition(), pkTblRef, fkTblRef);
            String expr = join.getNonEquiJoinCondition().getExpr();
            expr = expr.replaceAll(join.getPKSide().getAlias(), pkTblAlias);
            expr = expr.replaceAll(join.getFKSide().getAlias(), fkTblAlias);
            nonEquiJoinCondition.setExpr(expr);
            joinDescBuilder.setNonEquiJoinCondition(nonEquiJoinCondition);
        }
        joinTableDesc.setJoin(joinDescBuilder.build());
        return joinTableDesc;
    }

    private static NonEquiJoinCondition convertNonEquiJoinCondition(NonEquiJoinCondition cond, TableRef pkTblRef, TableRef fkTblRef) {
        if (cond.getType() == NonEquiJoinCondition.Type.EXPRESSION) {
            return new NonEquiJoinCondition(cond.getOpName(), cond.getOp(), (NonEquiJoinCondition[])Arrays.stream(cond.getOperands()).map(condInput -> JoinDescUtil.convertNonEquiJoinCondition(condInput, pkTblRef, fkTblRef)).toArray(NonEquiJoinCondition[]::new), cond.getDataType());
        }
        if (cond.getType() == NonEquiJoinCondition.Type.LITERAL) {
            return cond;
        }
        return new NonEquiJoinCondition(JoinDescUtil.convertColumn(cond.getColRef(), pkTblRef, fkTblRef), cond.getDataType());
    }

    private static TblColRef convertColumn(TblColRef colRef, TableRef pkTblRef, TableRef fkTblRef) {
        if (colRef.getTableRef().getTableIdentity().equals(pkTblRef.getTableIdentity())) {
            return TblColRef.columnForUnknownModel(pkTblRef, colRef.getColumnDesc());
        }
        return TblColRef.columnForUnknownModel(fkTblRef, colRef.getColumnDesc());
    }

    public static List<Pair<JoinDesc, NDataModel.TableKind>> resolveTableType(List<JoinDesc> joins) {
        String tableAlias;
        TableRef table;
        ArrayList<Pair<JoinDesc, NDataModel.TableKind>> tableKindByJoins = new ArrayList<Pair<JoinDesc, NDataModel.TableKind>>();
        HashMap<String, JoinDesc> fkTables = new HashMap<String, JoinDesc>();
        for (JoinDesc joinDesc : joins) {
            table = joinDesc.getFKSide();
            tableAlias = table.getAlias();
            if (fkTables.containsKey(tableAlias)) {
                // empty if block
            }
            fkTables.put(tableAlias, joinDesc);
        }
        for (JoinDesc joinDesc : joins) {
            table = joinDesc.getPKSide();
            tableAlias = table.getAlias();
            tableKindByJoins.add((Pair<JoinDesc, NDataModel.TableKind>)new Pair((Object)joinDesc, (Object)NDataModel.TableKind.FACT));
        }
        return tableKindByJoins;
    }

    public static boolean isJoinTypeEqual(JoinDesc a, JoinDesc b) {
        return a.isInnerJoin() && b.isInnerJoin() || a.isLeftJoin() && b.isLeftJoin();
    }

    public static boolean isJoinTableEqual(JoinTableDesc a, JoinTableDesc b) {
        if (a == b) {
            return true;
        }
        if (!a.getTable().equalsIgnoreCase(b.getTable())) {
            return false;
        }
        if (a.getKind() != b.getKind()) {
            return false;
        }
        if (!a.getAlias().equalsIgnoreCase(b.getAlias())) {
            return false;
        }
        JoinDesc ja = a.getJoin();
        JoinDesc jb = b.getJoin();
        if (!ja.getType().equalsIgnoreCase(jb.getType())) {
            return false;
        }
        if (!Arrays.equals(ja.getForeignKey(), jb.getForeignKey())) {
            return false;
        }
        if (!Arrays.equals(ja.getPrimaryKey(), jb.getPrimaryKey())) {
            return false;
        }
        return Objects.equals(ja.getNonEquiJoinCondition(), jb.getNonEquiJoinCondition());
    }

    public static boolean isJoinKeysEqual(JoinDesc a, JoinDesc b) {
        if (!Arrays.equals(a.getForeignKey(), b.getForeignKey())) {
            return false;
        }
        return Arrays.equals(a.getPrimaryKey(), b.getPrimaryKey());
    }

    public static String toString(JoinDesc join) {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(join.getFKSide().getTableIdentity()).append(" AS ").append(join.getFKSide().getAlias()).append(" ").append(join.getType()).append(" JOIN ").append(join.getPKSide().getTableIdentity()).append(" AS ").append(join.getPKSide().getAlias()).append(" ON ");
        for (int i = 0; i < join.getForeignKey().length; ++i) {
            String fk = join.getForeignKey()[i];
            String pk = join.getPrimaryKey()[i];
            if (i > 0) {
                result.append(" AND ");
            }
            result.append(fk).append("=").append(pk);
        }
        return result.toString();
    }
}

