/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.CaseInsensitiveStringMap;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.graph.Graph;
import org.apache.kylin.guava30.shaded.common.graph.MutableGraph;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;

class ModelEdgeCollector {
    @NonNull
    private IndexPlan indexPlan;
    @NonNull
    private MutableGraph<SchemaNode> graph;
    private NDataModel model;
    private Map<Integer, NDataModel.NamedColumn> effectiveNamedColumns;
    private Map<String, NDataModel.NamedColumn> nameColumnIdMap;
    private ImmutableBiMap<Integer, TblColRef> effectiveCols;
    private ImmutableBiMap<Integer, NDataModel.Measure> effectiveMeasures;
    private Map<Integer, String> modelColumnMeasureIdNameMap = new HashMap<Integer, String>();

    public Graph<SchemaNode> collect() {
        this.model = this.indexPlan.getModel();
        this.effectiveNamedColumns = this.model.getEffectiveNamedColumns();
        this.effectiveCols = this.model.getEffectiveCols();
        this.effectiveMeasures = this.model.getEffectiveMeasures();
        CaseInsensitiveStringMap fullQualifiedName2ColumnMap = new CaseInsensitiveStringMap();
        this.effectiveNamedColumns.forEach((arg_0, arg_1) -> ModelEdgeCollector.lambda$collect$0((Map)fullQualifiedName2ColumnMap, arg_0, arg_1));
        this.nameColumnIdMap = fullQualifiedName2ColumnMap;
        this.modelColumnMeasureIdNameMap.putAll(this.model.getAllMeasures().stream().filter(measure -> !measure.isTomb()).collect(Collectors.toMap(NDataModel.Measure::getId, MeasureDesc::getName)));
        this.modelColumnMeasureIdNameMap.putAll(this.model.getAllNamedColumns().stream().collect(Collectors.toMap(NDataModel.NamedColumn::getId, NDataModel.NamedColumn::getAliasDotColumn)));
        this.collectModelColumns();
        this.collectModelSignificant();
        this.collectDimensionAndMeasure();
        this.collectIndex(this.indexPlan.getWhitelistLayouts(), SchemaNodeType.WHITE_LIST_INDEX, new ArrayList<Integer>());
        this.collectIndex(this.indexPlan.getToBeDeletedIndexes().stream().flatMap(index -> index.getLayouts().stream()).collect(Collectors.toList()), SchemaNodeType.TO_BE_DELETED_INDEX, new ArrayList<Integer>());
        this.collectIndex(this.indexPlan.getRuleBaseLayouts(), SchemaNodeType.RULE_BASED_INDEX, this.indexPlan.getAggShardByColumns());
        this.collectAggGroup();
        this.collectIndexPlan();
        return this.graph;
    }

    private void collectModelColumns() {
        Map ccs = this.model.getComputedColumnDescs().stream().collect(Collectors.toMap(ComputedColumnDesc::getColumnName, Function.identity()));
        this.effectiveCols.forEach((id, tblColRef) -> {
            NDataModel.NamedColumn namedColumn = this.effectiveNamedColumns.get(id);
            if (tblColRef.getColumnDesc().isComputedColumn()) {
                return;
            }
            this.graph.putEdge((Object)SchemaNode.ofTableColumn(tblColRef.getColumnDesc()), (Object)SchemaNode.ofModelColumn(namedColumn, this.model.getAlias()));
        });
        this.effectiveCols.forEach((id, tblColRef) -> {
            if (!tblColRef.getColumnDesc().isComputedColumn()) {
                return;
            }
            NDataModel.NamedColumn namedColumn = this.effectiveNamedColumns.get(id);
            ComputedColumnDesc cc = (ComputedColumnDesc)ccs.get(tblColRef.getName());
            SchemaNode ccNode = SchemaNode.ofModelCC(cc, this.model.getAlias(), this.model.getRootFactTableName());
            this.collectExprWithModel(cc.getExpression(), ccNode);
            this.graph.putEdge((Object)ccNode, (Object)SchemaNode.ofModelColumn(namedColumn, this.model.getAlias()));
        });
    }

    private void collectModelSignificant() {
        if (this.model.getPartitionDesc() != null && this.model.getPartitionDesc().getPartitionDateColumnRef() != null) {
            TblColRef colRef = this.model.getPartitionDesc().getPartitionDateColumnRef();
            NDataModel.NamedColumn nameColumn = this.nameColumnIdMap.get(colRef.getAliasDotName());
            this.graph.putEdge((Object)SchemaNode.ofModelColumn(nameColumn, this.model.getAlias()), (Object)SchemaNode.ofPartition(this.model.getPartitionDesc(), this.model.getAlias()));
        }
        if (this.model.isMultiPartitionModel()) {
            LinkedList<TblColRef> colRefs = this.model.getMultiPartitionDesc().getColumnRefs();
            SchemaNode multiplePartitionNode = SchemaNode.ofMultiplePartition(this.model.getMultiPartitionDesc(), this.model.getAlias());
            for (TblColRef colRef : colRefs) {
                NDataModel.NamedColumn nameColumn = this.nameColumnIdMap.get(colRef.getAliasDotName());
                this.graph.putEdge((Object)SchemaNode.ofModelColumn(nameColumn, this.model.getAlias()), (Object)multiplePartitionNode);
            }
        }
        this.graph.putEdge((Object)SchemaNode.ofTable(this.model.getRootFactTable()), (Object)SchemaNode.ofModelFactTable(this.model.getRootFactTable(), this.model.getAlias()));
        for (JoinTableDesc joinTable : this.model.getJoinTables()) {
            this.graph.putEdge((Object)SchemaNode.ofTable(joinTable.getTableRef()), (Object)SchemaNode.ofModelDimensionTable(joinTable.getTableRef(), this.model.getAlias()));
            for (int i = 0; i < joinTable.getJoin().getPrimaryKey().length; ++i) {
                SchemaNode join = SchemaNode.ofJoin(joinTable, joinTable.getJoin().getFKSide(), joinTable.getJoin().getPKSide(), joinTable.getJoin(), this.model.getAlias());
                String fkCol = joinTable.getJoin().getForeignKey()[i];
                NDataModel.NamedColumn fkNameColumn = this.nameColumnIdMap.get(fkCol);
                this.graph.putEdge((Object)SchemaNode.ofModelColumn(fkNameColumn, this.model.getAlias()), (Object)join);
                String pkCol = joinTable.getJoin().getPrimaryKey()[i];
                NDataModel.NamedColumn pkNameColumn = this.nameColumnIdMap.get(pkCol);
                this.graph.putEdge((Object)SchemaNode.ofModelColumn(pkNameColumn, this.model.getAlias()), (Object)join);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.model.getFilterCondition())) {
            this.collectExprWithModel(this.model.getFilterCondition(), SchemaNode.ofFilter(this.model.getAlias(), this.model.getFilterCondition()));
        }
    }

    private void collectDimensionAndMeasure() {
        this.model.getEffectiveDimensions().forEach((id, dimension) -> {
            NDataModel.NamedColumn nameColumn = this.nameColumnIdMap.get(dimension.getAliasDotName());
            this.graph.putEdge((Object)SchemaNode.ofModelColumn(nameColumn, this.model.getAlias()), (Object)SchemaNode.ofDimension(nameColumn, this.model.getAlias()));
        });
        this.model.getEffectiveMeasures().forEach((id, measure) -> {
            List<ParameterDesc> params = measure.getFunction().getParameters();
            SchemaNode measureNode = SchemaNode.ofMeasure(measure, this.model.getAlias());
            this.graph.addNode((Object)measureNode);
            if (CollectionUtils.isEmpty(params)) {
                return;
            }
            for (ParameterDesc param : params) {
                if (param.isConstant()) continue;
                TblColRef colRef = param.getColRef();
                NDataModel.NamedColumn nameColumn = this.nameColumnIdMap.get(colRef.getAliasDotName());
                this.graph.putEdge((Object)SchemaNode.ofModelColumn(nameColumn, this.model.getAlias()), (Object)measureNode);
            }
        });
    }

    private void collectIndex(List<LayoutEntity> allLayouts, SchemaNodeType type, List<Integer> aggShardByColumns) {
        HashMap colNodes = Maps.newHashMap();
        for (LayoutEntity layout : allLayouts) {
            SchemaNode indexNode = SchemaNode.ofIndex(type, layout, this.model, this.modelColumnMeasureIdNameMap, type == SchemaNodeType.RULE_BASED_INDEX ? aggShardByColumns : null);
            if (layout.getIndex().isTableIndex()) {
                for (Integer col : layout.getColOrder()) {
                    NDataModel.NamedColumn namedColumn = this.effectiveNamedColumns.get(col);
                    this.graph.putEdge((Object)SchemaNode.ofModelColumn(namedColumn, this.model.getAlias()), (Object)indexNode);
                }
                continue;
            }
            for (Integer col : layout.getColOrder()) {
                colNodes.computeIfAbsent(col, id -> {
                    if (col < 100000) {
                        NDataModel.NamedColumn namedColumn = this.effectiveNamedColumns.get(col);
                        return SchemaNode.ofDimension(namedColumn, this.model.getAlias());
                    }
                    NDataModel.Measure measure = (NDataModel.Measure)this.effectiveMeasures.get((Object)col);
                    if (measure == null) {
                        return null;
                    }
                    return SchemaNode.ofMeasure(measure, this.model.getAlias());
                });
                SchemaNode colSchemaNode = (SchemaNode)colNodes.get(col);
                if (colSchemaNode == null) continue;
                this.graph.putEdge((Object)colSchemaNode, (Object)indexNode);
            }
        }
    }

    private void collectExprWithModel(String expr, SchemaNode target) {
        List<Pair<String, String>> pairs = ComputedColumnUtil.ExprIdentifierFinder.getExprIdentifiers(expr);
        for (Pair<String, String> pair : pairs) {
            this.graph.putEdge((Object)SchemaNode.ofModelColumn(this.nameColumnIdMap.get((String)pair.getFirst() + "." + (String)pair.getSecond()), this.model.getAlias()), (Object)target);
        }
    }

    private void collectAggGroup() {
        RuleBasedIndex ruleBasedIndex = this.indexPlan.getRuleBasedIndex();
        if (ruleBasedIndex == null) {
            return;
        }
        int index = 0;
        for (NAggregationGroup aggGroup : ruleBasedIndex.getAggregationGroups()) {
            SchemaNode aggGroupNode = SchemaNodeType.AGG_GROUP.withKey(this.model.getAlias() + "/" + index);
            for (Integer col : aggGroup.getIncludes()) {
                NDataModel.NamedColumn namedColumn = this.effectiveNamedColumns.get(col);
                this.graph.putEdge((Object)SchemaNode.ofDimension(namedColumn, this.model.getAlias()), (Object)aggGroupNode);
            }
            for (Integer measure : aggGroup.getMeasures()) {
                this.graph.putEdge((Object)SchemaNode.ofMeasure((NDataModel.Measure)this.effectiveMeasures.get((Object)measure), this.model.getAlias()), (Object)aggGroupNode);
            }
            ++index;
        }
    }

    private void collectIndexPlan() {
        SchemaNode aggShardNode = SchemaNodeType.INDEX_AGG_SHARD.withKey(this.model.getAlias());
        this.collectAggExpertColumns(this.indexPlan.getAggShardByColumns(), aggShardNode);
        SchemaNode aggPartitionNode = SchemaNodeType.INDEX_AGG_EXTEND_PARTITION.withKey(this.model.getAlias());
        this.collectAggExpertColumns(this.indexPlan.getExtendPartitionColumns(), aggPartitionNode);
    }

    private void collectAggExpertColumns(List<Integer> cols, SchemaNode node) {
        if (CollectionUtils.isEmpty(cols)) {
            return;
        }
        for (Integer col : cols) {
            NDataModel.NamedColumn namedColumn = this.effectiveNamedColumns.get(col);
            this.graph.putEdge((Object)SchemaNode.ofModelColumn(namedColumn, this.model.getAlias()), (Object)node);
        }
        for (LayoutEntity layout : this.indexPlan.getRuleBaseLayouts()) {
            if (!layout.getColOrder().containsAll(this.indexPlan.getAggShardByColumns())) continue;
            this.graph.putEdge((Object)node, (Object)SchemaNode.ofIndex(SchemaNodeType.RULE_BASED_INDEX, layout, this.model, this.modelColumnMeasureIdNameMap, null));
        }
    }

    @Generated
    public ModelEdgeCollector(@NonNull IndexPlan indexPlan, @NonNull MutableGraph<SchemaNode> graph) {
        if (indexPlan == null) {
            throw new NullPointerException("indexPlan is marked @NonNull but is null");
        }
        if (graph == null) {
            throw new NullPointerException("graph is marked @NonNull but is null");
        }
        this.indexPlan = indexPlan;
        this.graph = graph;
    }

    private static /* synthetic */ void lambda$collect$0(Map fullQualifiedName2ColumnMap, Integer k, NDataModel.NamedColumn v) {
        fullQualifiedName2ColumnMap.put(v.getAliasDotColumn(), v);
    }
}

