/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.DataType;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.TruthTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NonEquiJoinCondition
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NonEquiJoinCondition.class);
    private static final Map<SqlKind, TruthTable.Operator> OP_TRUTH_MAPPING = ImmutableMap.builder().put((Object)SqlKind.AND, (Object)TruthTable.Operator.AND).put((Object)SqlKind.OR, (Object)TruthTable.Operator.OR).put((Object)SqlKind.NOT, (Object)TruthTable.Operator.NOT).build();
    private static final Map<SqlKind, SqlKind> OP_INVERSE_MAPPING = ImmutableMap.builder().put((Object)SqlKind.NOT_EQUALS, (Object)SqlKind.EQUALS).put((Object)SqlKind.NOT_IN, (Object)SqlKind.IN).put((Object)SqlKind.IS_NOT_NULL, (Object)SqlKind.IS_NULL).put((Object)SqlKind.IS_NOT_FALSE, (Object)SqlKind.IS_FALSE).put((Object)SqlKind.IS_NOT_TRUE, (Object)SqlKind.IS_TRUE).put((Object)SqlKind.IS_NOT_DISTINCT_FROM, (Object)SqlKind.IS_DISTINCT_FROM).put((Object)SqlKind.LESS_THAN, (Object)SqlKind.GREATER_THAN_OR_EQUAL).put((Object)SqlKind.LESS_THAN_OR_EQUAL, (Object)SqlKind.GREATER_THAN).build();
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="data_type")
    private DataType dataType;
    @JsonProperty(value="op")
    private SqlKind op;
    @JsonProperty(value="op_name")
    private String opName;
    @JsonProperty(value="operands")
    private NonEquiJoinCondition[] operands = new NonEquiJoinCondition[0];
    @JsonProperty(value="value")
    private String value;
    private TblColRef colRef;
    @JsonProperty(value="expr")
    private String expr;
    static final Set<SqlKind> EXCHANGEABLE_OPERATOR = Sets.newHashSet((Object[])new SqlKind[]{SqlKind.AND, SqlKind.OR, SqlKind.EQUALS, SqlKind.NOT_EQUALS, SqlKind.IN, SqlKind.NOT_IN});

    public NonEquiJoinCondition() {
    }

    public NonEquiJoinCondition(SqlOperator op, NonEquiJoinCondition[] operands, RelDataType dataType) {
        this(op.getName(), op.getKind(), operands, new DataType(dataType));
    }

    public NonEquiJoinCondition(RexLiteral value, RelDataType dataType) {
        this(TypedLiteralConverter.typedLiteralToString(value), new DataType(dataType));
    }

    public NonEquiJoinCondition(TblColRef tblColRef, RelDataType dataType) {
        this(tblColRef, new DataType(dataType));
    }

    public NonEquiJoinCondition(String opName, SqlKind op, NonEquiJoinCondition[] operands, DataType dataType) {
        this.opName = opName;
        this.op = op;
        this.operands = operands;
        this.type = Type.EXPRESSION;
        this.dataType = dataType;
    }

    public NonEquiJoinCondition(String value, DataType dataType) {
        this.op = SqlKind.LITERAL;
        this.type = Type.LITERAL;
        this.value = value;
        this.dataType = dataType;
    }

    public NonEquiJoinCondition(TblColRef tblColRef, DataType dataType) {
        this.op = SqlKind.INPUT_REF;
        this.type = Type.COLUMN;
        this.value = tblColRef.getIdentity();
        this.colRef = tblColRef;
        this.dataType = dataType;
    }

    public Object getTypedValue() {
        return TypedLiteralConverter.stringValueToTypedValue(this.value, this.dataType);
    }

    public NonEquiJoinCondition copy() {
        NonEquiJoinCondition condCopy = new NonEquiJoinCondition();
        condCopy.type = this.type;
        condCopy.dataType = this.dataType;
        condCopy.op = this.op;
        condCopy.opName = this.opName;
        condCopy.operands = Arrays.copyOf(this.operands, this.operands.length);
        condCopy.value = this.value;
        condCopy.colRef = this.colRef;
        condCopy.expr = this.expr;
        return condCopy;
    }

    public NonEquiJoinCondition[] getSortedOperands() {
        if (EXCHANGEABLE_OPERATOR.contains(this.op)) {
            return (NonEquiJoinCondition[])Arrays.stream(this.operands).sorted(Comparator.comparing(NonEquiJoinCondition::getOp)).toArray(NonEquiJoinCondition[]::new);
        }
        return Arrays.copyOf(this.operands, this.operands.length);
    }

    private TruthTable<NonEquiJoinCondition> createTruthTable() {
        TruthTable.ExprBuilder<NonEquiJoinCondition> builder = new TruthTable.ExprBuilder<NonEquiJoinCondition>(new NeqCondOperandComparator());
        this.accept(builder);
        TruthTable.Expr<NonEquiJoinCondition> builtExpr = builder.build();
        return new TruthTable<NonEquiJoinCondition>(new ArrayList(builder.allOperandSet), builtExpr);
    }

    private void accept(TruthTable.ExprBuilder<NonEquiJoinCondition> builder) {
        switch (this.op) {
            case AND: 
            case NOT: 
            case OR: {
                builder.compositeStart(OP_TRUTH_MAPPING.get(this.op));
                for (NonEquiJoinCondition operand : this.operands) {
                    operand.accept(builder);
                }
                builder.compositeEnd();
                break;
            }
            default: {
                this.addOperand(builder);
            }
        }
    }

    private void addOperand(TruthTable.ExprBuilder<NonEquiJoinCondition> builder) {
        NonEquiJoinCondition copied = this.copy();
        if (this.inverseCondOperator(copied)) {
            builder.compositeStart(TruthTable.Operator.NOT);
            this.normalizedCondOperandOrderings(copied);
            builder.addExpr(copied);
            builder.compositeEnd();
        } else {
            this.normalizedCondOperandOrderings(copied);
            builder.addExpr(copied);
        }
    }

    private boolean inverseCondOperator(NonEquiJoinCondition neqJoinCond) {
        if (OP_INVERSE_MAPPING.containsKey(neqJoinCond.getOp())) {
            neqJoinCond.setOp(OP_INVERSE_MAPPING.get(neqJoinCond.getOp()));
            neqJoinCond.setOpName(neqJoinCond.getOp().sql);
            return true;
        }
        return false;
    }

    private void normalizedCondOperandOrderings(NonEquiJoinCondition neqJoinCond) {
        if (neqJoinCond.getOp() == SqlKind.EQUALS) {
            Arrays.sort(neqJoinCond.getOperands(), Comparator.comparing(NonEquiJoinCondition::toString));
        }
        if (neqJoinCond.getOp() == SqlKind.IN) {
            Arrays.sort(neqJoinCond.getOperands(), 1, neqJoinCond.getOperands().length, Comparator.comparing(NonEquiJoinCondition::toString));
        }
    }

    public String toString() {
        NonEquiJoinCondition[] sorted;
        StringBuilder sb = new StringBuilder();
        sb.append(this.op);
        sb.append("(");
        for (NonEquiJoinCondition input : sorted = this.getSortedOperands()) {
            sb.append(input.toString());
            sb.append(", ");
        }
        if (this.type == Type.LITERAL) {
            sb.append(this.value);
        } else if (this.type == Type.COLUMN) {
            if (this.colRef != null) {
                sb.append(this.colRef.getColumnWithTableAndSchema());
            } else {
                sb.append(this.value);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NonEquiJoinCondition)) {
            return false;
        }
        NonEquiJoinCondition neqJoinCond = (NonEquiJoinCondition)obj;
        try {
            return Objects.equals(this.createTruthTable(), neqJoinCond.createTruthTable());
        }
        catch (Exception e) {
            log.error("Error on comparing condition({}), condition({}). Error Msg: {}", new Object[]{this, neqJoinCond, e.getMessage()});
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + this.op.hashCode();
        if ((this.op == SqlKind.OTHER || this.op == SqlKind.OTHER_FUNCTION) && this.opName != null) {
            result = 31 * result + this.opName.hashCode();
        }
        for (NonEquiJoinCondition operand : this.operands) {
            result = 31 * result + operand.hashCode();
        }
        if (this.type == Type.LITERAL) {
            result = 31 * result + this.value.hashCode();
        } else if (this.type == Type.COLUMN) {
            result = this.colRef != null ? 31 * result + this.colRef.hashCode() : 31 * result + this.value.hashCode();
        }
        return result;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public DataType getDataType() {
        return this.dataType;
    }

    @Generated
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Generated
    public SqlKind getOp() {
        return this.op;
    }

    @Generated
    public void setOp(SqlKind op) {
        this.op = op;
    }

    @Generated
    public String getOpName() {
        return this.opName;
    }

    @Generated
    public void setOpName(String opName) {
        this.opName = opName;
    }

    @Generated
    public NonEquiJoinCondition[] getOperands() {
        return this.operands;
    }

    @Generated
    public void setOperands(NonEquiJoinCondition[] operands) {
        this.operands = operands;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public TblColRef getColRef() {
        return this.colRef;
    }

    @Generated
    public void setColRef(TblColRef colRef) {
        this.colRef = colRef;
    }

    @Generated
    public String getExpr() {
        return this.expr;
    }

    @Generated
    public void setExpr(String expr) {
        this.expr = expr;
    }

    public static enum Type {
        EXPRESSION,
        COLUMN,
        LITERAL;

    }

    public static class TypedLiteralConverter {
        static final String NULL = "KY_LITERAL_NULL";

        private TypedLiteralConverter() {
        }

        public static Object stringValueToTypedValue(String value, DataType dataType) {
            if (value.equals(NULL)) {
                return null;
            }
            switch (dataType.getTypeName()) {
                case DECIMAL: {
                    return new BigDecimal(value);
                }
                case BIGINT: {
                    return Long.parseLong(value);
                }
                case SMALLINT: {
                    return Short.parseShort(value);
                }
                case TINYINT: {
                    return Byte.parseByte(value);
                }
                case INTEGER: {
                    return Integer.parseInt(value);
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case FLOAT: 
                case REAL: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DATE: {
                    return DateString.fromDaysSinceEpoch((int)Integer.parseInt(value));
                }
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: {
                    return TimeString.fromMillisOfDay((int)Integer.parseInt(value));
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return TimestampString.fromMillisSinceEpoch((long)Long.parseLong(value));
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(value);
                }
            }
            return value;
        }

        public static String typedLiteralToString(RexLiteral literal) {
            if (literal.getValue3() == null) {
                return NULL;
            }
            return String.valueOf(literal.getValue3());
        }
    }

    public static interface NeqConditionVisitor {
        default public NonEquiJoinCondition visit(NonEquiJoinCondition neqJoinCond) {
            if (neqJoinCond == null) {
                return null;
            }
            if (neqJoinCond.getType() == Type.LITERAL) {
                return this.visitLiteral(neqJoinCond);
            }
            if (neqJoinCond.getType() == Type.COLUMN) {
                return this.visitColumn(neqJoinCond);
            }
            if (neqJoinCond.getType() == Type.EXPRESSION) {
                return this.visitExpression(neqJoinCond);
            }
            return this.visit(neqJoinCond);
        }

        default public NonEquiJoinCondition visitExpression(NonEquiJoinCondition neqJoinCond) {
            NonEquiJoinCondition[] ops = new NonEquiJoinCondition[neqJoinCond.getOperands().length];
            for (int i = 0; i < neqJoinCond.getOperands().length; ++i) {
                ops[i] = this.visit(neqJoinCond.getOperands()[i]);
            }
            neqJoinCond.setOperands(ops);
            return neqJoinCond;
        }

        default public NonEquiJoinCondition visitColumn(NonEquiJoinCondition neqJoinCond) {
            return neqJoinCond;
        }

        default public NonEquiJoinCondition visitLiteral(NonEquiJoinCondition neqJoinCond) {
            return neqJoinCond;
        }
    }

    static class NeqCondOperandComparator
    implements Comparator<NonEquiJoinCondition> {
        NeqCondOperandComparator() {
        }

        @Override
        public int compare(NonEquiJoinCondition cond1, NonEquiJoinCondition cond2) {
            if (!(Objects.equals(cond1.getOp(), cond2.getOp()) && cond1.getOperands().length == cond2.getOperands().length && Objects.equals((Object)cond1.getType(), (Object)cond2.getType()) && Objects.equals(cond1.getDataType(), cond2.getDataType()))) {
                return 1;
            }
            if (cond1.getOp() == SqlKind.OTHER || cond1.getOp() == SqlKind.OTHER_FUNCTION && !Objects.equals(cond1.getOpName(), cond2.getOpName())) {
                return 1;
            }
            if (cond1.getType() == Type.LITERAL) {
                return Objects.equals(cond1.getValue(), cond2.getValue()) ? 0 : 1;
            }
            if (cond1.getType() == Type.COLUMN) {
                return Objects.equals(cond1.getColRef().getColumnDesc(), cond2.getColRef().getColumnDesc()) ? 0 : 1;
            }
            NonEquiJoinCondition[] sorted1 = cond1.getSortedOperands();
            NonEquiJoinCondition[] sorted2 = cond2.getSortedOperands();
            for (int i = 0; i < sorted1.length; ++i) {
                if (this.compare(sorted1[i], sorted2[i]) == 0) continue;
                return 1;
            }
            return 0;
        }
    }

    public static final class SimplifiedJoinCondition
    implements Serializable {
        private static final long serialVersionUID = -1577556052145832500L;
        @JsonProperty(value="foreign_key")
        private String foreignKey;
        @JsonProperty(value="primary_key")
        private String primaryKey;
        @JsonProperty(value="op")
        private SqlKind op;
        @JsonIgnore
        private TblColRef fk;
        @JsonIgnore
        private TblColRef pk;

        public SimplifiedJoinCondition(String foreignKey, String primaryKey, SqlKind op) {
            this.foreignKey = foreignKey;
            this.primaryKey = primaryKey;
            this.op = op;
        }

        public SimplifiedJoinCondition(String foreignKey, TblColRef fk, String primaryKey, TblColRef pk, SqlKind op) {
            this.foreignKey = foreignKey;
            this.primaryKey = primaryKey;
            this.op = op;
            this.fk = fk;
            this.pk = pk;
        }

        public String displaySql() {
            return this.fk.getDoubleQuoteExp() + " " + this.op.sql + " " + this.pk.getDoubleQuoteExp();
        }

        @Generated
        public void setForeignKey(String foreignKey) {
            this.foreignKey = foreignKey;
        }

        @Generated
        public void setPrimaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
        }

        @Generated
        public void setOp(SqlKind op) {
            this.op = op;
        }

        @Generated
        public void setFk(TblColRef fk) {
            this.fk = fk;
        }

        @Generated
        public void setPk(TblColRef pk) {
            this.pk = pk;
        }

        @Generated
        public String getForeignKey() {
            return this.foreignKey;
        }

        @Generated
        public String getPrimaryKey() {
            return this.primaryKey;
        }

        @Generated
        public SqlKind getOp() {
            return this.op;
        }

        @Generated
        public TblColRef getFk() {
            return this.fk;
        }

        @Generated
        public TblColRef getPk() {
            return this.pk;
        }

        @Generated
        public SimplifiedJoinCondition() {
        }
    }
}

