/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.IManager;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.model.CcModelRelationDesc;
import org.apache.kylin.metadata.model.TableModelRelationDesc;
import org.apache.kylin.metadata.query.QueryRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class Manager<T extends RootPersistentEntity>
implements IManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(Manager.class);
    protected static final HashMap<Class<?>, MetadataType> entityClassTypeMap = new HashMap();
    protected final KylinConfig config;
    protected final String project;
    protected CachedCrudAssist<T> crud;

    public static <T extends RootPersistentEntity> Manager<T> getInstance(KylinConfig config, String project, Class<T> cls) {
        if (RootPersistentEntity.class.isAssignableFrom(cls) && entityClassTypeMap.containsKey(cls)) {
            return (Manager)config.getManager(project, Manager.class, cls);
        }
        throw new IllegalArgumentException("Cannot create manager for class: " + cls);
    }

    static <T extends RootPersistentEntity> Manager<T> newInstance(final Class<T> entityClass, KylinConfig cfg, String project) {
        return new Manager<T>(cfg, project, entityClassTypeMap.get(entityClass)){

            @Override
            public Logger logger() {
                return logger;
            }

            @Override
            public String name() {
                return entityClass.getName().replace(".class", "Manager");
            }

            @Override
            public Class<T> entityType() {
                return entityClass;
            }
        };
    }

    protected ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    protected Manager(KylinConfig cfg, String project, MetadataType type) {
        if (this.logger().isInfoEnabled() && !UnitOfWork.isAlreadyInTransaction()) {
            this.logger().info("Initializing {} with KylinConfig Id: {} for project {}", new Object[]{this.name(), System.identityHashCode(cfg), project});
        }
        this.config = cfg;
        this.project = project;
        this.initCrud(type, project);
    }

    protected void initCrud(MetadataType type, String project) {
        this.crud = new CachedCrudAssist<T>(this.getStore(), type, project, this.entityType()){

            @Override
            protected T initEntityAfterReload(T entity, String resourceName) {
                return entity;
            }
        };
        this.crud.setCheckCopyOnWrite(true);
    }

    public String getResourcePath(String resourceName) {
        return this.crud.resourcePath(resourceName);
    }

    protected T save(T entity) {
        return this.crud.save(entity);
    }

    public T copy(T entity) {
        return this.crud.copyBySerialization(entity);
    }

    protected T copyForWrite(T entity) {
        return this.crud.copyForWrite(entity);
    }

    public T createAS(T entity) {
        if (entity.getUuid() == null) {
            throw new IllegalArgumentException();
        }
        T copy = this.copyForWrite(entity);
        if (this.crud.contains(copy.resourceName())) {
            throw new IllegalArgumentException("Entity '" + entity.getUuid() + "' already exists");
        }
        return this.save(copy);
    }

    public List<T> listAll() {
        return Lists.newArrayList(this.crud.listAll());
    }

    public List<T> listByFilter(RawResourceFilter filter) {
        return Lists.newArrayList(this.crud.listByFilter(filter));
    }

    public Optional<T> get(String resourceName) {
        if (StringUtils.isEmpty((CharSequence)resourceName)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.crud.get(resourceName));
    }

    protected T internalUpdate(T entity) {
        if (entity.isCachedAndShared()) {
            throw new IllegalStateException();
        }
        if (entity.getUuid() == null) {
            throw new IllegalArgumentException();
        }
        String name = entity.resourceName();
        if (!this.crud.contains(name)) {
            throw new IllegalArgumentException("Entity '" + name + "' does not exist.");
        }
        return this.save(entity);
    }

    public T update(String resourceName, Consumer<T> updater) {
        return (T)((RootPersistentEntity)this.get(resourceName).map(this::copyForWrite).map(copied -> {
            updater.accept(copied);
            return this.internalUpdate(copied);
        }).orElse(null));
    }

    public T upsert(String resourceName, Consumer<T> updater, Supplier<T> creator) {
        return (T)this.get(resourceName).map(this::copyForWrite).map(copied -> {
            updater.accept(copied);
            return this.internalUpdate(copied);
        }).orElseGet(() -> {
            RootPersistentEntity newEntity = (RootPersistentEntity)creator.get();
            updater.accept(newEntity);
            return this.createAS(newEntity);
        });
    }

    public void delete(T entity) {
        this.crud.delete(entity);
    }

    static {
        entityClassTypeMap.put(CcModelRelationDesc.class, MetadataType.CC_MODEL_RELATION);
        entityClassTypeMap.put(TableModelRelationDesc.class, MetadataType.TABLE_MODEL_RELATION);
        entityClassTypeMap.put(QueryRecord.class, MetadataType.QUERY_RECORD);
    }
}

