/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.extendedcolumn;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class ExtendedColumnSerializer
extends DataTypeSerializer<ByteArray> {
    private int extendedColumnSize;
    private int maxLength;

    public ExtendedColumnSerializer(DataType dataType) {
        this.extendedColumnSize = dataType.getPrecision();
        this.maxLength = this.extendedColumnSize + 4;
    }

    @Override
    public int peekLength(ByteBuffer in) {
        int mark = in.position();
        int size = BytesUtil.readVInt((ByteBuffer)in);
        int total = in.position() - mark;
        if (size >= 0) {
            total += size;
        }
        in.position(mark);
        return total;
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    @Override
    public int getStorageBytesEstimate() {
        return this.extendedColumnSize / 2;
    }

    public void serialize(ByteArray value, ByteBuffer out) {
        if (value != null && value.array() != null) {
            BytesUtil.writeByteArray((byte[])value.array(), (int)value.offset(), (int)value.length(), (ByteBuffer)out);
        } else {
            BytesUtil.writeByteArray(null, (ByteBuffer)out);
        }
    }

    public ByteArray deserialize(ByteBuffer in) {
        return new ByteArray(BytesUtil.readByteArray((ByteBuffer)in));
    }
}

