/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import java.util.List;
import org.apache.gluten.execution.BatchScanExecTransformer;
import org.apache.gluten.execution.FileSourceScanExecTransformer;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.AppStatus;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.KylinFileSourceScanExec;
import org.apache.spark.sql.execution.KylinStorageScanExec;
import org.apache.spark.sql.execution.LayoutFileSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hive.HiveTableScanExecTransformer;
import org.apache.spark.sql.hive.execution.HiveTableScanExec;
import org.apache.spark.status.api.v1.JobData;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

public final class QueryMetricUtils$
implements Logging {
    public static QueryMetricUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new QueryMetricUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Tuple2<List<Long>, List<Long>> collectScanMetrics(SparkPlan plan) {
        Tuple2 tuple2;
        try {
            Tuple2<Object, Object> metrics = this.collectAdaptiveSparkPlanExecMetrics(plan, 0L, 0L);
            List scanRows = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Long[]{new Long(metrics._1$mcJ$sp())})).toList()).asJava();
            List scanBytes = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Long[]{new Long(metrics._2$mcJ$sp())})).toList()).asJava();
            tuple2 = new Tuple2((Object)scanRows, (Object)scanBytes);
        }
        catch (Throwable throwable) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred when collect query scan metrics.", throwable);
            tuple2 = new Tuple2(null, null);
        }
        return tuple2;
    }

    public Tuple2<Object, Object> collectAdaptiveSparkPlanExecMetrics(SparkPlan exec, long scanRow, long scanBytes) {
        Tuple2.mcJJ.sp sp2;
        block13: {
            SparkPlan sparkPlan;
            while (true) {
                if ((sparkPlan = exec) instanceof LayoutFileSourceScanExec) {
                    LayoutFileSourceScanExec layoutFileSourceScanExec = (LayoutFileSourceScanExec)sparkPlan;
                    sp2 = new Tuple2.mcJJ.sp(scanRow + ((SQLMetric)layoutFileSourceScanExec.metrics().apply((Object)"numOutputRows")).value(), scanBytes + ((SQLMetric)layoutFileSourceScanExec.metrics().apply((Object)"readBytes")).value());
                    break block13;
                }
                if (sparkPlan instanceof KylinFileSourceScanExec) {
                    KylinFileSourceScanExec kylinFileSourceScanExec = (KylinFileSourceScanExec)sparkPlan;
                    sp2 = new Tuple2.mcJJ.sp(scanRow + ((SQLMetric)kylinFileSourceScanExec.metrics().apply((Object)"numOutputRows")).value(), scanBytes + ((SQLMetric)kylinFileSourceScanExec.metrics().apply((Object)"readBytes")).value());
                    break block13;
                }
                if (sparkPlan instanceof FileSourceScanExecTransformer) {
                    FileSourceScanExecTransformer fileSourceScanExecTransformer = (FileSourceScanExecTransformer)sparkPlan;
                    sp2 = new Tuple2.mcJJ.sp(scanRow + ((SQLMetric)fileSourceScanExecTransformer.metrics().apply((Object)"numOutputRows")).value(), scanBytes + ((SQLMetric)fileSourceScanExecTransformer.metrics().apply((Object)"outputBytes")).value());
                    break block13;
                }
                if (sparkPlan instanceof FileSourceScanExec) {
                    FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
                    sp2 = new Tuple2.mcJJ.sp(scanRow + ((SQLMetric)fileSourceScanExec.metrics().apply((Object)"numOutputRows")).value(), scanBytes + ((SQLMetric)fileSourceScanExec.metrics().apply((Object)"readBytes")).value());
                    break block13;
                }
                if (sparkPlan instanceof KylinStorageScanExec) {
                    KylinStorageScanExec kylinStorageScanExec = (KylinStorageScanExec)sparkPlan;
                    sp2 = new Tuple2.mcJJ.sp(scanRow + ((SQLMetric)kylinStorageScanExec.metrics().apply((Object)"numOutputRows")).value(), scanBytes + ((SQLMetric)kylinStorageScanExec.metrics().apply((Object)"readBytes")).value());
                    break block13;
                }
                if (sparkPlan instanceof HiveTableScanExec) {
                    HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)sparkPlan;
                    sp2 = new Tuple2.mcJJ.sp(scanRow + ((SQLMetric)hiveTableScanExec.metrics().apply((Object)"numOutputRows")).value(), scanBytes + ((SQLMetric)hiveTableScanExec.metrics().apply((Object)"readBytes")).value());
                    break block13;
                }
                if (sparkPlan instanceof HiveTableScanExecTransformer) {
                    HiveTableScanExecTransformer hiveTableScanExecTransformer = (HiveTableScanExecTransformer)sparkPlan;
                    sp2 = new Tuple2.mcJJ.sp(scanRow + ((SQLMetric)hiveTableScanExecTransformer.metrics().apply((Object)"numOutputRows")).value(), scanBytes + ((SQLMetric)hiveTableScanExecTransformer.metrics().apply((Object)"outputBytes")).value());
                    break block13;
                }
                if (sparkPlan instanceof BatchScanExec) {
                    BatchScanExec batchScanExec = (BatchScanExec)sparkPlan;
                    long readBytes = BoxesRunTime.unboxToLong((Object)batchScanExec.metrics().get((Object)"readBytes").map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                    sp2 = new Tuple2.mcJJ.sp(scanRow + ((SQLMetric)batchScanExec.metrics().apply((Object)"numOutputRows")).value(), scanBytes + readBytes);
                    break block13;
                }
                if (sparkPlan instanceof BatchScanExecTransformer) {
                    BatchScanExecTransformer batchScanExecTransformer = (BatchScanExecTransformer)sparkPlan;
                    long numOutputRows = BoxesRunTime.unboxToLong((Object)batchScanExecTransformer.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                    long outputBytes = BoxesRunTime.unboxToLong((Object)batchScanExecTransformer.metrics().get((Object)"outputBytes").map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                    sp2 = new Tuple2.mcJJ.sp(scanRow + numOutputRows, scanBytes + outputBytes);
                    break block13;
                }
                if (sparkPlan instanceof ShuffleQueryStageExec) {
                    ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan;
                    exec = shuffleQueryStageExec.plan();
                    continue;
                }
                if (!(sparkPlan instanceof AdaptiveSparkPlanExec)) break;
                AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
                exec = adaptiveSparkPlanExec.executedPlan();
            }
            if (sparkPlan != null) {
                SparkPlan sparkPlan2 = sparkPlan;
                LongRef newScanRow = LongRef.create((long)scanRow);
                LongRef newScanBytes = LongRef.create((long)scanBytes);
                sparkPlan2.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                    QueryMetricUtils$.$anonfun$collectAdaptiveSparkPlanExecMetrics$7(scanRow, scanBytes, newScanRow, newScanBytes, child);
                    return BoxedUnit.UNIT;
                });
                sp2 = new Tuple2.mcJJ.sp(newScanRow.elem, newScanBytes.elem);
            } else {
                throw new MatchError((Object)sparkPlan);
            }
        }
        return sp2;
    }

    public Tuple3<Long, Long, Long> collectTaskRelatedMetrics(String jobGroup, SparkContext sparkContext) {
        Tuple3 tuple3;
        try {
            AppStatus appStatus = new AppStatus(sparkContext);
            Seq<JobData> jobData = appStatus.getJobData(jobGroup);
            int jobCount = jobData.size();
            int stageCount = ((SeqLike)jobData.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.stageIds(), Seq$.MODULE$.canBuildFrom())).size();
            int taskCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)jobData.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.numTasks()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            tuple3 = new Tuple3((Object)Predef$.MODULE$.long2Long((long)jobCount), (Object)Predef$.MODULE$.long2Long((long)stageCount), (Object)Predef$.MODULE$.long2Long((long)taskCount));
        }
        catch (Throwable throwable) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred when collect query task related metrics.", throwable);
            tuple3 = new Tuple3((Object)Predef$.MODULE$.long2Long(0L), (Object)Predef$.MODULE$.long2Long(0L), (Object)Predef$.MODULE$.long2Long(0L));
        }
        return tuple3;
    }

    public static final /* synthetic */ void $anonfun$collectAdaptiveSparkPlanExecMetrics$7(long scanRow$1, long scanBytes$1, LongRef newScanRow$1, LongRef newScanBytes$1, SparkPlan child) {
        if (child instanceof SparkPlan) {
            Tuple2<Object, Object> result = MODULE$.collectAdaptiveSparkPlanExecMetrics(child, scanRow$1, scanBytes$1);
            newScanRow$1.elem += result._1$mcJ$sp();
            newScanBytes$1.elem += result._2$mcJ$sp();
        } else {
            MODULE$.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Not sparkPlan in collectAdaptiveSparkPlanExecMetrics, child: ").append(child.getClass().getName()).toString());
        }
    }

    private QueryMetricUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

