/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceTool;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.Event;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStoreTool;
import org.apache.kylin.common.persistence.metadata.jdbc.AuditLogRowMapper;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.persistence.resources.ProjectRawResource;
import org.apache.kylin.common.persistence.transaction.AuditLogReplayWorker;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.junit.JdbcInfo;
import org.apache.kylin.junit.annotation.JdbcMetadataInfo;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.kylin.junit.annotation.OverwriteProp;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.util.ReflectionTestUtils;

@MetadataInfo(onlyProps=true)
@JdbcMetadataInfo
class JdbcAuditLogStoreTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcAuditLogStoreTest.class);
    private static final String LOCAL_INSTANCE = "127.0.0.1";
    private final Charset charset = Charset.defaultCharset();

    JdbcAuditLogStoreTest() {
    }

    @AfterEach
    public void destroy() throws Exception {
        JdbcTemplate jdbcTemplate = JdbcUtil.getJdbcTemplate((KylinConfig)KylinConfig.getInstanceFromEnv());
        jdbcTemplate.batchUpdate(new String[]{"SHUTDOWN;"});
    }

    private void prepare2Resource() {
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/abc");
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/abc2");
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/abc3");
            store.checkAndPutResource("PROJECT/abc", ByteSource.wrap((byte[])("{\"name\" : \"abc\",\"uuid\" : \"" + UUID.randomUUID() + "\"}").getBytes(this.charset)), -1L);
            store.checkAndPutResource("PROJECT/abc2", ByteSource.wrap((byte[])("{\"name\" : \"abc2\",\"uuid\" : \"" + UUID.randomUUID() + "\"}").getBytes(this.charset)), -1L);
            ByteSource wrap2 = ByteSource.wrap((byte[])("{\"name\" : \"abc3\",\"uuid\" : \"" + UUID.randomUUID() + "\"}").getBytes(this.charset));
            store.checkAndPutResource("PROJECT/abc3", wrap2, -1L);
            store.checkAndPutResource("PROJECT/abc3", wrap2, 0L);
            store.deleteResource("PROJECT/abc");
            return 0;
        }, (String)"_global");
    }

    @Test
    void testUpdateResourceWithLog(JdbcInfo info) throws Exception {
        this.prepare2Resource();
        StorageURL url = TestUtils.getTestConfig().getMetadataUrl();
        JdbcTemplate jdbcTemplate = info.getJdbcTemplate();
        List all = jdbcTemplate.query(JdbcAuditLogStore.SELECT_LIST_TERM + " from " + url.getIdentifier() + "_audit_log_v2", (RowMapper)new AuditLogRowMapper());
        Assert.assertEquals((long)5L, (long)all.size());
        Assert.assertEquals((Object)"PROJECT/abc", (Object)((AuditLog)all.get(0)).getResPath());
        Assert.assertEquals((Object)"PROJECT/abc2", (Object)((AuditLog)all.get(1)).getResPath());
        Assert.assertEquals((Object)"PROJECT/abc3", (Object)((AuditLog)all.get(2)).getResPath());
        Assert.assertEquals((Object)"PROJECT/abc3", (Object)((AuditLog)all.get(3)).getResPath());
        Assert.assertEquals((Object)"PROJECT/abc", (Object)((AuditLog)all.get(4)).getResPath());
        Assert.assertEquals((Object)0L, (Object)((AuditLog)all.get(0)).getMvcc());
        Assert.assertEquals((Object)0L, (Object)((AuditLog)all.get(1)).getMvcc());
        Assert.assertEquals((Object)0L, (Object)((AuditLog)all.get(2)).getMvcc());
        Assert.assertEquals((Object)1L, (Object)((AuditLog)all.get(3)).getMvcc());
        Assert.assertEquals((Object)false, (Object)((AuditLog)all.get(0)).isDiffFlag());
        Assert.assertEquals((Object)false, (Object)((AuditLog)all.get(1)).isDiffFlag());
        Assert.assertEquals((Object)false, (Object)((AuditLog)all.get(2)).isDiffFlag());
        Assert.assertEquals((Object)true, (Object)((AuditLog)all.get(3)).isDiffFlag());
        Assert.assertNull((Object)((AuditLog)all.get(4)).getMvcc());
        Assert.assertEquals((long)1L, (long)all.stream().map(AuditLog::getUnitId).distinct().count());
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"USER1", (Object)"ADMIN"));
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            store.deleteResource("PROJECT/abc2");
            store.deleteResource("PROJECT/abc3");
            return 0;
        }, (String)"_global");
        List allStep2 = jdbcTemplate.query(JdbcAuditLogStore.SELECT_LIST_TERM + " from " + url.getIdentifier() + "_audit_log_v2", (RowMapper)new AuditLogRowMapper());
        Assert.assertEquals((long)7L, (long)allStep2.size());
        Assert.assertNull((Object)((AuditLog)allStep2.get(5)).getMvcc());
        Assert.assertNull((Object)((AuditLog)allStep2.get(6)).getMvcc());
        Assert.assertEquals((Object)"USER1", (Object)((AuditLog)allStep2.get(5)).getOperator());
        Assert.assertEquals((Object)"USER1", (Object)((AuditLog)allStep2.get(6)).getOperator());
        Assert.assertEquals((long)2L, (long)allStep2.stream().map(AuditLog::getUnitId).distinct().count());
        AuditLogStore auditLogStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).getAuditLogStore();
        auditLogStore.close();
    }

    @Test
    void testRestore(JdbcInfo info) throws Exception {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc", info, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc2", info, false);
        String abc3Uuid = RandomUtil.randomUUIDStr();
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(abc3Uuid, "abc3", info, false, 0L, "unitId");
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(abc3Uuid, "abc3", info, false, 1L, "unitId");
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc", info, true);
        workerStore.catchup();
        NavigableSet strings = workerStore.listResourcesRecursively(MetadataType.ALL.name());
        Assertions.assertEquals((int)3, (int)strings.size());
        for (int i = 0; i < 1000; ++i) {
            String projectName = "p" + (i + 1000);
            String unitId = RandomUtil.randomUUIDStr();
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("a_" + projectName, info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("b_" + projectName, info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("c_" + projectName, info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(RandomUtil.randomUUIDStr(), "c_" + projectName, info, false, 1L, unitId);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("a_" + projectName, info, true);
        }
        workerStore.getAuditLogStore().catchupWithTimeout();
        Awaitility.await().atMost(8L, TimeUnit.SECONDS).until(() -> 2003 == workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        workerStore.getAuditLogStore().catchupWithTimeout();
        Assertions.assertEquals((int)2003, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
        workerStore.getAuditLogStore().close();
    }

    @Test
    void testRestoreWithDev(JdbcInfo info) throws Exception {
        KylinConfig testConfig = TestUtils.getTestConfig();
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)testConfig);
        workerStore.createMetaStoreUuidIfNotExist();
        testConfig.setProperty("kylin.env", "DEV");
        Assert.assertEquals((long)1L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        this.prepare2Resource();
        workerStore.catchup();
        NavigableSet strings = workerStore.listResourcesRecursively(MetadataType.ALL.name());
        Assert.assertEquals((long)3L, (long)strings.size());
        for (int i = 0; i < 1000; ++i) {
            String projectName = "p" + (i + 1000);
            String unitId = RandomUtil.randomUUIDStr();
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("a_" + projectName, info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("b_" + projectName, info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("c_" + projectName, info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(RandomUtil.randomUUIDStr(), "c_" + projectName, info, false, 1L, unitId);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("a_" + projectName, info, true);
        }
        workerStore.getAuditLogStore().catchupWithTimeout();
        Awaitility.await().atMost(8L, TimeUnit.SECONDS).until(() -> 2003 == workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        workerStore.getAuditLogStore().catchupWithTimeout();
        Assert.assertEquals((long)2003L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
        testConfig.setProperty("kylin.env", "UT");
        workerStore.getAuditLogStore().close();
    }

    @Test
    @OverwriteProp.OverwriteProps(value={@OverwriteProp(key="kylin.metadata.audit-log-json-patch-enabled", value="false")})
    void testHandleVersionConflict(JdbcInfo info) throws Exception {
        TestUtils.getTestConfig().setProperty("kylin.auditlog.replay-groupby-project-reload-enable", "false");
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        ProjectRawResource rawResource = RawResourceTool.createProjectRawResource("abc", 2L);
        workerStore.getMetadataStore().save(rawResource.getMetaType(), (RawResource)rawResource);
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assert.assertEquals((long)1L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc", info, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(RandomUtil.randomUUIDStr(), "abc", info, false, 2L, RandomUtil.randomUUIDStr());
        workerStore.catchup();
        Assertions.assertEquals((int)2, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
        Assertions.assertEquals((long)1L, (long)workerStore.getResource("PROJECT/abc").getMvcc());
    }

    @Test
    public void testWaitLogAllCommit(JdbcInfo info) throws Exception {
        TestUtils.getTestConfig().setProperty("kylin.auditlog.replay-groupby-project-reload-enable", "false");
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assert.assertEquals((long)1L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        StorageURL url = TestUtils.getTestConfig().getMetadataUrl();
        JdbcTemplate jdbcTemplate = info.getJdbcTemplate();
        String unitId = RandomUtil.randomUUIDStr();
        String sql = "insert into %s (id, meta_key,meta_content,meta_ts,meta_mvcc,unit_id,operator,instance,project,diff_flag) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        jdbcTemplate.batchUpdate(String.format(Locale.ROOT, sql, url.getIdentifier() + "_audit_log_v2"), Arrays.asList({22, "PROJECT/abc", ("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"abc\",\"name\" : \"abc\"}").getBytes(this.charset), System.currentTimeMillis(), 0, unitId, null, LOCAL_INSTANCE, null, false}, {4, "PROJECT/abc2", ("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"abc2\",\"name\" : \"abc2\"}").getBytes(this.charset), System.currentTimeMillis(), 0, unitId, null, LOCAL_INSTANCE, null, false}));
        workerStore.getAuditLogStore().restore(3L);
        Assert.assertEquals((long)3L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
    }

    @Test
    void testWaitLogAllCommit_DelayQueue(JdbcInfo info) throws Exception {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        StorageURL url = TestUtils.getTestConfig().getMetadataUrl();
        JdbcTemplate jdbcTemplate = info.getJdbcTemplate();
        String unitId = RandomUtil.randomUUIDStr();
        String sql = "insert into %s (id, meta_key,meta_content,meta_ts,meta_mvcc,unit_id,operator,instance,project,diff_flag) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        jdbcTemplate.batchUpdate(String.format(Locale.ROOT, sql, url.getIdentifier() + "_audit_log_v2"), Arrays.asList({900, "PROJECT/abc", ("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"abc\",\"name\" : \"abc\"}").getBytes(this.charset), System.currentTimeMillis(), 0, unitId, null, LOCAL_INSTANCE, null, false}, {4, "PROJECT/abc2", ("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"abc2\",\"name\" : \"abc2\"}").getBytes(this.charset), System.currentTimeMillis(), 0, unitId, null, LOCAL_INSTANCE, null, false}));
        workerStore.getAuditLogStore().restore(3L);
        Assertions.assertEquals((int)3, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        jdbcTemplate.batchUpdate(String.format(Locale.ROOT, sql, url.getIdentifier() + "_audit_log_v2"), Arrays.asList({800, "PROJECT/abc3", ("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"abc\",\"name\" : \"abc\"}").getBytes(this.charset), System.currentTimeMillis(), 0, unitId, null, LOCAL_INSTANCE, null, false}, {801, "PROJECT/abc4", ("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"abc2\",\"name\" : \"abc2\"}").getBytes(this.charset), System.currentTimeMillis(), 0, unitId, null, LOCAL_INSTANCE, null, false}));
        workerStore.getAuditLogStore().catchup();
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> 5 == workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        workerStore.getAuditLogStore().close();
    }

    @Test
    void testFetchById(JdbcInfo info) throws IOException {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc", info, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc2", info, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc3", info, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc4", info, false);
        List<Long> idList = Arrays.asList(2L, 3L);
        List fetchResult = ((JdbcAuditLogStore)workerStore.getAuditLogStore()).fetch(idList);
        Assertions.assertEquals((int)2, (int)fetchResult.size());
        Assertions.assertEquals(idList, fetchResult.stream().map(AuditLog::getId).collect(Collectors.toList()));
        workerStore.getAuditLogStore().close();
    }

    @Test
    void testGetMinMaxId(JdbcInfo info) throws IOException {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        UnitOfWork.doInTransactionWithRetry(() -> {
            UnitOfWork.get().getCopyForWriteItems().add(ResourceStore.METASTORE_UUID_TAG);
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            store.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
            return null;
        }, (String)"p1");
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        StorageURL url = TestUtils.getTestConfig().getMetadataUrl();
        JdbcTemplate jdbcTemplate = info.getJdbcTemplate();
        String unitId = RandomUtil.randomUUIDStr();
        String sql = "insert into %s (id, meta_key,meta_content,meta_ts,meta_mvcc,unit_id,operator,instance,project,diff_flag) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        jdbcTemplate.batchUpdate(String.format(Locale.ROOT, sql, url.getIdentifier() + "_audit_log_v2"), Arrays.asList({900, "PROJECT/abc", ("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"abc\",\"name\" : \"abc\"}").getBytes(this.charset), System.currentTimeMillis(), 0, unitId, null, LOCAL_INSTANCE, null, false}, {4, "PROJECT/abc2", ("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"abc2\",\"name\" : \"abc2\"}").getBytes(this.charset), System.currentTimeMillis(), 0, unitId, null, LOCAL_INSTANCE, null, false}));
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        Assertions.assertEquals((long)900L, (long)auditLogStore.getMaxId());
        Assertions.assertEquals((long)1L, (long)auditLogStore.getMinId());
        auditLogStore.close();
    }

    @Test
    void testSaveWait_WithoutSleep(JdbcInfo info) throws IOException {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        List<ResourceCreateOrUpdateEvent> events = Collections.singletonList(new ResourceCreateOrUpdateEvent("PROJECT/test", new RawResource("test", RawResourceTool.createByteSource("test"), System.currentTimeMillis(), 0L)));
        UnitMessages unitMessages = new UnitMessages(events);
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        auditLogStore.save(unitMessages);
        List result = auditLogStore.fetch(0L, 2L);
        Assertions.assertEquals((int)1, (int)result.size());
        auditLogStore.close();
    }

    @Test
    void testSaveWait_WithSleep(JdbcInfo info) throws IOException {
        TestUtils.getTestConfig().setProperty("kylin.env.unitofwork-simulation-enabled", "true");
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        List<ResourceCreateOrUpdateEvent> events = Collections.singletonList(new ResourceCreateOrUpdateEvent("PROJECT/test", new RawResource("test", RawResourceTool.createByteSource("test"), System.currentTimeMillis(), 0L)));
        UnitMessages unitMessages = new UnitMessages(events);
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").sleepMills(100L).maxRetry(1).processor(() -> {
            auditLogStore.save(unitMessages);
            return 0;
        }).build());
        List result = auditLogStore.fetch(0L, 2L);
        Assertions.assertEquals((int)1, (int)result.size());
        auditLogStore.close();
    }

    @Test
    void testSaveWait_WithSleepNotInTrans(JdbcInfo info) throws IOException {
        TestUtils.getTestConfig().setProperty("kylin.env.unitofwork-simulation-enabled", "true");
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        List<ResourceCreateOrUpdateEvent> events = Collections.singletonList(new ResourceCreateOrUpdateEvent("PROJECT/test", new RawResource("test", RawResourceTool.createByteSource("test"), System.currentTimeMillis(), 0L)));
        UnitMessages unitMessages = new UnitMessages(events);
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        auditLogStore.save(unitMessages);
        List result = auditLogStore.fetch(0L, 2L);
        Assertions.assertEquals((int)1, (int)result.size());
        auditLogStore.close();
    }

    @Test
    void testRestoreWithoutOrder(JdbcInfo info) throws Exception {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assert.assertEquals((long)1L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        String unitId1 = RandomUtil.randomUUIDStr();
        String unitId2 = RandomUtil.randomUUIDStr();
        String uuid = RandomUtil.randomUUIDStr();
        String uuid3 = RandomUtil.randomUUIDStr();
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(uuid, "abc", info, false, 0L, unitId1);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(RandomUtil.randomUUIDStr(), "abc2", info, false, 0L, unitId2);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(uuid3, "abc3", info, false, 0L, unitId1);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(uuid3, "abc3", info, false, 1L, unitId2);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(uuid, "abc", info, true, 1L, unitId1);
        workerStore.catchup();
        Assert.assertEquals((long)3L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        String uuid4 = RandomUtil.randomUUIDStr();
        AuditLog abc4 = JdbcAuditLogStoreTool.createProjectAuditLog("abc4", 0L, uuid4, unitId1, false);
        List<Event> events = Arrays.asList(Event.fromLog((AuditLog)abc4), Event.fromLog((AuditLog)JdbcAuditLogStoreTool.createProjectAuditLog("abc4", 1L, uuid4, unitId2, abc4)), Event.fromLog((AuditLog)JdbcAuditLogStoreTool.createProjectAuditLog("abc5", 0L, RandomUtil.randomUUIDStr(), unitId1, false)));
        UnitMessages unitMessages = new UnitMessages(events);
        AuditLogStore auditLogStore = workerStore.getAuditLogStore();
        auditLogStore.save(unitMessages);
        workerStore.catchup();
        Assert.assertEquals((long)4L, (long)workerStore.listResourcesRecursively(MetadataType.PROJECT.name()).size());
        ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
    }

    @Test
    void testRestore_WhenOtherAppend(JdbcInfo info) throws Exception {
        KylinConfig testConfig = TestUtils.getTestConfig();
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)testConfig);
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assert.assertEquals((long)1L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        JdbcTemplate jdbcTemplate = info.getJdbcTemplate();
        String auditLogTableName = testConfig.getMetadataUrl().getIdentifier() + "_audit_log_v2";
        AtomicBoolean stopped = new AtomicBoolean(false);
        new Thread(() -> {
            int i = 0;
            String uuid = RandomUtil.randomUUIDStr();
            String uuid2 = RandomUtil.randomUUIDStr();
            String uuid3 = RandomUtil.randomUUIDStr();
            String unitId = RandomUtil.randomUUIDStr();
            AuditLog abc = JdbcAuditLogStoreTool.createProjectAuditLog("abc", (long)i, uuid, unitId, false);
            AuditLog abc2 = JdbcAuditLogStoreTool.createProjectAuditLog("abc2", (long)i, uuid, unitId, false);
            AuditLog abc3 = JdbcAuditLogStoreTool.createProjectAuditLog("abc3", (long)i, uuid, unitId, false);
            while (!stopped.get()) {
                List<Event> list;
                if (i == 0) {
                    list = Arrays.asList(Event.fromLog((AuditLog)abc), Event.fromLog((AuditLog)abc2), Event.fromLog((AuditLog)abc3));
                } else {
                    Event[] eventArray = new Event[3];
                    abc = JdbcAuditLogStoreTool.createProjectAuditLog("abc", (long)i, uuid, unitId, abc);
                    eventArray[0] = Event.fromLog((AuditLog)abc);
                    abc2 = JdbcAuditLogStoreTool.createProjectAuditLog("abc2", (long)i, uuid2, unitId, abc2);
                    eventArray[1] = Event.fromLog((AuditLog)abc2);
                    abc3 = JdbcAuditLogStoreTool.createProjectAuditLog("abc3", (long)i, uuid3, unitId, abc3);
                    eventArray[2] = Event.fromLog((AuditLog)abc3);
                    list = Arrays.asList(eventArray);
                }
                List<Event> events = list;
                UnitMessages unitMessages = new UnitMessages(events);
                AuditLogStore auditLogStore = workerStore.getAuditLogStore();
                auditLogStore.save(unitMessages);
                ++i;
            }
        }).start();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> (Long)jdbcTemplate.queryForObject("select count(1) from " + auditLogTableName, Long.class) > 1000L);
        workerStore.catchup();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> (Long)jdbcTemplate.queryForObject("select count(1) from " + auditLogTableName, Long.class) > 2000L);
        Assert.assertEquals((long)4L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        stopped.compareAndSet(false, true);
        ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
    }

    @OverwriteProp(key="kylin.metadata.audit-log.max-size", value="1000")
    @Test
    void testRotate(JdbcInfo info) throws Exception {
        KylinConfig config = TestUtils.getTestConfig();
        JdbcTemplate jdbcTemplate = info.getJdbcTemplate();
        StorageURL url = config.getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)props);
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager((DataSource)dataSource);
        JdbcAuditLogStore auditLogStore = new JdbcAuditLogStore(config, jdbcTemplate, transactionManager, config.getMetadataUrl().getIdentifier() + "_audit_log_v2");
        auditLogStore.createIfNotExist();
        String auditLogTableName = config.getMetadataUrl().getIdentifier() + "_audit_log_v2";
        for (int i = 0; i < 1000; ++i) {
            String projectName = "p" + (i + 1000);
            String unitId = RandomUtil.randomUUIDStr();
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("a_" + projectName, info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("b_" + projectName, info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("c_" + projectName, info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(RandomUtil.randomUUIDStr(), "c_" + projectName, info, false, 1L, unitId);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("a_" + projectName, info, true);
        }
        auditLogStore.rotate();
        long count = (Long)jdbcTemplate.queryForObject("select count(1) from " + auditLogTableName, Long.class);
        Assert.assertEquals((long)1000L, (long)count);
        TestUtils.getTestConfig().setProperty("kylin.metadata.audit-log.max-size", "1500");
        auditLogStore.rotate();
        count = (Long)jdbcTemplate.queryForObject("select count(1) from " + auditLogTableName, Long.class);
        Assert.assertEquals((long)1000L, (long)count);
        auditLogStore.close();
    }

    @OverwriteProp.OverwriteProps(value={@OverwriteProp(key="kylin.metadata.audit-log.max-size", value="2000"), @OverwriteProp(key="kylin.metadata.audit-log.delete-batch-size", value="100")})
    @Test
    void testRotateDelete(JdbcInfo info) throws Exception {
        KylinConfig config = TestUtils.getTestConfig();
        JdbcTemplate jdbcTemplate = info.getJdbcTemplate();
        StorageURL url = config.getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)props);
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager((DataSource)dataSource);
        JdbcAuditLogStore auditLogStore = new JdbcAuditLogStore(config, jdbcTemplate, transactionManager, info.getTableName() + "_audit_log_v2");
        auditLogStore.createIfNotExist();
        String auditLogTableName = info.getTableName() + "_audit_log_v2";
        for (int i = 0; i < 1000; ++i) {
            String projectNamePrefix = "p" + (i + 1000);
            String unitId = RandomUtil.randomUUIDStr();
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(projectNamePrefix + "abc", info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(projectNamePrefix + "abc2", info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(projectNamePrefix + "abc3", info, false);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(RandomUtil.randomUUIDStr(), projectNamePrefix + "abc3", info, false, 1L, unitId);
            JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(projectNamePrefix + "abc", info, true);
        }
        auditLogStore.rotate();
        long count = (Long)jdbcTemplate.queryForObject("select count(1) from " + auditLogTableName, Long.class);
        Assert.assertEquals((long)2000L, (long)count);
        auditLogStore.rotate();
        count = (Long)jdbcTemplate.queryForObject("select count(1) from " + auditLogTableName, Long.class);
        Assert.assertEquals((long)2000L, (long)count);
        auditLogStore.close();
    }

    @Test
    public void testGet() throws IOException {
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/123");
            store.checkAndPutResource("PROJECT/123", ByteSource.wrap((byte[])("{ \"uuid\" : \"" + UUID.randomUUID() + "\",\"meta_key\" : \"123\",\"name\" : \"123\"}").getBytes(this.charset)), -1L);
            return 0;
        }, (String)"p1");
        AuditLogStore auditLogStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).getAuditLogStore();
        AuditLog auditLog = auditLogStore.get("PROJECT/123", 0L);
        Assert.assertNotNull((Object)auditLog);
        auditLog = auditLogStore.get("PROJECT/126", 0L);
        Assert.assertNull((Object)auditLog);
        auditLog = auditLogStore.get("PROJECT/abc", 1L);
        Assert.assertNull((Object)auditLog);
        auditLogStore.close();
    }

    @Test
    void testMannualHandleReplay(JdbcInfo info) throws Exception {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc", info, false);
        JdbcAuditLogStore auditLogStore = new JdbcAuditLogStore(TestUtils.getTestConfig());
        auditLogStore.catchupWithTimeout();
        Assert.assertEquals((long)1L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
    }

    @Test
    void testStopReplay() throws IOException {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        workerStore.getAuditLogStore().close();
        Assertions.assertThrows(RejectedExecutionException.class, () -> {
            workerStore.catchup();
            ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
        });
        workerStore.getAuditLogStore().close();
    }

    @Test
    void testRestartReplay(JdbcInfo jdbcInfo) throws Exception {
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assert.assertEquals((long)1L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        String unitId = RandomUtil.randomUUIDStr();
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("a", jdbcInfo, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("b", jdbcInfo, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("c", jdbcInfo, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(RandomUtil.randomUUIDStr(), "c", jdbcInfo, false, 1L, unitId);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("a", jdbcInfo, true);
        workerStore.catchup();
        Assert.assertEquals((long)3L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        workerStore.getAuditLogStore().pause();
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("d", jdbcInfo, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("e", jdbcInfo, false);
        workerStore.getAuditLogStore().reInit();
        Awaitility.await().atMost(6L, TimeUnit.SECONDS).until(() -> 5 == workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        workerStore.getAuditLogStore().close();
    }

    @Test
    void testQueryNodeAuditLogCatchup(JdbcInfo jdbcInfo) {
        KylinConfig kylinConfig = TestUtils.getTestConfig();
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig);
        resourceStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assertions.assertEquals((int)1, (int)resourceStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc", jdbcInfo, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc2", jdbcInfo, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc3", jdbcInfo, false);
        Assertions.assertEquals((long)0L, (long)resourceStore.getOffset());
        ((JdbcAuditLogStore)resourceStore.getAuditLogStore()).forceClose();
        KylinConfig queryConfig = KylinConfig.createKylinConfig((KylinConfig)kylinConfig);
        queryConfig.setProperty("kylin.server.mode", "query");
        queryConfig.setProperty("kylin.server.store-type", "jdbc");
        ResourceStore queryResourceStore = ResourceStore.getKylinMetaStore((KylinConfig)queryConfig);
        Assertions.assertEquals((long)3L, (long)queryResourceStore.getOffset());
        AuditLogStore auditLogStore = queryResourceStore.getAuditLogStore();
        AuditLogReplayWorker replayWorker = (AuditLogReplayWorker)ReflectionTestUtils.getField((Object)auditLogStore, (String)"replayWorker");
        Assertions.assertNotNull((Object)replayWorker);
        Assertions.assertEquals((long)0L, (long)replayWorker.getLogOffset());
        AuditLogReplayWorker mockWorker = (AuditLogReplayWorker)Mockito.spy((Object)replayWorker);
        ((AuditLogReplayWorker)Mockito.doNothing().when((Object)mockWorker)).catchupToMaxId(Mockito.anyLong());
        ReflectionTestUtils.setField((Object)auditLogStore, (String)"replayWorker", (Object)mockWorker);
        queryResourceStore.getMetadataStore().setAuditLogStore(auditLogStore);
        queryResourceStore.catchup();
        Assertions.assertEquals((long)3L, (long)((JdbcAuditLogStore)queryResourceStore.getMetadataStore().getAuditLogStore()).replayWorker.getLogOffset());
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc4", jdbcInfo, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry("abc5", jdbcInfo, false);
        ReflectionTestUtils.setField((Object)auditLogStore, (String)"replayWorker", (Object)replayWorker);
        queryResourceStore.getMetadataStore().setAuditLogStore(auditLogStore);
        queryResourceStore.catchup();
        queryResourceStore.catchup();
        Assertions.assertEquals((long)5L, (long)((JdbcAuditLogStore)queryResourceStore.getMetadataStore().getAuditLogStore()).replayWorker.getLogOffset());
        ((JdbcAuditLogStore)queryResourceStore.getAuditLogStore()).forceClose();
    }
}

