/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.Segments;
import org.apache.spark.sql.Column;
import org.sparkproject.guava.collect.Sets;

public class NSparkCubingUtil {
    public static final String SEPARATOR = "_0_DOT_0_";
    public static final String CC_SEPARATOR = "_0_DOT_CC_0_";
    public static final String SEPARATOR_TMP = "_0_DOT_TMP_0_";
    private static final Pattern DOT_PATTERN = Pattern.compile("\\b([\\w]+)\\.([\\w]+)\\b");
    private static final Pattern BACK_TICK_DOT_PATTERN = Pattern.compile("`[^\\f\\n\\r\\t\\v]+?`\\.`[^\\f\\n\\r\\t\\v]+?`");
    private static final Pattern UDF_FUNCTION_PATTERN = Pattern.compile("\\b([\\w`]+)\\.([\\w`]+)\\b([\\(]+)");
    private static final Pattern LETTER_PATTERN = Pattern.compile(".*[a-zA-Z]+.*");
    private static final Pattern FLOATING_POINT = Pattern.compile("\\b[0-9]+.[0-9]*E[0-9]+\\b");
    private static final char QUOTE = '\'';
    private static final String BACK_TICK = Quoting.BACK_TICK.string;

    private NSparkCubingUtil() {
    }

    public static String ids2Str(Set<? extends Number> ids) {
        return String.join((CharSequence)",", ids.stream().map(String::valueOf).collect(Collectors.toList()));
    }

    public static Set<Long> str2Longs(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return Collections.emptySet();
        }
        LinkedHashSet<Long> r = new LinkedHashSet<Long>();
        for (String id : str.split(",")) {
            r.add(Long.parseLong(id));
        }
        return r;
    }

    public static Set<String> toSegmentIds(Set<NDataSegment> segments) {
        LinkedHashSet<String> r = new LinkedHashSet<String>();
        for (NDataSegment seg : segments) {
            r.add(seg.getId());
        }
        return r;
    }

    public static Set<String> toIgnoredTableSet(String tableListStr) {
        if (StringUtils.isBlank((CharSequence)tableListStr)) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet s = Sets.newLinkedHashSet();
        s.addAll(Arrays.asList(StringSplitter.split((String)tableListStr, (String)",")));
        return s;
    }

    public static Set<String> toSegmentIds(Segments<NDataSegment> segments) {
        LinkedHashSet s = Sets.newLinkedHashSet();
        s.addAll(segments.stream().map(RootPersistentEntity::getId).collect(Collectors.toList()));
        return s;
    }

    static Set<String> toSegmentIds(String segmentsStr) {
        LinkedHashSet s = Sets.newLinkedHashSet();
        s.addAll(Arrays.asList(segmentsStr.split(",")));
        return s;
    }

    public static Set<Long> toLayoutIds(Set<LayoutEntity> layouts) {
        LinkedHashSet<Long> r = new LinkedHashSet<Long>();
        for (LayoutEntity layout : layouts) {
            r.add(layout.getId());
        }
        return r;
    }

    static Set<Long> toLayoutIds(String layoutIdStr) {
        LinkedHashSet s = Sets.newLinkedHashSet();
        s.addAll(Arrays.stream(layoutIdStr.split(",")).map(Long::parseLong).collect(Collectors.toList()));
        return s;
    }

    public static Set<LayoutEntity> toLayouts(IndexPlan indexPlan, Set<Long> layouts) {
        return layouts.stream().map(arg_0 -> ((IndexPlan)indexPlan).getLayoutEntity(arg_0)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @SafeVarargs
    public static Set<Integer> combineIndices(Set<Integer> ... items) {
        LinkedHashSet<Integer> combined = new LinkedHashSet<Integer>();
        for (Set<Integer> single : items) {
            combined.addAll(single);
        }
        return combined;
    }

    @SafeVarargs
    public static Column[] getColumns(Set<Integer> ... items) {
        Set<Integer> indices = NSparkCubingUtil.combineIndices(items);
        Column[] ret = new Column[indices.size()];
        int index = 0;
        for (Integer i : indices) {
            ret[index] = new Column(String.valueOf(i));
            ++index;
        }
        return ret;
    }

    public static String convertFromDot(String withDot) {
        int literalEnd;
        int literalBegin = withDot.indexOf(39);
        if (literalBegin != -1 && (literalEnd = withDot.indexOf(39, literalBegin + 1)) != -1) {
            return NSparkCubingUtil.doConvertFromDot(withDot.substring(0, literalBegin), false) + withDot.substring(literalBegin, literalEnd + 1) + NSparkCubingUtil.convertFromDot(withDot.substring(literalEnd + 1));
        }
        return NSparkCubingUtil.doConvertFromDot(withDot, false);
    }

    public static String convertFromDotWithBackTick(String withDot) {
        int literalEnd;
        int literalBegin = withDot.indexOf(39);
        if (literalBegin != -1 && (literalEnd = withDot.indexOf(39, literalBegin + 1)) != -1) {
            return NSparkCubingUtil.doConvertFromDot(withDot.substring(0, literalBegin), true) + withDot.substring(literalBegin, literalEnd + 1) + NSparkCubingUtil.convertFromDotWithBackTick(withDot.substring(literalEnd + 1));
        }
        return NSparkCubingUtil.doConvertFromDot(withDot, true);
    }

    private static String doConvertFromDot(String withDot, boolean addBackTick) {
        if (withDot.contains(BACK_TICK)) {
            return NSparkCubingUtil.convertBackTickExpr(withDot, addBackTick);
        }
        return NSparkCubingUtil.convertWithoutBackTickExpr(withDot, addBackTick);
    }

    private static String convertBackTickExpr(String withDot, boolean addBackTick) {
        String convertResult = withDot;
        Matcher m = BACK_TICK_DOT_PATTERN.matcher(withDot);
        while (m.find()) {
            String target = m.group();
            target = target.replace(BACK_TICK + "." + BACK_TICK, SEPARATOR);
            if (!addBackTick) {
                target = target.replace(BACK_TICK, "");
            }
            convertResult = StringUtils.replaceOnce((String)convertResult, (String)m.group(), (String)target);
        }
        return convertResult;
    }

    private static String convertWithoutBackTickExpr(String withDot, boolean addBackTick) {
        String withoutDot = NSparkCubingUtil.doConvertComputedColumnFromDot(withDot);
        Matcher m = DOT_PATTERN.matcher(withoutDot);
        while (m.find()) {
            String matched = m.group();
            if (LETTER_PATTERN.matcher(matched).find() && !NSparkCubingUtil.isFloatingPointNumber(matched)) {
                withoutDot = addBackTick ? m.replaceFirst(BACK_TICK + "$1" + SEPARATOR + "$2" + BACK_TICK) : m.replaceFirst("$1_0_DOT_0_$2");
                m = DOT_PATTERN.matcher(withoutDot);
                continue;
            }
            withoutDot = m.replaceFirst("$1_0_DOT_TMP_0_$2");
            m = DOT_PATTERN.matcher(withoutDot);
        }
        withoutDot = withoutDot.replace(SEPARATOR_TMP, ".");
        withoutDot = withoutDot.replace(CC_SEPARATOR, ".");
        if (addBackTick) {
            return withoutDot;
        }
        return withoutDot.replace("`", "");
    }

    private static String doConvertComputedColumnFromDot(String exp) {
        String withoutDot = exp;
        Matcher m = UDF_FUNCTION_PATTERN.matcher(exp);
        while (m.find()) {
            withoutDot = m.replaceFirst("$1_0_DOT_CC_0_$2(");
            m = UDF_FUNCTION_PATTERN.matcher(withoutDot);
        }
        return withoutDot;
    }

    public static boolean isFloatingPointNumber(String exp) {
        Matcher matcher = FLOATING_POINT.matcher(exp);
        if (!matcher.find()) {
            return false;
        }
        try {
            Double.parseDouble(matcher.group());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String convertToDot(String withoutDot) {
        return withoutDot.replace(SEPARATOR, ".");
    }
}

