/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage;

import io.delta.storage.CloseableIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;

public class LineCloseableIterator
implements CloseableIterator<String> {
    private final BufferedReader reader;
    private boolean gotNext = false;
    private String nextValue = null;
    private boolean closed = false;
    private boolean finished = false;

    public LineCloseableIterator(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.finished) {
                if (this.closed) {
                    throw new IllegalStateException("Iterator is closed");
                }
                if (!this.gotNext) {
                    String string = this.reader.readLine();
                    if (string == null) {
                        this.finished = true;
                        this.close();
                    } else {
                        this.nextValue = string.trim();
                    }
                    this.gotNext = true;
                }
            }
            return !this.finished;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("End of stream");
        }
        this.gotNext = false;
        return this.nextValue;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.reader.close();
        }
    }
}

