/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.proto;

import alluxio.grpc.SetAclAction;
import alluxio.proto.journal.File;
import alluxio.proto.shared.Acl;
import alluxio.proto.status.Status;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclActions;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.AclEntryType;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.security.authorization.ExtendedACLEntries;
import alluxio.shaded.client.com.google.protobuf.CodedInputStream;
import alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException;
import alluxio.shaded.client.io.grpc.Status;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ProtoUtils {
    private ProtoUtils() {
    }

    public static int readRawVarint32(int firstByte, InputStream input) throws IOException {
        return CodedInputStream.readRawVarint32(firstByte, input);
    }

    public static int readRawVarint32(InputStream input) throws IOException {
        int firstByte = input.read();
        return CodedInputStream.readRawVarint32(firstByte, input);
    }

    public static boolean isTruncatedMessageException(IOException e) {
        String truncatedMessage;
        if (!(e instanceof InvalidProtocolBufferException)) {
            return false;
        }
        try {
            Method method = InvalidProtocolBufferException.class.getMethod("truncatedMessage", new Class[0]);
            method.setAccessible(true);
            truncatedMessage = (String)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ee) {
            throw new RuntimeException(ee);
        }
        return e.getMessage().equals(truncatedMessage);
    }

    public static Acl.AccessControlList toProto(AccessControlList acl) {
        Acl.AccessControlList.Builder builder = Acl.AccessControlList.newBuilder();
        builder.setOwningUser(acl.getOwningUser());
        builder.setOwningGroup(acl.getOwningGroup());
        builder.addUserActions(Acl.NamedAclActions.newBuilder().setName("").setActions(ProtoUtils.toProto(acl.getOwningUserActions())).build());
        builder.addGroupActions(Acl.NamedAclActions.newBuilder().setName("").setActions(ProtoUtils.toProto(acl.getOwningGroupActions())).build());
        builder.setOtherActions(ProtoUtils.toProto(acl.getOtherActions()));
        if (acl.getExtendedEntries() != null) {
            builder.addAllUserActions(ProtoUtils.getNamedUsersProto(acl.getExtendedEntries()));
            builder.addAllGroupActions(ProtoUtils.getNamedGroupsProto(acl.getExtendedEntries()));
            builder.setMaskActions(ProtoUtils.toProto(acl.getExtendedEntries().getMask()));
        }
        if (acl instanceof DefaultAccessControlList) {
            DefaultAccessControlList defaultAcl = (DefaultAccessControlList)acl;
            builder.setIsDefault(true);
            builder.setIsEmpty(defaultAcl.isEmpty());
        } else {
            builder.setIsDefault(false);
            builder.setIsEmpty(false);
        }
        return builder.build();
    }

    public static Acl.AclActions toProto(AclActions actions) {
        Acl.AclActions.Builder builder = Acl.AclActions.newBuilder();
        for (AclAction action : actions.getActions()) {
            Acl.AclAction pAction = ProtoUtils.toProto(action);
            builder.addActions(pAction);
        }
        return builder.build();
    }

    public static Acl.AclAction toProto(AclAction aclAction) {
        switch (aclAction) {
            case READ: {
                return Acl.AclAction.READ;
            }
            case WRITE: {
                return Acl.AclAction.WRITE;
            }
            case EXECUTE: {
                return Acl.AclAction.EXECUTE;
            }
        }
        throw new IllegalStateException("Unknown acl action: " + (Object)((Object)aclAction));
    }

    public static Acl.AclEntry toProto(AclEntry aclEntry) {
        Acl.AclEntry.Builder builder = Acl.AclEntry.newBuilder();
        builder.setType(ProtoUtils.toProto(aclEntry.getType()));
        builder.setSubject(aclEntry.getSubject());
        builder.setIsDefault(aclEntry.isDefault());
        for (AclAction action : aclEntry.getActions().getActions()) {
            builder.addActions(ProtoUtils.toProto(action));
        }
        return builder.build();
    }

    public static File.PSetAclAction toProto(SetAclAction aclAction) {
        switch (aclAction) {
            case REPLACE: {
                return File.PSetAclAction.REPLACE;
            }
            case MODIFY: {
                return File.PSetAclAction.MODIFY;
            }
            case REMOVE: {
                return File.PSetAclAction.REMOVE;
            }
            case REMOVE_ALL: {
                return File.PSetAclAction.REMOVE_ALL;
            }
            case REMOVE_DEFAULT: {
                return File.PSetAclAction.REMOVE_DEFAULT;
            }
        }
        throw new IllegalStateException("Unrecognized set acl action: " + aclAction);
    }

    public static Status.PStatus toProto(Status status) {
        switch (status.getCode()) {
            case ABORTED: {
                return Status.PStatus.ABORTED;
            }
            case ALREADY_EXISTS: {
                return Status.PStatus.ALREADY_EXISTS;
            }
            case CANCELLED: {
                return Status.PStatus.CANCELED;
            }
            case DATA_LOSS: {
                return Status.PStatus.DATA_LOSS;
            }
            case DEADLINE_EXCEEDED: {
                return Status.PStatus.DEADLINE_EXCEEDED;
            }
            case FAILED_PRECONDITION: {
                return Status.PStatus.FAILED_PRECONDITION;
            }
            case INTERNAL: {
                return Status.PStatus.INTERNAL;
            }
            case INVALID_ARGUMENT: {
                return Status.PStatus.INVALID_ARGUMENT;
            }
            case NOT_FOUND: {
                return Status.PStatus.NOT_FOUND;
            }
            case OK: {
                return Status.PStatus.OK;
            }
            case OUT_OF_RANGE: {
                return Status.PStatus.OUT_OF_RANGE;
            }
            case PERMISSION_DENIED: {
                return Status.PStatus.PERMISSION_DENIED;
            }
            case RESOURCE_EXHAUSTED: {
                return Status.PStatus.RESOURCE_EXHAUSTED;
            }
            case UNAUTHENTICATED: {
                return Status.PStatus.UNAUTHENTICATED;
            }
            case UNAVAILABLE: {
                return Status.PStatus.UNAVAILABLE;
            }
            case UNIMPLEMENTED: {
                return Status.PStatus.UNIMPLEMENTED;
            }
            case UNKNOWN: {
                return Status.PStatus.UNKNOWN;
            }
        }
        return Status.PStatus.UNKNOWN;
    }

    public static Acl.AclEntryType toProto(AclEntryType entryType) {
        switch (entryType) {
            case OWNING_USER: {
                return Acl.AclEntryType.OWNER;
            }
            case NAMED_USER: {
                return Acl.AclEntryType.NAMED_USER;
            }
            case OWNING_GROUP: {
                return Acl.AclEntryType.OWNING_GROUP;
            }
            case NAMED_GROUP: {
                return Acl.AclEntryType.NAMED_GROUP;
            }
            case MASK: {
                return Acl.AclEntryType.MASK;
            }
            case OTHER: {
                return Acl.AclEntryType.OTHER;
            }
        }
        throw new IllegalStateException("Unknown AclEntryType: " + (Object)((Object)entryType));
    }

    public static AccessControlList fromProto(Acl.AccessControlList acl) {
        AclEntry entry;
        AclActions actions;
        AclEntry entry2;
        AclActions actions2;
        String name;
        AccessControlList ret = acl.hasIsDefault() && acl.getIsDefault() ? new DefaultAccessControlList() : new AccessControlList();
        ret.setOwningUser(acl.getOwningUser().intern());
        ret.setOwningGroup(acl.getOwningGroup().intern());
        if (acl.getIsEmpty()) {
            return ret;
        }
        boolean hasExtended = false;
        for (Acl.NamedAclActions namedActions : acl.getUserActionsList()) {
            name = namedActions.getName();
            actions2 = ProtoUtils.fromProto(namedActions.getActions());
            if (name.equals("")) {
                entry2 = new AclEntry.Builder().setType(AclEntryType.OWNING_USER).setSubject(acl.getOwningUser()).setActions(actions2).build();
            } else {
                hasExtended = true;
                entry2 = new AclEntry.Builder().setType(AclEntryType.NAMED_USER).setSubject(name).setActions(actions2).build();
            }
            ret.setEntry(entry2);
        }
        for (Acl.NamedAclActions namedActions : acl.getGroupActionsList()) {
            name = namedActions.getName();
            actions2 = ProtoUtils.fromProto(namedActions.getActions());
            if (name.equals("")) {
                entry2 = new AclEntry.Builder().setType(AclEntryType.OWNING_GROUP).setSubject(acl.getOwningGroup()).setActions(actions2).build();
            } else {
                hasExtended = true;
                entry2 = new AclEntry.Builder().setType(AclEntryType.NAMED_GROUP).setSubject(name).setActions(actions2).build();
            }
            ret.setEntry(entry2);
        }
        if (hasExtended) {
            actions = ProtoUtils.fromProto(acl.getMaskActions());
            entry = new AclEntry.Builder().setType(AclEntryType.MASK).setActions(actions).build();
            ret.setEntry(entry);
        }
        actions = ProtoUtils.fromProto(acl.getOtherActions());
        entry = new AclEntry.Builder().setType(AclEntryType.OTHER).setActions(actions).build();
        ret.setEntry(entry);
        return ret;
    }

    public static AclActions fromProto(Acl.AclActions actions) {
        AclActions ret = new AclActions();
        for (Acl.AclAction action : actions.getActionsList()) {
            ret.add(ProtoUtils.fromProto(action));
        }
        return ret;
    }

    public static AclAction fromProto(Acl.AclAction action) {
        switch (action) {
            case READ: {
                return AclAction.READ;
            }
            case WRITE: {
                return AclAction.WRITE;
            }
            case EXECUTE: {
                return AclAction.EXECUTE;
            }
        }
        throw new IllegalStateException("Unknown protobuf acl action: " + action);
    }

    public static AclEntry fromProto(Acl.AclEntry pEntry) {
        AclEntry.Builder builder = new AclEntry.Builder();
        builder.setType(ProtoUtils.fromProto(pEntry.getType()));
        builder.setSubject(pEntry.getSubject());
        builder.setIsDefault(pEntry.getIsDefault());
        for (Acl.AclAction pAction : pEntry.getActionsList()) {
            builder.addAction(ProtoUtils.fromProto(pAction));
        }
        return builder.build();
    }

    public static AclEntryType fromProto(Acl.AclEntryType pAclEntryType) {
        switch (pAclEntryType) {
            case OWNER: {
                return AclEntryType.OWNING_USER;
            }
            case NAMED_USER: {
                return AclEntryType.NAMED_USER;
            }
            case OWNING_GROUP: {
                return AclEntryType.OWNING_GROUP;
            }
            case NAMED_GROUP: {
                return AclEntryType.NAMED_GROUP;
            }
            case MASK: {
                return AclEntryType.MASK;
            }
            case OTHER: {
                return AclEntryType.OTHER;
            }
        }
        throw new IllegalStateException("Unknown proto AclEntryType: " + pAclEntryType);
    }

    public static SetAclAction fromProto(File.PSetAclAction pSetAclAction) {
        if (pSetAclAction == null) {
            throw new IllegalStateException("Null proto set acl action.");
        }
        switch (pSetAclAction) {
            case REPLACE: {
                return SetAclAction.REPLACE;
            }
            case MODIFY: {
                return SetAclAction.MODIFY;
            }
            case REMOVE: {
                return SetAclAction.REMOVE;
            }
            case REMOVE_ALL: {
                return SetAclAction.REMOVE_ALL;
            }
            case REMOVE_DEFAULT: {
                return SetAclAction.REMOVE_DEFAULT;
            }
        }
        throw new IllegalStateException("Unrecognized proto set acl action: " + pSetAclAction);
    }

    public static Status fromProto(Status.PStatus status) {
        switch (status) {
            case ABORTED: {
                return Status.ABORTED;
            }
            case ALREADY_EXISTS: {
                return Status.ALREADY_EXISTS;
            }
            case CANCELED: {
                return Status.CANCELLED;
            }
            case DATA_LOSS: {
                return Status.DATA_LOSS;
            }
            case DEADLINE_EXCEEDED: {
                return Status.DEADLINE_EXCEEDED;
            }
            case FAILED_PRECONDITION: {
                return Status.FAILED_PRECONDITION;
            }
            case INTERNAL: {
                return Status.INTERNAL;
            }
            case INVALID_ARGUMENT: {
                return Status.INVALID_ARGUMENT;
            }
            case NOT_FOUND: {
                return Status.NOT_FOUND;
            }
            case OK: {
                return Status.OK;
            }
            case OUT_OF_RANGE: {
                return Status.OUT_OF_RANGE;
            }
            case PERMISSION_DENIED: {
                return Status.PERMISSION_DENIED;
            }
            case RESOURCE_EXHAUSTED: {
                return Status.RESOURCE_EXHAUSTED;
            }
            case UNAUTHENTICATED: {
                return Status.UNAUTHENTICATED;
            }
            case UNAVAILABLE: {
                return Status.UNAVAILABLE;
            }
            case UNIMPLEMENTED: {
                return Status.UNIMPLEMENTED;
            }
            case UNKNOWN: {
                return Status.UNKNOWN;
            }
        }
        return Status.UNKNOWN;
    }

    public static List<Acl.NamedAclActions> getNamedUsersProto(ExtendedACLEntries entries) {
        ArrayList<Acl.NamedAclActions> actions = new ArrayList<Acl.NamedAclActions>(entries.getNamedUserActions().size());
        for (Map.Entry<String, AclActions> kv : entries.getNamedUserActions().entrySet()) {
            Acl.NamedAclActions namedActions = Acl.NamedAclActions.newBuilder().setName(kv.getKey()).setActions(ProtoUtils.toProto(kv.getValue())).build();
            actions.add(namedActions);
        }
        return actions;
    }

    public static List<Acl.NamedAclActions> getNamedGroupsProto(ExtendedACLEntries entries) {
        ArrayList<Acl.NamedAclActions> actions = new ArrayList<Acl.NamedAclActions>(entries.getNamedGroupActions().size());
        for (Map.Entry<String, AclActions> kv : entries.getNamedGroupActions().entrySet()) {
            Acl.NamedAclActions namedActions = Acl.NamedAclActions.newBuilder().setName(kv.getKey()).setActions(ProtoUtils.toProto(kv.getValue())).build();
            actions.add(namedActions);
        }
        return actions;
    }
}

