/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.transaction;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;

public class UnitOfWorkContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnitOfWorkContext.class);
    private final String project;
    private KylinConfig.SetAndUnsetThreadLocalConfig localConfig;
    private Set<String> copyForWriteItems = new HashSet<String>();
    private Set<String> readLockPath = new HashSet<String>();
    private TransactionStatus transactionStatus = null;
    private UnitOfWorkParams params;
    List<UnitTask> onFinishedTasks = Lists.newArrayList();
    List<UnitTask> onUpdatedTasks = Lists.newArrayList();
    List<UnitTask> onStartUpdateTasks = Lists.newArrayList();

    public void doAfterUnit(UnitTask task) {
        this.onFinishedTasks.add(task);
    }

    public void doAfterUpdate(UnitTask task) {
        this.onUpdatedTasks.add(task);
    }

    KylinConfig getOriginConfig() {
        return this.localConfig.getOriginConfig();
    }

    public void doBeforeUpdate(UnitTask task) {
        this.onStartUpdateTasks.add(task);
    }

    void cleanResource() {
        if (this.localConfig == null) {
            return;
        }
        KylinConfig config = this.localConfig.get();
        ResourceStore.clearCache(config);
        this.localConfig.close();
        this.localConfig = null;
    }

    void checkReentrant(UnitOfWorkParams params) {
        Preconditions.checkState((this.project.equals(params.getUnitName()) || this.params.isAll() ? 1 : 0) != 0, (String)"re-entry of UnitOfWork with different unit name? existing: %s, new: %s", (Object)this.project, (Object)params.getUnitName());
        Preconditions.checkState((params.isReadonly() == this.isReadonly() ? 1 : 0) != 0, (String)"re-entry of UnitOfWork with different lock type? existing: %s, new: %s", (Object)this.isReadonly(), (Object)params.isReadonly());
        Preconditions.checkState((params.isUseSandbox() == this.isUseSandbox() ? 1 : 0) != 0, (String)"re-entry of UnitOfWork with different sandbox? existing: %s, new: %s", (Object)this.isReadonly(), (Object)params.isUseSandbox());
    }

    public void onUnitFinished() {
        this.onFinishedTasks.forEach(task -> {
            try {
                task.run();
            }
            catch (Exception e) {
                log.warn("Failed to run task after unit", (Throwable)e);
            }
        });
    }

    public void onUnitUpdated() {
        this.onUpdatedTasks.forEach(task -> {
            try {
                task.run();
            }
            catch (Exception e) {
                log.warn("Failed to run task after update metadata", (Throwable)e);
                if (e instanceof KylinException) {
                    throw (KylinException)e;
                }
                throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, "task failed");
            }
        });
    }

    public void onStartUnitUpdate() throws Exception {
        for (UnitTask task : this.onStartUpdateTasks) {
            task.run();
        }
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public KylinConfig.SetAndUnsetThreadLocalConfig getLocalConfig() {
        return this.localConfig;
    }

    @Generated
    public Set<String> getCopyForWriteItems() {
        return this.copyForWriteItems;
    }

    @Generated
    public Set<String> getReadLockPath() {
        return this.readLockPath;
    }

    @Generated
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @Generated
    public UnitOfWorkParams getParams() {
        return this.params;
    }

    @Generated
    public List<UnitTask> getOnFinishedTasks() {
        return this.onFinishedTasks;
    }

    @Generated
    public List<UnitTask> getOnUpdatedTasks() {
        return this.onUpdatedTasks;
    }

    @Generated
    public List<UnitTask> getOnStartUpdateTasks() {
        return this.onStartUpdateTasks;
    }

    @Generated
    public void setLocalConfig(KylinConfig.SetAndUnsetThreadLocalConfig localConfig) {
        this.localConfig = localConfig;
    }

    @Generated
    public void setCopyForWriteItems(Set<String> copyForWriteItems) {
        this.copyForWriteItems = copyForWriteItems;
    }

    @Generated
    public void setReadLockPath(Set<String> readLockPath) {
        this.readLockPath = readLockPath;
    }

    @Generated
    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    @Generated
    public void setParams(UnitOfWorkParams params) {
        this.params = params;
    }

    @Generated
    public void setOnFinishedTasks(List<UnitTask> onFinishedTasks) {
        this.onFinishedTasks = onFinishedTasks;
    }

    @Generated
    public void setOnUpdatedTasks(List<UnitTask> onUpdatedTasks) {
        this.onUpdatedTasks = onUpdatedTasks;
    }

    @Generated
    public void setOnStartUpdateTasks(List<UnitTask> onStartUpdateTasks) {
        this.onStartUpdateTasks = onStartUpdateTasks;
    }

    @Generated
    public UnitOfWorkContext(String project) {
        this.project = project;
    }

    @Generated
    public UnitOfWork.Callback getProcessor() {
        return this.getParams().getProcessor();
    }

    @Generated
    public UnitOfWork.Callback getEpochChecker() {
        return this.getParams().getEpochChecker();
    }

    @Generated
    public Consumer getWriteInterceptor() {
        return this.getParams().getWriteInterceptor();
    }

    @Generated
    public UnitOfWorkParams.UnitRetryContext getRetryContext() {
        return this.getParams().getRetryContext();
    }

    @Generated
    public long getRetryUntil() {
        return this.getParams().getRetryUntil();
    }

    @Generated
    public boolean isAll() {
        return this.getParams().isAll();
    }

    @Generated
    public String getUnitName() {
        return this.getParams().getUnitName();
    }

    @Generated
    public String getProjectId() {
        return this.getParams().getProjectId();
    }

    @Generated
    public long getEpochId() {
        return this.getParams().getEpochId();
    }

    @Generated
    public int getMaxRetry() {
        return this.getParams().getMaxRetry();
    }

    @Generated
    public boolean isReadonly() {
        return this.getParams().isReadonly();
    }

    @Generated
    public boolean isUseSandbox() {
        return this.getParams().isUseSandbox();
    }

    @Generated
    public boolean isSkipAuditLog() {
        return this.getParams().isSkipAuditLog();
    }

    @Generated
    public boolean isSkipReplay() {
        return this.getParams().isSkipReplay();
    }

    @Generated
    public String getTempLockName() {
        return this.getParams().getTempLockName();
    }

    @Generated
    public boolean isUseProjectLock() {
        return this.getParams().isUseProjectLock();
    }

    @Generated
    public boolean isRetryMoreTimeForDeadLockException() {
        return this.getParams().isRetryMoreTimeForDeadLockException();
    }

    @Generated
    public long getSleepMills() {
        return this.getParams().getSleepMills();
    }

    @Generated
    public void setProcessor(UnitOfWork.Callback processor) {
        this.getParams().setProcessor(processor);
    }

    @Generated
    public void setEpochChecker(UnitOfWork.Callback epochChecker) {
        this.getParams().setEpochChecker(epochChecker);
    }

    @Generated
    public void setWriteInterceptor(Consumer writeInterceptor) {
        this.getParams().setWriteInterceptor(writeInterceptor);
    }

    @Generated
    public void setRetryContext(UnitOfWorkParams.UnitRetryContext retryContext) {
        this.getParams().setRetryContext(retryContext);
    }

    @Generated
    public void setRetryUntil(long retryUntil) {
        this.getParams().setRetryUntil(retryUntil);
    }

    @Generated
    public void setAll(boolean all) {
        this.getParams().setAll(all);
    }

    @Generated
    public void setUnitName(String unitName) {
        this.getParams().setUnitName(unitName);
    }

    @Generated
    public void setProjectId(String projectId) {
        this.getParams().setProjectId(projectId);
    }

    @Generated
    public void setEpochId(long epochId) {
        this.getParams().setEpochId(epochId);
    }

    @Generated
    public void setMaxRetry(int maxRetry) {
        this.getParams().setMaxRetry(maxRetry);
    }

    @Generated
    public void setReadonly(boolean readonly) {
        this.getParams().setReadonly(readonly);
    }

    @Generated
    public void setUseSandbox(boolean useSandbox) {
        this.getParams().setUseSandbox(useSandbox);
    }

    @Generated
    public void setSkipAuditLog(boolean skipAuditLog) {
        this.getParams().setSkipAuditLog(skipAuditLog);
    }

    @Generated
    public void setSkipReplay(boolean skipReplay) {
        this.getParams().setSkipReplay(skipReplay);
    }

    @Generated
    public void setTempLockName(String tempLockName) {
        this.getParams().setTempLockName(tempLockName);
    }

    @Generated
    public void setUseProjectLock(boolean useProjectLock) {
        this.getParams().setUseProjectLock(useProjectLock);
    }

    @Generated
    public void setRetryMoreTimeForDeadLockException(boolean retryMoreTimeForDeadLockException) {
        this.getParams().setRetryMoreTimeForDeadLockException(retryMoreTimeForDeadLockException);
    }

    @Generated
    public void setSleepMills(long sleepMills) {
        this.getParams().setSleepMills(sleepMills);
    }

    public static interface UnitTask {
        public void run() throws Exception;
    }
}

