/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.merger;

import java.io.IOException;
import lombok.Generated;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.engine.spark.merger.MetadataMerger;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterLoadingInternalTableMerger
extends MetadataMerger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AfterLoadingInternalTableMerger.class);

    public AfterLoadingInternalTableMerger(KylinConfig config, String project) {
        super(config, project);
    }

    public void mergeRemoteMetaAfterLoadingInternalTable(String outputMetaUrl, String tableIdentity) {
        try (ResourceStore remoteStore = ExecutableUtils.getRemoteStore((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)outputMetaUrl);){
            String project = this.getProject();
            InternalTableManager remoteInternalTblMgr = InternalTableManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)project);
            InternalTableDesc remoteInternalTbDesc = remoteInternalTblMgr.getInternalTableDesc(tableIdentity);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            long storageSize = 0L;
            try {
                storageSize = HadoopUtil.getContentSummary((FileSystem)fs, (Path)new Path(remoteInternalTbDesc.getLocation())).getLength();
            }
            catch (IOException e) {
                log.warn("Fetch internal table size for {} from {} failed", (Object)remoteInternalTbDesc.getIdentity(), (Object)remoteInternalTbDesc.getLocation());
            }
            remoteInternalTbDesc.setStorageSize(storageSize);
            this.mergeRemoteMetaAfterLoadingInternalTable(remoteInternalTbDesc, tableIdentity);
        }
    }

    private void mergeRemoteMetaAfterLoadingInternalTable(InternalTableDesc remoteInternalTableDesc, String tableIdentity) {
        String project = this.getProject();
        InternalTableManager localInternalTblMgr = InternalTableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        InternalTableDesc localInternalTbDesc = localInternalTblMgr.getInternalTableDesc(tableIdentity);
        InternalTableDesc copy = localInternalTblMgr.copyForWrite(localInternalTbDesc);
        copy.setStorageSize(remoteInternalTableDesc.getStorageSize());
        copy.setRowCount(remoteInternalTableDesc.getRowCount());
        copy.setTablePartition(remoteInternalTableDesc.getTablePartition());
        localInternalTblMgr.saveOrUpdateInternalTable(copy);
    }

    @Override
    public <T> T merge(MergerInfo.TaskMergeInfo info) {
        this.mergeRemoteMetaAfterLoadingInternalTable(info.getOutputMetaUrl(), info.getTableIdentity());
        return null;
    }
}

