/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Collections;
import lombok.Generated;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.engine.spark.job.LoadCacheStep;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.utils.GlutenCacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalTableLoadCacheStep
extends LoadCacheStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalTableLoadCacheStep.class);

    public InternalTableLoadCacheStep() {
    }

    public InternalTableLoadCacheStep(Object notSetId) {
        super(notSetId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecuteResult doWork(JobContext context) throws ExecuteException {
        try (SetLogCategory ignore = new SetLogCategory("build");){
            String table = this.getParam("table");
            String start = this.getParam("startTime");
            String cacheTableCommand = GlutenCacheUtils.generateCacheTableCommand(this.getConfig(), this.getProject(), table, start, Collections.emptyList(), false);
            log.info("InternalTable[{}] cache command is [{}]", (Object)table, (Object)cacheTableCommand);
            this.routeCacheToAllQueryNode(this.getProject(), Sets.newHashSet((Object[])new String[]{cacheTableCommand}));
            ExecuteResult executeResult = ExecuteResult.createSucceed();
            return executeResult;
        }
        catch (Throwable throwable6) {
            log.warn("InternalTableLoadCache routeCacheToAllQueryNode failed.", throwable6);
            return ExecuteResult.createError((Throwable)throwable6);
        }
    }
}

