/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.cluster.ClusterManagerFactory;
import org.apache.kylin.cluster.IClusterManager;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.job.ISparkJobHandler;
import org.apache.kylin.engine.spark.job.SparkAppDescription;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.util.concurrent.UncheckedTimeoutException;
import org.apache.kylin.job.exception.ExecuteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSparkBuildJobHandler
implements ISparkJobHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSparkBuildJobHandler.class);
    private static final String SPACE = " ";
    private static final String SUBMIT_LINE_FORMAT = " \\\n";
    private static final String SPARK_JARS_1 = "spark.jars";
    private static final String SPARK_JARS_2 = "spark.yarn.dist.jars";
    private static final String SPARK_FILES_1 = "spark.files";
    private static final String SPARK_FILES_2 = "spark.yarn.dist.files";
    private static final String EQUALS = "=";

    public void killOrphanApplicationIfExists(String project, String jobStepId, KylinConfig config, Boolean isSubmitting, Map<String, String> sparkConf) {
        try {
            String sparkMaster = sparkConf.getOrDefault("spark.master", "local");
            if (sparkMaster.startsWith("local")) {
                logger.info("Skip kill orphan app for spark.master={}", (Object)sparkMaster);
                return;
            }
            IClusterManager cm = ClusterManagerFactory.create(config);
            cm.killApplication(jobStepId);
        }
        catch (UncheckedTimeoutException e) {
            logger.warn("Kill orphan app timeout {}", (Object)e.getMessage());
        }
    }

    public void checkApplicationJar(KylinConfig config) throws ExecuteException {
        try {
            String path = config.getKylinJobJarPath();
            String failedMsg = "Application jar should be only one bundled jar.";
            URI uri = new URI(path);
            if (Objects.isNull(uri.getScheme()) || uri.getScheme().startsWith("file:/")) {
                Preconditions.checkState((boolean)new File(path).exists(), (Object)"Application jar should be only one bundled jar.");
                return;
            }
            Path path0 = new Path(path);
            FileSystem fs = HadoopUtil.getFileSystem((Path)path0);
            Preconditions.checkState((boolean)fs.exists(path0), (Object)"Application jar should be only one bundled jar.");
        }
        catch (IOException | URISyntaxException e) {
            throw new ExecuteException("Failed to check application jar.", (Throwable)e);
        }
    }

    public String createArgsFileOnRemoteFileSystem(KylinConfig config, String project, String jobId, Map<String, String> params) throws ExecuteException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        Path path = fs.makeQualified(new Path(config.getJobTmpArgsDir(project, jobId)));
        try (FSDataOutputStream out = fs.create(path);){
            out.write(JsonUtil.writeValueAsBytes(params));
        }
        catch (IOException e) {
            try {
                fs.delete(path, true);
            }
            catch (IOException e1) {
                throw new ExecuteException("Write spark args failed! Error for delete file: " + path.toString(), (Throwable)e1);
            }
            throw new ExecuteException("Write spark args failed: ", (Throwable)e);
        }
        return path.toString();
    }

    public Object generateSparkCmd(KylinConfig config, SparkAppDescription desc) {
        StringBuilder cmdBuilder = new StringBuilder("export HADOOP_CONF_DIR=");
        cmdBuilder.append(desc.getHadoopConfDir());
        cmdBuilder.append(SPACE).append("&&");
        cmdBuilder.append(SPACE).append(KylinConfigBase.getSparkHome()).append(File.separator);
        cmdBuilder.append("bin/spark-submit");
        cmdBuilder.append(SUBMIT_LINE_FORMAT);
        cmdBuilder.append(SPACE).append("--class");
        cmdBuilder.append(SPACE).append("org.apache.kylin.engine.spark.application.SparkEntry");
        cmdBuilder.append(SUBMIT_LINE_FORMAT);
        cmdBuilder.append(SPACE).append("--name");
        cmdBuilder.append(SPACE).append(desc.getJobNamePrefix()).append(desc.getJobId());
        cmdBuilder.append(SUBMIT_LINE_FORMAT);
        cmdBuilder.append(SPACE).append("--jars");
        cmdBuilder.append(SPACE).append(String.join((CharSequence)desc.getComma(), desc.getSparkJars()));
        cmdBuilder.append(SUBMIT_LINE_FORMAT);
        cmdBuilder.append(SPACE).append("--files");
        cmdBuilder.append(SPACE).append(String.join((CharSequence)desc.getComma(), desc.getSparkFiles()));
        cmdBuilder.append(SUBMIT_LINE_FORMAT);
        this.wrapSparkConf(cmdBuilder, desc.getSparkConf());
        cmdBuilder.append(SPACE).append(desc.getKylinJobJar());
        cmdBuilder.append(SUBMIT_LINE_FORMAT);
        cmdBuilder.append(SPACE).append(desc.getAppArgs());
        String command = cmdBuilder.toString();
        logger.info("spark submit cmd: {}", (Object)command);
        this.checkCommandInjection(command);
        return command;
    }

    private void checkCommandInjection(String command) {
        if (Objects.isNull(command)) {
            return;
        }
        ArrayList illegals = Lists.newArrayList();
        Matcher matcher = Pattern.compile("(`[^`]*+`)|(\\$\\([^)]*+)").matcher(command);
        while (matcher.find()) {
            illegals.add(matcher.group());
        }
        if (illegals.isEmpty()) {
            return;
        }
        String msg = String.format(Locale.ROOT, "Not allowed to specify injected command through java options (like: %s). Vulnerabilities would allow attackers to trigger such a crash or crippling of the service.", String.join((CharSequence)", ", illegals));
        throw new IllegalArgumentException(msg);
    }

    private void wrapSparkConf(StringBuilder cmdBuilder, Map<String, String> sparkConf) {
        block9: for (Map.Entry<String, String> entry : sparkConf.entrySet()) {
            switch (entry.getKey()) {
                case "spark.jars": 
                case "spark.yarn.dist.jars": 
                case "spark.files": 
                case "spark.yarn.dist.files": {
                    continue block9;
                }
            }
            this.appendSparkConf(cmdBuilder, entry.getKey(), entry.getValue());
        }
    }

    protected void appendSparkConf(StringBuilder sb, String confKey, String confValue) {
        sb.append(" --conf '").append(confKey).append(EQUALS).append(confValue).append("' ");
        sb.append(SUBMIT_LINE_FORMAT);
    }

    public Map<String, String> runSparkSubmit(Object cmd, String parentId) throws ExecuteException {
        HashMap updateInfo = Maps.newHashMap();
        try {
            BufferedLogger patternedLogger = new BufferedLogger(logger);
            CliCommandExecutor exec = new CliCommandExecutor();
            CliCommandExecutor.CliCmdExecResult r = exec.execute((String)cmd, (org.apache.kylin.common.util.Logger)patternedLogger, parentId);
            if (StringUtils.isNotEmpty((CharSequence)r.getProcessId())) {
                updateInfo.put("process_id", r.getProcessId());
            }
            updateInfo.put("output", r.getCmd());
            return updateInfo;
        }
        catch (Exception e) {
            logger.warn("failed to execute spark submit command.");
            throw new ExecuteException((Throwable)e);
        }
    }
}

