/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.handler;

import lombok.Generated;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.AbstractJobHandler;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;

public class InternalTableJobHandler
extends AbstractJobHandler {
    @Override
    protected AbstractExecutable createJob(JobParam jobParam) {
        return JobFactory.createJob("INTERNAL_TABLE_JOB_FACTORY", new InternalTableJobBuildParam(jobParam));
    }

    @Override
    protected void checkBeforeHandle(JobParam jobParam) {
        String project = jobParam.getProject();
        JobManager.checkStorageQuota(project);
    }

    public static class InternalTableJobBuildParam
    extends JobFactory.JobBuildParams {
        private String project;
        private String table;
        private String incrementalBuild;
        private String isRefresh;
        private String startDate;
        private String endDate;
        private String deletePartitionValues;
        private String deletePartition;

        public InternalTableJobBuildParam(JobParam jobParam) {
            super(null, null, jobParam.getOwner(), jobParam.getJobTypeEnum(), jobParam.getJobId(), null, null, null, null, jobParam.getExtParams());
            this.project = jobParam.getProject();
            this.table = jobParam.getTable();
            this.incrementalBuild = jobParam.getExtParams().get("incrementalBuild");
            this.isRefresh = jobParam.getExtParams().get("outputMode");
            this.startDate = jobParam.getExtParams().get("startTime");
            this.endDate = jobParam.getExtParams().get("endTime");
            this.deletePartitionValues = jobParam.getExtParams().get("deletePartitionValues");
            this.deletePartition = jobParam.getExtParams().get("deletePartition");
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public String getTable() {
            return this.table;
        }

        @Generated
        public String getIncrementalBuild() {
            return this.incrementalBuild;
        }

        @Generated
        public String getIsRefresh() {
            return this.isRefresh;
        }

        @Generated
        public String getStartDate() {
            return this.startDate;
        }

        @Generated
        public String getEndDate() {
            return this.endDate;
        }

        @Generated
        public String getDeletePartitionValues() {
            return this.deletePartitionValues;
        }

        @Generated
        public String getDeletePartition() {
            return this.deletePartition;
        }
    }
}

