/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.org.influxdb.impl;

import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public enum TimeUtil {
    INSTANCE;

    private static final ThreadLocal<SimpleDateFormat> FORMATTER_MILLIS;
    private static final ThreadLocal<SimpleDateFormat> FORMATTER_SECONDS;
    private static final EnumSet<TimeUnit> ALLOWED_TIMEUNITS;
    public static final int TIME_IN_SECOND_LENGTH = 20;

    public static String toTimePrecision(TimeUnit t) {
        switch (t) {
            case HOURS: {
                return "h";
            }
            case MINUTES: {
                return "m";
            }
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MICROSECONDS: {
                return "u";
            }
            case NANOSECONDS: {
                return "n";
            }
        }
        throw new IllegalArgumentException("time precision must be one of:" + ALLOWED_TIMEUNITS);
    }

    public static String toInfluxDBTimeFormat(long time) {
        return FORMATTER_MILLIS.get().format(time);
    }

    public static long fromInfluxDBTimeFormat(String time) {
        try {
            if (time.length() == 20) {
                return FORMATTER_SECONDS.get().parse(time).getTime();
            }
            return FORMATTER_MILLIS.get().parse(time).getTime();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected date format", e);
        }
    }

    static {
        FORMATTER_MILLIS = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat dateDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                dateDF.setTimeZone(TimeZone.getTimeZone("UTC"));
                return dateDF;
            }
        };
        FORMATTER_SECONDS = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat dateDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                dateDF.setTimeZone(TimeZone.getTimeZone("UTC"));
                return dateDF;
            }
        };
        ALLOWED_TIMEUNITS = EnumSet.of(TimeUnit.HOURS, new TimeUnit[]{TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS});
    }
}

