/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.model.SelectRule;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.model.FusionModel;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.request.AggShardByColumnsRequest;
import org.apache.kylin.rest.request.CreateTableIndexRequest;
import org.apache.kylin.rest.request.OpenUpdateRuleBasedCuboidRequest;
import org.apache.kylin.rest.request.UpdateRuleBasedCuboidRequest;
import org.apache.kylin.rest.response.AggIndexResponse;
import org.apache.kylin.rest.response.BuildIndexResponse;
import org.apache.kylin.rest.response.DiffRuleBasedIndexResponse;
import org.apache.kylin.rest.response.IndexResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.IndexPlanService;
import org.apache.kylin.rest.service.params.IndexPlanParams;
import org.apache.kylin.rest.service.params.PaginationParams;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fusionIndexService")
public class FusionIndexService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FusionIndexService.class);
    private static final List<JobStatusEnum> runningStatus = Arrays.asList(JobStatusEnum.STARTING, JobStatusEnum.RUNNING, JobStatusEnum.STOPPING);
    private static final String COUNT_ALL_MEASURE = "COUNT_ALL";
    @Autowired
    private IndexPlanService indexPlanService;

    public Pair<IndexPlan, BuildIndexResponse> updateRuleBasedCuboid(String project, UpdateRuleBasedCuboidRequest request) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(request.getModelId());
        if (model.fusionModelStreamingPart()) {
            UpdateRuleBasedCuboidRequest batchRequest = this.convertBatchUpdateRuleReq(request);
            UpdateRuleBasedCuboidRequest streamingRequest = this.convertStreamUpdateRuleReq(request);
            this.indexPlanService.updateRuleBasedCuboid(project, batchRequest);
            return this.indexPlanService.updateRuleBasedCuboid(project, streamingRequest);
        }
        return this.indexPlanService.updateRuleBasedCuboid(project, request);
    }

    public RuleBasedIndex getRule(String project, String modelId) {
        FusionModel fusionModel;
        String batchId;
        RuleBasedIndex batchRule;
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        RuleBasedIndex modelRule = this.indexPlanService.getRule(project, modelId);
        RuleBasedIndex newRuleBasedIndex = new RuleBasedIndex();
        if (!FusionIndexService.checkUpdateIndexEnabled(project, modelId)) {
            newRuleBasedIndex.setIndexUpdateEnabled(false);
        }
        if (modelRule != null) {
            newRuleBasedIndex.getAggregationGroups().addAll(modelRule.getAggregationGroups());
            newRuleBasedIndex.setGlobalDimCap(Integer.valueOf(modelRule.getGlobalDimCap()));
        }
        if (model.fusionModelStreamingPart() && (batchRule = this.indexPlanService.getRule(project, batchId = (fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, project)).getFusionModel(modelId)).getBatchModel().getUuid())) != null) {
            newRuleBasedIndex.getAggregationGroups().addAll(batchRule.getAggregationGroups().stream().filter(agg -> agg.getIndexRange() == IndexEntity.Range.BATCH).collect(Collectors.toList()));
            newRuleBasedIndex.setGlobalDimCap(Integer.valueOf(this.lastModifiedTimeGlobalDimCap(batchRule, modelRule)));
        }
        return newRuleBasedIndex;
    }

    private int lastModifiedTimeGlobalDimCap(RuleBasedIndex batchRule, RuleBasedIndex modelRule) {
        if (modelRule == null || modelRule.getLastModifiedTime() < batchRule.getLastModifiedTime()) {
            return batchRule.getGlobalDimCap();
        }
        return modelRule.getGlobalDimCap();
    }

    @Transaction(project=0)
    public BuildIndexResponse createTableIndex(String project, CreateTableIndexRequest request) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(request.getModelId());
        FusionIndexService.checkStreamingIndexEnabled(project, model);
        if (model.fusionModelStreamingPart()) {
            if (!FusionIndexService.indexChangeEnable(project, request.getModelId(), request.getIndexRange(), Lists.newArrayList((Object[])new IndexEntity.Range[]{IndexEntity.Range.HYBRID, IndexEntity.Range.STREAMING}))) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.STREAMING_INDEX_UPDATE_DISABLE, String.format(Locale.ROOT, MsgPicker.getMsg().getStreamingIndexesAdd(), new Object[0]));
            }
            FusionModel fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, project)).getFusionModel(request.getModelId());
            String batchId = fusionModel.getBatchModel().getUuid();
            CreateTableIndexRequest copy = this.convertTableIndexRequest(request, model, batchId);
            if (IndexEntity.Range.BATCH == request.getIndexRange()) {
                return this.indexPlanService.createTableIndex(project, copy);
            }
            if (IndexEntity.Range.HYBRID == request.getIndexRange()) {
                NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
                IndexPlan streamingIndexPlan = indexPlanManager.getIndexPlan(request.getModelId());
                IndexPlan batchIndexPlan = indexPlanManager.getIndexPlan(batchId);
                long maxId = Math.max(streamingIndexPlan.getNextTableIndexId(), batchIndexPlan.getNextTableIndexId());
                this.indexPlanService.createTableIndex(project, copy, maxId + 1L);
                return this.indexPlanService.createTableIndex(project, request, maxId + 1L);
            }
        }
        return this.indexPlanService.createTableIndex(project, request);
    }

    private CreateTableIndexRequest convertTableIndexRequest(CreateTableIndexRequest request, NDataModel model, String batchId) {
        CreateTableIndexRequest copy = (CreateTableIndexRequest)JsonUtil.deepCopyQuietly((Object)request, CreateTableIndexRequest.class);
        copy.setModelId(batchId);
        String tableAlias = ((NDataModelManager)this.getManager(NDataModelManager.class, model.getProject())).getDataModelDesc(batchId).getRootFactTableRef().getTableName();
        String oldAliasName = model.getRootFactTableRef().getTableName();
        this.convertTableIndex(copy, tableAlias, oldAliasName);
        return copy;
    }

    private void convertTableIndex(CreateTableIndexRequest copy, String tableName, String oldAliasName) {
        copy.setColOrder(copy.getColOrder().stream().map(x -> this.changeTableAlias((String)x, oldAliasName, tableName)).collect(Collectors.toList()));
        copy.setShardByColumns(copy.getShardByColumns().stream().map(x -> this.changeTableAlias((String)x, oldAliasName, tableName)).collect(Collectors.toList()));
        copy.setSortByColumns(copy.getSortByColumns().stream().map(x -> this.changeTableAlias((String)x, oldAliasName, tableName)).collect(Collectors.toList()));
    }

    private String changeTableAlias(String col, String oldAlias, String newAlias) {
        String table = col.split("\\.")[0];
        String column = col.split("\\.")[1];
        if (table.equalsIgnoreCase(oldAlias)) {
            return newAlias + "." + column;
        }
        return col;
    }

    @Transaction(project=0)
    public BuildIndexResponse updateTableIndex(String project, CreateTableIndexRequest request) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(request.getModelId());
        FusionIndexService.checkStreamingIndexEnabled(project, model);
        if (model.fusionModelStreamingPart()) {
            if (!FusionIndexService.indexChangeEnable(project, request.getModelId(), request.getIndexRange(), Lists.newArrayList((Object[])new IndexEntity.Range[]{IndexEntity.Range.HYBRID, IndexEntity.Range.STREAMING}))) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.STREAMING_INDEX_UPDATE_DISABLE, String.format(Locale.ROOT, MsgPicker.getMsg().getStreamingIndexesEdit(), new Object[0]));
            }
            FusionModel fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, project)).getFusionModel(request.getModelId());
            String batchId = fusionModel.getBatchModel().getUuid();
            CreateTableIndexRequest copy = this.convertTableIndexRequest(request, model, batchId);
            if (IndexEntity.Range.BATCH == request.getIndexRange()) {
                copy.setModelId(batchId);
                return this.indexPlanService.updateTableIndex(project, copy);
            }
            if (IndexEntity.Range.HYBRID == request.getIndexRange()) {
                this.indexPlanService.updateTableIndex(project, copy);
            }
        }
        return this.indexPlanService.updateTableIndex(project, request);
    }

    public List<IndexResponse> getIndexes(String project, String modelId, String key, List<IndexEntity.Status> status, String orderBy, Boolean desc, List<IndexEntity.Source> sources, List<Long> ids, List<IndexEntity.Range> range) {
        return this.getIndexes(new IndexPlanParams(project, modelId, null, ids, sources, status, range), new PaginationParams(null, null, orderBy, desc), key);
    }

    public List<IndexResponse> getIndexes(IndexPlanParams indexPlanParams, PaginationParams paginationParams, String key) {
        String project = indexPlanParams.getProject();
        String modelId = indexPlanParams.getModelId();
        List<Long> ids = indexPlanParams.getIds();
        List<IndexEntity.Source> sources = indexPlanParams.getSources();
        List<IndexEntity.Status> status = indexPlanParams.getStatus();
        List<IndexEntity.Range> range = indexPlanParams.getRange();
        String orderBy = paginationParams.getOrderBy();
        Boolean desc = paginationParams.getReverse();
        List<IndexResponse> indexes = this.indexPlanService.getIndexes(indexPlanParams, paginationParams, key);
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (model.isFusionModel()) {
            FusionModel fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, project)).getFusionModel(modelId);
            if (fusionModel != null) {
                String batchId = fusionModel.getBatchModel().getUuid();
                String oldAliasName = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(batchId).getRootFactTableRef().getTableName();
                String tableAlias = model.getRootFactTableRef().getTableName();
                indexes.addAll(this.indexPlanService.getIndexes(project, batchId, key, status, orderBy, desc, sources).stream().filter(index -> IndexEntity.Range.BATCH == index.getIndexRange()).map(index -> this.convertTableIndex((IndexResponse)index, tableAlias, oldAliasName)).collect(Collectors.toList()));
            } else {
                NDataModel streamingModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(model.getFusionId());
                String oldAliasName = model.getRootFactTableRef().getTableName();
                String tableAlias = streamingModel.getRootFactTableRef().getTableName();
                indexes.stream().forEach(index -> this.convertTableIndex((IndexResponse)index, tableAlias, oldAliasName));
            }
        }
        if (!CollectionUtils.isEmpty(ids)) {
            indexes = indexes.stream().filter(index -> ids.contains(index.getId())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(range)) {
            indexes = indexes.stream().filter(index -> index.getIndexRange() == null || range.contains(index.getIndexRange())).collect(Collectors.toList());
        }
        return indexes;
    }

    private IndexResponse convertTableIndex(IndexResponse copy, String tableName, String oldAliasName) {
        copy.getColOrder().stream().forEach(x -> x.changeTableAlias(oldAliasName, tableName));
        copy.setShardByColumns(copy.getShardByColumns().stream().map(x -> this.changeTableAlias((String)x, oldAliasName, tableName)).collect(Collectors.toList()));
        copy.setSortByColumns(copy.getSortByColumns().stream().map(x -> this.changeTableAlias((String)x, oldAliasName, tableName)).collect(Collectors.toList()));
        return copy;
    }

    @Transaction(project=0)
    public void removeIndex(String project, String model, long id, IndexEntity.Range indexRange) {
        NDataModel modelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(model);
        FusionIndexService.checkStreamingIndexEnabled(project, modelDesc);
        if (modelDesc.fusionModelStreamingPart()) {
            this.checkStreamingIndexDeleteEnabledWithIndexRange(project, model, indexRange);
            FusionModel fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, project)).getFusionModel(model);
            String batchId = fusionModel.getBatchModel().getUuid();
            if (IndexEntity.Range.BATCH == indexRange) {
                this.indexPlanService.removeIndex(project, batchId, id);
                return;
            }
            if (IndexEntity.Range.HYBRID == indexRange) {
                this.removeHybridIndex(project, batchId, Sets.newHashSet((Object[])new Long[]{id}));
            }
        }
        this.indexPlanService.removeIndex(project, model, id);
    }

    @Transaction(project=0)
    public void removeIndexes(String project, String modelId, Set<Long> ids) {
        NDataModel modelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (modelDesc.isStreaming() && FusionIndexService.checkStreamingJobAndSegments(project, modelId)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.STREAMING_INDEX_UPDATE_DISABLE, String.format(Locale.ROOT, MsgPicker.getMsg().getStreamingIndexesDelete(), new Object[0]));
        }
        this.indexPlanService.removeIndexes(project, modelId, ids);
    }

    @Transaction(project=0)
    public void batchRemoveIndex(String project, String modelId, Set<Long> ids, IndexEntity.Range indexRange) {
        NDataModel modelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        FusionIndexService.checkStreamingIndexEnabled(project, modelDesc);
        if (!modelDesc.fusionModelStreamingPart()) {
            this.indexPlanService.removeIndexes(project, modelId, ids);
            return;
        }
        this.checkStreamingIndexDeleteEnabledWithIndexRange(project, modelId, indexRange);
        FusionModel fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, project)).getFusionModel(modelId);
        String batchId = fusionModel.getBatchModel().getUuid();
        if (IndexEntity.Range.BATCH == indexRange) {
            this.indexPlanService.removeIndexes(project, batchId, ids);
            return;
        }
        this.indexPlanService.removeIndexes(project, modelId, ids);
        if (IndexEntity.Range.HYBRID == indexRange) {
            this.removeHybridIndex(project, batchId, ids);
        }
    }

    private void checkStreamingIndexDeleteEnabledWithIndexRange(String project, String modelId, IndexEntity.Range indexRange) {
        if (!FusionIndexService.indexChangeEnable(project, modelId, indexRange, Lists.newArrayList((Object[])new IndexEntity.Range[]{IndexEntity.Range.HYBRID, IndexEntity.Range.STREAMING, IndexEntity.Range.EMPTY}))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.STREAMING_INDEX_UPDATE_DISABLE, String.format(Locale.ROOT, MsgPicker.getMsg().getStreamingIndexesDelete(), new Object[0]));
        }
    }

    private void removeHybridIndex(String project, String model, Set<Long> ids) {
        IndexPlan indexPlan = ((NIndexPlanManager)this.getManager(NIndexPlanManager.class, project)).getIndexPlan(model);
        ids.stream().filter(id -> indexPlan.getLayoutEntity(id) != null).forEach(id -> this.indexPlanService.removeIndex(project, model, (long)id));
    }

    public AggIndexResponse calculateAggIndexCount(UpdateRuleBasedCuboidRequest request) {
        if (this.isFusionModel(request.getProject(), request.getModelId())) {
            UpdateRuleBasedCuboidRequest batchRequest = this.convertBatchUpdateRuleReq(request);
            UpdateRuleBasedCuboidRequest streamRequest = this.convertStreamUpdateRuleReq(request);
            AggIndexResponse batchResponse = this.isEmptyAggregationGroups(batchRequest) ? AggIndexResponse.empty() : this.indexPlanService.calculateAggIndexCount(batchRequest);
            AggIndexResponse streamResponse = this.isEmptyAggregationGroups(streamRequest) ? AggIndexResponse.empty() : this.indexPlanService.calculateAggIndexCount(streamRequest);
            return AggIndexResponse.combine(batchResponse, streamResponse, request.getAggregationGroups().stream().map(NAggregationGroup::getIndexRange).collect(Collectors.toList()));
        }
        return this.indexPlanService.calculateAggIndexCount(request);
    }

    public DiffRuleBasedIndexResponse calculateDiffRuleBasedIndex(UpdateRuleBasedCuboidRequest request) {
        if (this.isFusionModel(request.getProject(), request.getModelId())) {
            UpdateRuleBasedCuboidRequest batchRequest = this.convertBatchUpdateRuleReq(request);
            UpdateRuleBasedCuboidRequest streamRequest = this.convertStreamUpdateRuleReq(request);
            DiffRuleBasedIndexResponse batchResponse = this.isEmptyAggregationGroups(batchRequest) ? DiffRuleBasedIndexResponse.empty() : this.indexPlanService.calculateDiffRuleBasedIndex(batchRequest);
            DiffRuleBasedIndexResponse streamResponse = this.isEmptyAggregationGroups(streamRequest) ? DiffRuleBasedIndexResponse.empty() : this.indexPlanService.calculateDiffRuleBasedIndex(streamRequest);
            FusionIndexService.checkStreamingAggEnabled(streamResponse, request.getProject(), request.getModelId());
            return DiffRuleBasedIndexResponse.combine(batchResponse, streamResponse);
        }
        DiffRuleBasedIndexResponse response = this.indexPlanService.calculateDiffRuleBasedIndex(request);
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, request.getProject())).getDataModelDesc(request.getModelId());
        if (NDataModel.ModelType.STREAMING == model.getModelType()) {
            FusionIndexService.checkStreamingAggEnabled(response, request.getProject(), request.getModelId());
        }
        return response;
    }

    private boolean isEmptyAggregationGroups(UpdateRuleBasedCuboidRequest request) {
        return CollectionUtils.isEmpty(request.getAggregationGroups());
    }

    private UpdateRuleBasedCuboidRequest convertStreamUpdateRuleReq(UpdateRuleBasedCuboidRequest request) {
        UpdateRuleBasedCuboidRequest streamRequest = (UpdateRuleBasedCuboidRequest)JsonUtil.deepCopyQuietly((Object)request, UpdateRuleBasedCuboidRequest.class);
        streamRequest.setAggregationGroups(this.getStreamingAggGroup(streamRequest.getAggregationGroups()));
        return streamRequest;
    }

    private UpdateRuleBasedCuboidRequest convertBatchUpdateRuleReq(UpdateRuleBasedCuboidRequest request) {
        UpdateRuleBasedCuboidRequest batchRequest = (UpdateRuleBasedCuboidRequest)JsonUtil.deepCopyQuietly((Object)request, UpdateRuleBasedCuboidRequest.class);
        batchRequest.setAggregationGroups(this.getBatchAggGroup(batchRequest.getAggregationGroups()));
        FusionModel fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, request.getProject())).getFusionModel(request.getModelId());
        batchRequest.setModelId(fusionModel.getBatchModel().getUuid());
        return batchRequest;
    }

    private boolean isFusionModel(String project, String modelId) {
        return ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId).fusionModelStreamingPart();
    }

    private List<NAggregationGroup> getStreamingAggGroup(List<NAggregationGroup> aggregationGroups) {
        return aggregationGroups.stream().filter(agg -> agg.getIndexRange() == IndexEntity.Range.STREAMING || agg.getIndexRange() == IndexEntity.Range.HYBRID).collect(Collectors.toList());
    }

    private List<NAggregationGroup> getBatchAggGroup(List<NAggregationGroup> aggregationGroups) {
        return aggregationGroups.stream().filter(agg -> agg.getIndexRange() == IndexEntity.Range.BATCH || agg.getIndexRange() == IndexEntity.Range.HYBRID).collect(Collectors.toList());
    }

    @Transaction(project=0)
    public void updateShardByColumns(String project, AggShardByColumnsRequest aggShardByColumnsRequest) {
        if (this.isFusionModel(project, aggShardByColumnsRequest.getModelId())) {
            String batchId = this.getBatchModel(project, aggShardByColumnsRequest.getModelId());
            AggShardByColumnsRequest batchRequest = (AggShardByColumnsRequest)JsonUtil.deepCopyQuietly((Object)aggShardByColumnsRequest, AggShardByColumnsRequest.class);
            batchRequest.setModelId(batchId);
            this.indexPlanService.updateShardByColumns(project, batchRequest);
        }
        this.indexPlanService.updateShardByColumns(project, aggShardByColumnsRequest);
    }

    public List<IndexResponse> getAllIndexes(String project, String modelId, String key, List<IndexEntity.Status> status, String orderBy, Boolean desc, List<IndexEntity.Source> sources) {
        if (this.isFusionModel(project, modelId)) {
            String batchId = this.getBatchModel(project, modelId);
            ArrayList<IndexResponse> response = new ArrayList<IndexResponse>();
            List<IndexResponse> batchResponse = this.indexPlanService.getIndexes(project, batchId, key, status, orderBy, desc, sources);
            batchResponse.stream().forEach(index -> index.setIndexRange(IndexEntity.Range.BATCH));
            response.addAll(batchResponse);
            List<IndexResponse> streamingResponse = this.indexPlanService.getIndexes(project, modelId, key, status, orderBy, desc, sources);
            streamingResponse.stream().forEach(index -> index.setIndexRange(IndexEntity.Range.STREAMING));
            response.addAll(streamingResponse);
            return response;
        }
        return this.indexPlanService.getIndexes(project, modelId, key, status, orderBy, desc, sources);
    }

    public List<IndexResponse> getIndexesWithRelatedTables(String project, String modelId, String key, List<IndexEntity.Status> status, String orderBy, Boolean desc, List<IndexEntity.Source> sources, List<Long> batchIndexIds) {
        if (this.isFusionModel(project, modelId)) {
            String batchId = this.getBatchModel(project, modelId);
            ArrayList<IndexResponse> response = new ArrayList<IndexResponse>();
            List<IndexResponse> batchResponse = this.indexPlanService.getIndexesWithRelatedTables(project, batchId, key, status, orderBy, desc, sources, batchIndexIds);
            batchResponse.forEach(index -> index.setIndexRange(IndexEntity.Range.BATCH));
            response.addAll(batchResponse);
            List<IndexResponse> streamingResponse = this.indexPlanService.getIndexes(project, modelId, key, status, orderBy, desc, sources);
            streamingResponse.forEach(index -> index.setIndexRange(IndexEntity.Range.STREAMING));
            response.addAll(streamingResponse);
            return response;
        }
        return this.indexPlanService.getIndexesWithRelatedTables(project, modelId, key, status, orderBy, desc, sources, batchIndexIds);
    }

    public UpdateRuleBasedCuboidRequest convertOpenToInternal(OpenUpdateRuleBasedCuboidRequest request, NDataModel model) {
        this.checkParamPositive(request.getGlobalDimCap());
        LinkedHashMap dimMap = model.getEffectiveDimensions().entrySet().stream().collect(Collectors.toMap(e -> ((TblColRef)e.getValue()).getAliasDotName(), Map.Entry::getKey, (u, v) -> v, LinkedHashMap::new));
        LinkedHashMap meaMap = model.getEffectiveMeasures().entrySet().stream().collect(Collectors.toMap(e -> ((NDataModel.Measure)e.getValue()).getName(), Map.Entry::getKey, (u, v) -> v, LinkedHashMap::new));
        List newAdded = request.getAggregationGroups().stream().map(aggGroup -> {
            NAggregationGroup group = new NAggregationGroup();
            Preconditions.checkNotNull((Object)aggGroup.getDimensions(), (Object)"dimension should not null");
            this.checkParamPositive(aggGroup.getDimCap());
            Map<String, Integer> selectedDimMap = this.extractIds(aggGroup.getDimensions(), dimMap, AggGroupParams.DIMENSION);
            group.setIncludes(selectedDimMap.values().toArray(new Integer[0]));
            String[] measures = this.extractMeasures(aggGroup.getMeasures());
            Map<String, Integer> selectedMeaMap = this.extractIds(measures, meaMap, AggGroupParams.MEASURE);
            group.setMeasures(selectedMeaMap.values().toArray(new Integer[0]));
            SelectRule selectRule = new SelectRule();
            Map<String, Integer> mandatoryDimMap = this.extractIds(aggGroup.getMandatoryDims(), selectedDimMap, AggGroupParams.MANDATORY);
            HashSet<String> allDims = new HashSet<String>(mandatoryDimMap.keySet());
            selectRule.setMandatoryDims(mandatoryDimMap.values().toArray(new Integer[0]));
            selectRule.setHierarchyDims(this.extractJointOrHierarchyIds(aggGroup.getHierarchyDims(), selectedDimMap, allDims, AggGroupParams.HIERARCHY));
            selectRule.setJointDims(this.extractJointOrHierarchyIds(aggGroup.getJointDims(), selectedDimMap, allDims, AggGroupParams.JOINT));
            selectRule.setDimCap(aggGroup.getDimCap() != null ? aggGroup.getDimCap() : request.getGlobalDimCap());
            group.setSelectRule(selectRule);
            return group;
        }).collect(Collectors.toList());
        RuleBasedIndex ruleBasedIndex = this.getRule(request.getProject(), model.getUuid());
        List groups = ruleBasedIndex.getAggregationGroups();
        groups.addAll(newAdded);
        UpdateRuleBasedCuboidRequest result = new UpdateRuleBasedCuboidRequest();
        result.setModelId(model.getUuid());
        result.setProject(request.getProject());
        result.setLoadData(false);
        result.setRestoreDeletedIndex(request.isRestoreDeletedIndex());
        result.setAggregationGroups(groups);
        return result;
    }

    private String[] extractMeasures(String[] measures) {
        if (ArrayUtils.isEmpty((Object[])measures)) {
            return new String[]{COUNT_ALL_MEASURE};
        }
        List<String> list = Arrays.stream(measures).filter(m -> !m.equals(COUNT_ALL_MEASURE)).collect(Collectors.toList());
        list.add(0, COUNT_ALL_MEASURE);
        return list.toArray(new String[0]);
    }

    private void checkParamPositive(Integer dimCap) {
        if (dimCap != null && dimCap <= 0) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.INTEGER_POSITIVE_CHECK, new Object[0]);
        }
    }

    private Map<String, Integer> extractIds(String[] dimOrMeaNames, Map<String, Integer> nameIdMap, AggGroupParams aggGroupParams) {
        if (dimOrMeaNames == null || dimOrMeaNames.length == 0) {
            return new HashMap<String, Integer>();
        }
        Set set = Arrays.stream(dimOrMeaNames).map(str -> aggGroupParams == AggGroupParams.MEASURE ? str : StringUtils.upperCase((String)str, (Locale)Locale.ROOT)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (set.size() < dimOrMeaNames.length) {
            throw new IllegalStateException("Dimension or measure in agg group must not contain duplication: " + Arrays.asList(dimOrMeaNames));
        }
        Map<String, Integer> upperCaseMap = nameIdMap.entrySet().stream().collect(Collectors.toMap(entry -> aggGroupParams == AggGroupParams.MEASURE ? (String)entry.getKey() : StringUtils.upperCase((String)((String)entry.getKey()), (Locale)Locale.ROOT), Map.Entry::getValue));
        if (!upperCaseMap.keySet().containsAll(set)) {
            switch (aggGroupParams) {
                case DIMENSION: {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.DIMENSION_NOT_IN_MODEL, new Object[0]);
                }
                case MEASURE: {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MEASURE_NOT_IN_MODEL, new Object[0]);
                }
                case MANDATORY: {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MANDATORY_NOT_IN_DIMENSION, new Object[0]);
                }
                case HIERARCHY: {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.HIERARCHY_NOT_IN_DIMENSION, new Object[0]);
                }
                case JOINT: {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOINT_NOT_IN_DIMENSION, new Object[0]);
                }
            }
            throw new IllegalStateException("this should not happen");
        }
        return set.stream().collect(Collectors.toMap(Function.identity(), upperCaseMap::get, (v1, v2) -> v1, LinkedHashMap::new));
    }

    private Integer[][] extractJointOrHierarchyIds(String[][] origins, Map<String, Integer> selectedDimMap, Set<String> allDims, AggGroupParams aggGroupParams) {
        if (origins == null || origins.length == 0) {
            return new Integer[0][];
        }
        Integer[][] result = new Integer[origins.length][];
        for (int i = 0; i < origins.length; ++i) {
            if (ArrayUtils.isEmpty((Object[])origins[i])) continue;
            Map<String, Integer> tmp = this.extractIds(origins[i], selectedDimMap, aggGroupParams);
            if (Sets.intersection(tmp.keySet(), allDims).isEmpty()) {
                allDims.addAll(tmp.keySet());
                result[i] = tmp.values().toArray(new Integer[0]);
                continue;
            }
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.DIMENSION_ONLY_SET_ONCE, new Object[0]);
        }
        return result;
    }

    private String getBatchModel(String project, String modelId) {
        FusionModel fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, project)).getFusionModel(modelId);
        return fusionModel.getBatchModel().getId();
    }

    private static void checkStreamingAggEnabled(DiffRuleBasedIndexResponse streamResponse, String project, String modelId) {
        if ((streamResponse.getDecreaseLayouts() > 0 || streamResponse.getIncreaseLayouts() > 0) && FusionIndexService.checkStreamingJobAndSegments(project, modelId)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.STREAMING_INDEX_UPDATE_DISABLE, MsgPicker.getMsg().getStreamingIndexesEdit());
        }
    }

    public static boolean checkUpdateIndexEnabled(String project, String modelId) {
        NDataModel model = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataModelDesc(modelId);
        if (model == null) {
            log.warn("model {} is not existed in project:{}", (Object)modelId, (Object)project);
            return false;
        }
        return NDataModel.ModelType.STREAMING != model.getModelType() && NDataModel.ModelType.HYBRID != model.getModelType() || !FusionIndexService.checkStreamingJobAndSegments(project, model.getUuid());
    }

    private static void checkStreamingIndexEnabled(String project, NDataModel model) throws KylinException {
        if (NDataModel.ModelType.STREAMING == model.getModelType() && FusionIndexService.checkStreamingJobAndSegments(project, model.getUuid())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.STREAMING_INDEX_UPDATE_DISABLE, MsgPicker.getMsg().getStreamingIndexesDelete());
        }
    }

    private static boolean indexChangeEnable(String project, String modelId, IndexEntity.Range range, List<IndexEntity.Range> ranges) {
        if (!ranges.contains(range)) {
            return true;
        }
        return !FusionIndexService.checkStreamingJobAndSegments(project, modelId);
    }

    public static boolean checkStreamingJobAndSegments(String project, String modelId) {
        String jobId = StreamingUtils.getJobId((String)modelId, (String)JobTypeEnum.STREAMING_BUILD.name());
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)config, (String)project);
        StreamingJobMeta meta = mgr.getStreamingJobByUuid(jobId);
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        NDataflow df = dataflowManager.getDataflow(modelId);
        if (meta == null) {
            return !df.getSegments().isEmpty();
        }
        return runningStatus.contains(meta.getCurrentStatus()) || !df.getSegments().isEmpty();
    }

    static enum AggGroupParams {
        DIMENSION,
        MEASURE,
        MANDATORY,
        HIERARCHY,
        JOINT;

    }
}

