/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;

public class SnapshotColResponse
implements Comparable<SnapshotColResponse> {
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="partition_col")
    private String partitionCol;
    @JsonProperty(value="partition_col_type")
    private String partitionColType;
    @JsonProperty(value="other_column_and_type")
    private Map<String, String> otherCol;
    @JsonProperty(value="source_type")
    private int sourceType;

    public SnapshotColResponse(String database, String table, String partitionCol, String partitionColType, Map<String, String> otherCol, int sourceType) {
        this.database = database;
        this.table = table;
        this.partitionCol = partitionCol;
        this.partitionColType = partitionColType;
        this.otherCol = otherCol;
        this.sourceType = sourceType;
    }

    public static SnapshotColResponse from(TableDesc table) {
        if (table.getPartitionColumn() != null) {
            ColumnDesc partCol = table.findColumnByName(table.getPartitionColumn());
            return new SnapshotColResponse(table.getDatabase(), table.getName(), partCol.getName(), partCol.getDatatype(), SnapshotColResponse.excludePartCol(table.getColumns(), partCol.getName()), table.getSourceType());
        }
        return new SnapshotColResponse(table.getDatabase(), table.getName(), null, null, SnapshotColResponse.excludePartCol(table.getColumns(), null), table.getSourceType());
    }

    public static SnapshotColResponse from(TableDesc table, UnaryOperator<SnapshotColResponse> transform) {
        SnapshotColResponse res = SnapshotColResponse.from(table);
        return transform != null ? (SnapshotColResponse)transform.apply(res) : res;
    }

    private static Map<String, String> excludePartCol(ColumnDesc[] columns, String partitionCol) {
        return Arrays.asList(columns).stream().filter(col -> !col.getName().equals(partitionCol)).collect(Collectors.toMap(ColumnDesc::getName, ColumnDesc::getDatatype));
    }

    @Override
    public int compareTo(SnapshotColResponse other) {
        if (this.database.compareTo(other.database) != 0) {
            return this.database.compareTo(other.database);
        }
        return this.table.compareTo(other.table);
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String getPartitionCol() {
        return this.partitionCol;
    }

    @Generated
    public String getPartitionColType() {
        return this.partitionColType;
    }

    @Generated
    public Map<String, String> getOtherCol() {
        return this.otherCol;
    }

    @Generated
    public int getSourceType() {
        return this.sourceType;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public void setPartitionCol(String partitionCol) {
        this.partitionCol = partitionCol;
    }

    @Generated
    public void setPartitionColType(String partitionColType) {
        this.partitionColType = partitionColType;
    }

    @Generated
    public void setOtherCol(Map<String, String> otherCol) {
        this.otherCol = otherCol;
    }

    @Generated
    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }
}

