/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.FusionModel;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.rest.constant.ModelStatusToDisplayEnum;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.response.NDataSegmentResponse;
import org.apache.kylin.rest.util.ModelUtils;

public class FusionModelResponse
extends NDataModelResponse {
    @JsonProperty(value="batch_id")
    private String batchId;
    @JsonProperty(value="streaming_indexes")
    private long streamingIndexes;
    @JsonProperty(value="batch_partition_desc")
    private PartitionDesc batchPartitionDesc;
    @JsonProperty(value="batch_segments")
    private List<NDataSegmentResponse> batchSegments = new ArrayList<NDataSegmentResponse>();
    @JsonProperty(value="batch_segment_holes")
    private List<SegmentRange> batchSegmentHoles;

    public FusionModelResponse(NDataModel dataModel) {
        super(dataModel);
    }

    @Override
    protected void computedDisplayInfo(NDataModel modelDesc) {
        NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        NDataflow streamingDataflow = dfManager.getDataflow(modelDesc.getUuid());
        FusionModel fusionModel = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject()).getFusionModel(modelDesc.getFusionId());
        NDataModel batchModel = fusionModel.getBatchModel();
        if (batchModel.isBroken() || modelDesc.isBroken()) {
            this.setStatus(ModelStatusToDisplayEnum.BROKEN);
        }
        this.setBatchId(batchModel.getUuid());
        this.setFusionId(modelDesc.getFusionId());
        this.setBatchId(fusionModel.getBatchModel().getUuid());
        NDataflow batchDataflow = dfManager.getDataflow(this.batchId);
        this.setLastBuildTime(this.getMaxLastBuildTime(batchDataflow, streamingDataflow));
        this.setStorage(this.getTotalStorage(batchDataflow, streamingDataflow));
        this.setSource(this.getTotalSource(batchDataflow, streamingDataflow));
        this.setBatchSegmentHoles(this.calculateTotalSegHoles(batchDataflow));
        this.setSegmentHoles(this.calculateTotalSegHoles(streamingDataflow));
        this.setExpansionrate(ModelUtils.computeExpansionRate(this.getStorage(), this.getSource()));
        this.setUsage(this.getTotalUsage(streamingDataflow));
        this.setInconsistentSegmentCount(this.getTotalInconsistentSegmentCount(batchDataflow, streamingDataflow));
        if (!modelDesc.isBroken() && !batchModel.isBroken()) {
            this.setHasSegments(CollectionUtils.isNotEmpty((Collection)streamingDataflow.getSegments()) || CollectionUtils.isNotEmpty((Collection)batchDataflow.getSegments()));
            this.setBatchPartitionDesc(fusionModel.getBatchModel().getPartitionDesc());
            NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
            IndexPlan batchIndex = indexPlanManager.getIndexPlan(this.batchId);
            IndexPlan streamingIndex = indexPlanManager.getIndexPlan(modelDesc.getUuid());
            this.setAvailableIndexesCount(this.getTotalAvailableIndexesCount(batchIndex, streamingIndex));
            this.setTotalIndexes(this.getIndexesCount(batchIndex));
            this.setStreamingIndexes(this.getIndexesCount(streamingIndex));
            this.setEmptyIndexesCount(this.getTotalIndexes() - this.getAvailableIndexesCount());
            this.setHasBaseAggIndex(batchIndex.containBaseAggLayout());
            this.setHasBaseTableIndex(batchIndex.containBaseTableLayout());
        }
    }

    private long getMaxLastBuildTime(NDataflow batchDataflow, NDataflow streamingDataflow) {
        return Math.max(batchDataflow.getLastBuildTime(), streamingDataflow.getLastBuildTime());
    }

    private long getTotalStorage(NDataflow batchDataflow, NDataflow streamingDataflow) {
        return batchDataflow.getStorageBytesSize() + streamingDataflow.getStorageBytesSize();
    }

    private long getTotalSource(NDataflow batchDataflow, NDataflow streamingDataflow) {
        return batchDataflow.getSourceBytesSize() + streamingDataflow.getSourceBytesSize();
    }

    private List<SegmentRange> calculateTotalSegHoles(NDataflow batchDataflow) {
        NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        return dfManager.calculateSegHoles(batchDataflow.getUuid());
    }

    private long getTotalUsage(NDataflow streamingDataflow) {
        return streamingDataflow.getQueryHitCount();
    }

    private long getTotalInconsistentSegmentCount(NDataflow batchDataflow, NDataflow streamingDataflow) {
        return (long)batchDataflow.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.WARNING}).size() + (long)streamingDataflow.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.WARNING}).size();
    }

    private long getTotalAvailableIndexesCount(IndexPlan batchIndex, IndexPlan streamingIndex) {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        return indexPlanManager.getAvailableIndexesCount(this.getProject(), batchIndex.getId()) + indexPlanManager.getAvailableIndexesCount(this.getProject(), streamingIndex.getId());
    }

    private long getIndexesCount(IndexPlan indexPlan) {
        return indexPlan.getAllLayouts().size();
    }

    @Generated
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Generated
    public void setStreamingIndexes(long streamingIndexes) {
        this.streamingIndexes = streamingIndexes;
    }

    @Generated
    public void setBatchPartitionDesc(PartitionDesc batchPartitionDesc) {
        this.batchPartitionDesc = batchPartitionDesc;
    }

    @Generated
    public void setBatchSegments(List<NDataSegmentResponse> batchSegments) {
        this.batchSegments = batchSegments;
    }

    @Generated
    public void setBatchSegmentHoles(List<SegmentRange> batchSegmentHoles) {
        this.batchSegmentHoles = batchSegmentHoles;
    }

    @Generated
    public String getBatchId() {
        return this.batchId;
    }

    @Generated
    public long getStreamingIndexes() {
        return this.streamingIndexes;
    }

    @Generated
    public PartitionDesc getBatchPartitionDesc() {
        return this.batchPartitionDesc;
    }

    @Generated
    public List<NDataSegmentResponse> getBatchSegments() {
        return this.batchSegments;
    }

    @Generated
    public List<SegmentRange> getBatchSegmentHoles() {
        return this.batchSegmentHoles;
    }
}

