/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.sql.SQLException;
import java.util.Locale;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.sdk.datasource.framework.conv.ConvMaster;
import org.apache.kylin.sdk.datasource.framework.conv.ConvRownumSqlWriter;
import org.apache.kylin.sdk.datasource.framework.conv.ConvSqlWriter;
import org.apache.kylin.sdk.datasource.framework.conv.SingleSqlNodeReplacer;
import org.apache.kylin.sdk.datasource.framework.conv.SqlNodeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConverter {
    private static final Logger logger = LoggerFactory.getLogger(SqlConverter.class);
    private final IConfigurer configurer;
    private final SqlNodeConverter sqlNodeConverter;
    private final SingleSqlNodeReplacer singleSqlNodeReplacer;

    public SqlConverter(IConfigurer configurer, ConvMaster convMaster) throws SQLException {
        this.sqlNodeConverter = new SqlNodeConverter(convMaster);
        this.configurer = configurer;
        this.singleSqlNodeReplacer = new SingleSqlNodeReplacer(convMaster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertSql(String orig) {
        String converted = orig;
        if (!this.configurer.skipHandleDefault()) {
            String escapedDefault = SqlDialect.DatabaseProduct.CALCITE.getDialect().quoteIdentifier(this.configurer.useUppercaseDefault() ? "DEFAULT" : "default");
            converted = converted.replaceAll("(?i)default\\.", escapedDefault + ".");
            converted = converted.replaceAll("\"(?i)default\"\\.", escapedDefault + ".");
        }
        if (!this.configurer.skipDefaultConvert()) {
            ConvSqlWriter sqlWriter = null;
            String beforeConvert = converted;
            try {
                converted = converted.replace("`", "\"");
                sqlWriter = this.getConvSqlWriter();
                SqlNode sqlNode = SqlParser.create((String)converted).parseQuery();
                sqlNode = (SqlNode)sqlNode.accept((SqlVisitor)this.sqlNodeConverter);
                converted = sqlWriter.format(sqlNode);
            }
            catch (Exception e) {
                logger.error("Failed to default convert sql, will use the origin input: {}", (Object)beforeConvert, (Object)e);
                converted = beforeConvert;
            }
            finally {
                if (sqlWriter != null) {
                    sqlWriter.reset();
                }
            }
        }
        converted = this.configurer.fixAfterDefaultConvert(converted);
        return converted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertColumn(String column, String originQuote) {
        String converted = column;
        if (StringUtils.isNotEmpty((CharSequence)originQuote)) {
            converted = column.replace(originQuote, "\"");
        }
        ConvSqlWriter sqlWriter = null;
        try {
            sqlWriter = this.getConvSqlWriter();
            SqlNode sqlNode = SqlParser.create((String)converted).parseExpression();
            sqlNode = (SqlNode)sqlNode.accept((SqlVisitor)this.sqlNodeConverter);
            converted = sqlWriter.format(sqlNode);
            converted = this.configurer.fixAfterDefaultConvert(converted);
        }
        catch (Throwable e) {
            logger.error("Failed to default convert Column, will use the input: {}", (Object)column, (Object)e);
        }
        finally {
            if (sqlWriter != null) {
                sqlWriter.reset();
            }
        }
        return converted;
    }

    public String formatDateColumn(String column, DataType colType, String format) {
        String formated = column;
        if (this.configurer.enableTransformDateToString() && colType != null && colType.isDateTimeFamily()) {
            String datePattern = StringUtils.isNotEmpty((CharSequence)format) ? format : this.configurer.getTransformDatePattern();
            String template = this.configurer.getTransformDateToStringExpression();
            formated = String.format(Locale.ROOT, template, column, datePattern);
        }
        return this.convertColumn(formated, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertDateCondition(String orig, String partColumn, DataType partColType, String partColFormat) {
        String converted = orig.replaceAll("`", "\"");
        if (this.configurer.enableTransformDateToString() && partColType != null && partColType.isDateTimeFamily()) {
            ConvSqlWriter sqlWhereWriter = null;
            try {
                SqlNode sqlNodeWhere;
                SqlNode sqlNode = SqlParser.create((String)converted).parseQuery();
                if (sqlNode instanceof SqlSelect && (sqlNodeWhere = ((SqlSelect)sqlNode).getWhere()) != null) {
                    ((SqlSelect)sqlNode).setWhere(null);
                    sqlWhereWriter = this.getConvSqlWriter();
                    String strSelect = sqlWhereWriter.format(sqlNode);
                    StringBuilder sb = new StringBuilder(strSelect);
                    sqlWhereWriter.reset();
                    String datePattern = StringUtils.isNotEmpty((CharSequence)partColFormat) ? partColFormat : this.configurer.getTransformDatePattern();
                    String template = this.configurer.getTransformDateToStringExpression();
                    if (StringUtils.isNotEmpty((CharSequence)template)) {
                        SqlNode sqlNodeTryToFind = SqlParser.create((String)partColumn).parseExpression();
                        SqlNode sqlNodeToReplace = SqlParser.create((String)String.format(Locale.ROOT, template, partColumn, datePattern)).parseExpression();
                        this.singleSqlNodeReplacer.setSqlNodeTryToFind(sqlNodeTryToFind);
                        this.singleSqlNodeReplacer.setSqlNodeToReplace(sqlNodeToReplace);
                        sqlNodeWhere = (SqlNode)sqlNodeWhere.accept((SqlVisitor)this.singleSqlNodeReplacer);
                    }
                    String sqlWhere = sqlWhereWriter.format(sqlNodeWhere);
                    sb.append(" WHERE ").append(sqlWhere);
                    String string = sb.toString();
                    return string;
                }
            }
            catch (Throwable e) {
                logger.error("Failed to default convert date condition for sqoop, will use the input: {}", (Object)orig, (Object)e);
            }
            finally {
                if (sqlWhereWriter != null) {
                    sqlWhereWriter.reset();
                }
            }
        }
        return converted;
    }

    public IConfigurer getConfigurer() {
        return this.configurer;
    }

    private ConvSqlWriter getConvSqlWriter() throws SQLException {
        ConvSqlWriter sqlWriter = "ROWNUM".equalsIgnoreCase(this.configurer.getPagingType()) ? new ConvRownumSqlWriter(this.configurer) : new ConvSqlWriter(this.configurer);
        sqlWriter.setQuoteAllIdentifiers(false);
        return sqlWriter;
    }

    public static interface IConfigurer {
        default public boolean skipDefaultConvert() {
            return false;
        }

        default public boolean skipHandleDefault() {
            return false;
        }

        default public boolean useUppercaseDefault() {
            return false;
        }

        default public String fixAfterDefaultConvert(String orig) {
            return orig;
        }

        default public SqlDialect getSqlDialect() {
            return CalciteSqlDialect.DEFAULT;
        }

        default public boolean allowNoOffset() {
            return false;
        }

        default public boolean allowFetchNoRows() {
            return false;
        }

        default public boolean allowNoOrderByWithFetch() {
            return false;
        }

        default public String getPagingType() {
            return "AUTO";
        }

        default public boolean isCaseSensitive() {
            return false;
        }

        default public boolean enableCache() {
            return false;
        }

        default public boolean enableQuote() {
            return false;
        }

        default public String fixIdentifierCaseSensitive(String orig) {
            return orig;
        }

        default public boolean enableTransformDateToString() {
            return false;
        }

        default public String getTransformDateToStringExpression() {
            return "";
        }

        default public String getTransformDatePattern() {
            return "";
        }
    }
}

