/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework;

import java.util.HashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.sdk.datasource.adaptor.AdaptorConfig;
import org.apache.kylin.sdk.datasource.adaptor.DefaultAdaptor;
import org.apache.kylin.sdk.datasource.adaptor.MysqlAdaptor;
import org.apache.kylin.sdk.datasource.framework.AdaptorFactory;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.sdk.datasource.framework.utils.JdbcUtils;

public class SourceConnectorFactory {
    private SourceConnectorFactory() {
    }

    public static JdbcConnector getJdbcConnector(KylinConfig config) {
        String jdbcUrl = config.getJdbcConnectionUrl();
        String jdbcDriver = config.getJdbcDriver();
        String jdbcUser = config.getJdbcUser();
        String jdbcPass = config.getJdbcPass();
        String adaptorClazz = config.getJdbcAdaptorClass();
        if (KylinConfig.getInstanceFromEnv().isSourceJdbcWhiteListEnabled() && !JdbcUtils.validateUrlByWhiteList(jdbcUrl)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_JDBC_SOURCE_CONFIG, MsgPicker.getMsg().getJdbcConnectionInfoWrong());
        }
        HashMap<String, String> options = new HashMap();
        if (config instanceof KylinConfigExt) {
            options = ((KylinConfigExt)config).getExtendedOverrides();
        }
        AdaptorConfig jdbcConf = new AdaptorConfig(jdbcUrl, jdbcDriver, jdbcUser, jdbcPass, options);
        jdbcConf.poolMaxIdle = config.getPoolMaxIdle();
        jdbcConf.poolMinIdle = config.getPoolMinIdle();
        jdbcConf.poolMaxTotal = config.getPoolMaxTotal();
        jdbcConf.datasourceId = config.getJdbcDialect();
        jdbcConf.setConnectRetryTimes(config.getJdbcConnectRetryTimes());
        jdbcConf.setSleepMillisecBetweenRetry(config.getJdbcSleepIntervalBetweenRetry());
        if (adaptorClazz == null) {
            adaptorClazz = SourceConnectorFactory.decideAdaptorClassName(jdbcConf.datasourceId);
        }
        try {
            return new JdbcConnector(AdaptorFactory.createJdbcAdaptor(adaptorClazz, jdbcConf));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get JdbcConnector from env.", e);
        }
    }

    private static String decideAdaptorClassName(String dataSourceId) {
        switch (dataSourceId) {
            case "mysql": {
                return MysqlAdaptor.class.getName();
            }
        }
        return DefaultAdaptor.class.getName();
    }
}

