/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl.info;

import java.util.Dictionary;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.karaf.shell.commands.impl.info.PojoInfoProvider;
import org.apache.karaf.shell.commands.info.InfoProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoBundleTrackerCustomizer
implements BundleTrackerCustomizer<ServiceRegistration<InfoProvider>> {
    private Logger logger = LoggerFactory.getLogger(InfoBundleTrackerCustomizer.class);

    public ServiceRegistration<InfoProvider> addingBundle(Bundle bundle, BundleEvent event) {
        Dictionary headers = bundle.getHeaders();
        String headerEntry = (String)headers.get("Karaf-Info");
        InfoProvider provider = this.createInfo(headerEntry);
        if (provider == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Ignore incorrect info {} provided by bundle {}", (Object)headerEntry, (Object)bundle.getSymbolicName());
            }
            return null;
        }
        return bundle.getBundleContext().registerService(InfoProvider.class, (Object)provider, null);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, ServiceRegistration<InfoProvider> object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, ServiceRegistration<InfoProvider> object) {
        object.unregister();
    }

    private InfoProvider createInfo(String entry) {
        if (entry == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(entry, ";=");
        if (tokenizer.countTokens() < 3) {
            return null;
        }
        String name = tokenizer.nextToken();
        Properties properties = new Properties();
        do {
            String property = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                properties.put(property, tokenizer.nextElement());
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Ignore property {} without value", (Object)property);
        } while (tokenizer.hasMoreTokens());
        return new PojoInfoProvider(name, properties);
    }
}

