/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.lang.reflect.Method;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class BundleHelper {
    private static final SecurityManagerEx securityManager = new SecurityManagerEx();
    private static final Method getBundleMethod;

    private BundleHelper() {
    }

    public static Bundle getCallerBundle(Bundle defaultBundle) {
        return BundleHelper.getCallerBundle(defaultBundle, 2);
    }

    public static Bundle getCallerBundle(Bundle defaultBundle, int skip) {
        if (getBundleMethod == null) {
            return defaultBundle;
        }
        try {
            Class[] classCtx = securityManager.getClassContext();
            Bundle curBundle = null;
            for (int i = skip; i < classCtx.length; ++i) {
                Bundle bundle = FrameworkUtil.getBundle((Class)classCtx[i]);
                if (!(bundle != null || classCtx[i].getPackage() != null && classCtx[i].getPackage().getName().equals("java.util.logging"))) {
                    return defaultBundle;
                }
                if (curBundle == null) {
                    curBundle = bundle;
                    continue;
                }
                if (bundle == null || bundle == curBundle) continue;
                return bundle;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultBundle;
    }

    public static Bundle getCallerBundle(Bundle defaultBundle, String fqcn) {
        if (getBundleMethod == null) {
            return defaultBundle;
        }
        try {
            Class[] classCtx = securityManager.getClassContext();
            int previousClass = -1;
            for (int i = classCtx.length - 1; i >= 0; --i) {
                if (previousClass != -1 && classCtx[i].getName().equals(fqcn)) {
                    Bundle bundle = FrameworkUtil.getBundle((Class)classCtx[previousClass]);
                    if (bundle == null) continue;
                    return bundle;
                }
                previousClass = i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultBundle;
    }

    static {
        Method mth = null;
        try {
            mth = FrameworkUtil.class.getMethod("getBundle", Class.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getBundleMethod = mth;
    }

    static class SecurityManagerEx
    extends SecurityManager {
        SecurityManagerEx() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

