/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.management;

import java.lang.annotation.Annotation;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.NotificationSender;
import org.apache.camel.api.management.NotificationSenderAware;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.support.management.MBeanInfoAssembler;
import org.apache.camel.support.management.MixinRequiredModelMBean;
import org.apache.camel.support.management.NotificationSenderAdapter;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementMBeanAssembler
extends ServiceSupport
implements ManagementMBeanAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagementMBeanAssembler.class);
    protected final MBeanInfoAssembler assembler;
    protected final CamelContext camelContext;

    public DefaultManagementMBeanAssembler(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.assembler = new MBeanInfoAssembler(camelContext);
    }

    public ModelMBean assemble(MBeanServer mBeanServer, Object obj, ObjectName name) throws JMException {
        boolean sanitize;
        ModelMBeanInfo mbi = null;
        ModelMBeanInfo standardMbi = null;
        Object custom = null;
        if (obj instanceof ManagedInstance && (custom = ((ManagedInstance)obj).getInstance()) != null && ObjectHelper.hasAnnotation((Annotation[])custom.getClass().getAnnotations(), ManagedResource.class)) {
            LOG.trace("Assembling MBeanInfo for: {} from custom @ManagedResource object: {}", (Object)name, custom);
            mbi = this.assembler.getMBeanInfo(this.camelContext, obj, custom, name.toString());
            standardMbi = this.assembler.getMBeanInfo(this.camelContext, obj, null, name.toString());
        }
        if (mbi == null) {
            LOG.trace("Assembling MBeanInfo for: {} from @ManagedResource object: {}", (Object)name, obj);
            mbi = this.assembler.getMBeanInfo(this.camelContext, obj, null, name.toString());
        }
        if (mbi == null) {
            return null;
        }
        RequiredModelMBean mixinMBean = null;
        boolean bl = sanitize = this.camelContext.getManagementStrategy().getManagementAgent().getMask() != null && this.camelContext.getManagementStrategy().getManagementAgent().getMask() != false;
        if (standardMbi != null) {
            mixinMBean = (RequiredModelMBean)mBeanServer.instantiate(RequiredModelMBean.class.getName());
            mixinMBean.setModelMBeanInfo(standardMbi);
            try {
                mixinMBean.setManagedResource(obj, "ObjectReference");
            }
            catch (InvalidTargetObjectTypeException e) {
                throw new JMException(e.getMessage());
            }
            obj = custom;
        }
        MixinRequiredModelMBean mbean = new MixinRequiredModelMBean(mbi, sanitize, standardMbi, mixinMBean);
        try {
            mbean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new JMException(e.getMessage());
        }
        if (obj instanceof NotificationSenderAware) {
            ((NotificationSenderAware)obj).setNotificationSender((NotificationSender)new NotificationSenderAdapter(mbean));
        }
        return mbean;
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.assembler);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.assembler);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.assembler);
    }
}

