/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.kafka.shell.state;

import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.shell.node.RootShellNode;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Publishes changes to the Kafka Metadata Shell.
 */
public class MetadataShellPublisher implements MetadataPublisher {
    private static final Logger log = LoggerFactory.getLogger(MetadataShellPublisher.class);

    private final MetadataShellState state;

    public MetadataShellPublisher(MetadataShellState state) {
        this.state = state;
    }

    @Override
    public String name() {
        return "MetadataShellPublisher";
    }

    @Override
    public void onMetadataUpdate(
        MetadataDelta delta,
        MetadataImage newImage,
        LoaderManifest manifest
    ) {
        log.trace("onMetadataUpdate newImage={}", newImage);
        state.setRoot(new RootShellNode(newImage));
    }

    public MetadataShellState state() {
        return state;
    }
}
