/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;

public final class Args
extends JsonMap {
    private static final long serialVersionUID = 1L;

    public Args(String[] args) {
        String s;
        LinkedList<String> argList = CollectionUtils.linkedList(args);
        int i = 0;
        while (!argList.isEmpty() && !StringUtils.startsWith((String)(s = (String)argList.get(0)), (char)'-')) {
            this.put(Integer.toString(i), argList.remove(0));
            ++i;
        }
        String key = null;
        while (!argList.isEmpty()) {
            String s2 = (String)argList.remove(0);
            if (StringUtils.startsWith((String)s2, (char)'-')) {
                key = s2.substring(1);
                if (key.matches("\\d*")) {
                    throw new BasicRuntimeException("Invalid optional key name ''{0}''", key);
                }
                if (this.containsKey(key)) continue;
                this.put(key, (Object)new JsonList());
                continue;
            }
            ((JsonList)this.get(key)).add(s2);
        }
    }

    public Args(String args) {
        this(StringUtils.splitQuoted((String)args));
    }

    public String getArg(int i) {
        return this.getString(Integer.toString(i));
    }

    public boolean hasArg(int i) {
        return this.containsKey(Integer.toString(i));
    }

    public boolean hasArg(String name) {
        JsonList l = (JsonList)this.get(name);
        return l != null;
    }

    public String getArg(String name) {
        JsonList l = (JsonList)this.get(name);
        if (l == null || l.isEmpty()) {
            return null;
        }
        if (l.size() == 1) {
            return l.get(0).toString();
        }
        return Arrays.toString(l.toArray()).replaceAll("[\\[\\]]", "");
    }

    public <T> T getArg(Class<T> c, String name) {
        JsonList l = (JsonList)this.get(name);
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l.get(0, c);
    }

    public List<String> getArgs(String name) {
        JsonList l = (JsonList)this.get(name);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }
}

